/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.action.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;

public class SqlClearCursorRequest
extends AbstractSqlRequest {
    private static final ConstructingObjectParser<SqlClearCursorRequest, Void> PARSER = new ConstructingObjectParser("indices:data/read/sql/close_cursor", objects -> {
        RequestInfo requestInfo = new RequestInfo(Mode.fromString((String)((String)objects[1])), (String)objects[2]);
        return new SqlClearCursorRequest(requestInfo, (String)objects[0]);
    });
    private String cursor;

    public SqlClearCursorRequest() {
    }

    public SqlClearCursorRequest(RequestInfo requestInfo, String cursor) {
        super(requestInfo);
        this.cursor = cursor;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.getCursor() == null) {
            validationException = ValidateActions.addValidationError((String)"cursor is required", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getCursor() {
        return this.cursor;
    }

    public SqlClearCursorRequest setCursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public String getDescription() {
        return "SQL Clean cursor [" + this.getCursor() + "]";
    }

    public SqlClearCursorRequest(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cursor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlClearCursorRequest that = (SqlClearCursorRequest)((Object)o);
        return Objects.equals(this.cursor, that.cursor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor);
    }

    public static SqlClearCursorRequest fromXContent(XContentParser parser) {
        return (SqlClearCursorRequest)((Object)PARSER.apply(parser, null));
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), AbstractSqlQueryRequest.CURSOR);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AbstractSqlQueryRequest.MODE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AbstractSqlQueryRequest.CLIENT_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AbstractSqlQueryRequest.VERSION);
    }
}

