/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.script.field.ToScriptField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongFieldMapper;

public class UnsignedLongLeafFieldData
implements LeafNumericFieldData {
    private final LeafNumericFieldData signedLongFD;
    protected final ToScriptField<SortedNumericDocValues> toScriptField;

    UnsignedLongLeafFieldData(LeafNumericFieldData signedLongFD, ToScriptField<SortedNumericDocValues> toScriptField) {
        this.signedLongFD = signedLongFD;
        this.toScriptField = toScriptField;
    }

    public SortedNumericDocValues getLongValues() {
        return this.signedLongFD.getLongValues();
    }

    public SortedNumericDoubleValues getDoubleValues() {
        final SortedNumericDocValues values = this.signedLongFD.getLongValues();
        final NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleValues != null) {
            return FieldData.singleton((NumericDoubleValues)new NumericDoubleValues(){

                public boolean advanceExact(int doc) throws IOException {
                    return singleValues.advanceExact(doc);
                }

                public double doubleValue() throws IOException {
                    return UnsignedLongLeafFieldData.convertUnsignedLongToDouble(singleValues.longValue());
                }
            });
        }
        return new SortedNumericDoubleValues(){

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public double nextValue() throws IOException {
                return UnsignedLongLeafFieldData.convertUnsignedLongToDouble(values.nextValue());
            }

            public int docValueCount() {
                return values.docValueCount();
            }
        };
    }

    public DocValuesField<?> getScriptField(String name) {
        return this.toScriptField.getScriptField((Object)this.getLongValues(), name);
    }

    public SortedBinaryDocValues getBytesValues() {
        return FieldData.toString((SortedNumericDoubleValues)this.getDoubleValues());
    }

    public long ramBytesUsed() {
        return this.signedLongFD.ramBytesUsed();
    }

    public void close() {
        this.signedLongFD.close();
    }

    public FormattedDocValues getFormattedValues(final DocValueFormat format) {
        final SortedNumericDocValues values = this.getLongValues();
        return new FormattedDocValues(){

            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            public int docValueCount() {
                return values.docValueCount();
            }

            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }

    static double convertUnsignedLongToDouble(long value) {
        if (value < 0L) {
            return UnsignedLongFieldMapper.sortableSignedLongToUnsigned(value);
        }
        return 9.223372036854776E18 + (double)value;
    }
}

