/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.symbol.Decorator;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.SemanticScope;

public class Decorations {

    public static interface InstanceCapturingFunctionRef
    extends Decorator.Condition {
    }

    public static interface InstanceCapturingLambda
    extends Decorator.Condition {
    }

    public static interface IsDocument
    extends Decorator.Condition {
    }

    public record Converter(FunctionTable.LocalFunction converter) implements Decorator.Decoration
    {
    }

    public record IRNodeDecoration(IRNode irNode) implements Decorator.Decoration
    {
    }

    public record AccessDepth(int accessDepth) implements Decorator.Decoration
    {
    }

    public static interface Compound
    extends Decorator.Condition {
    }

    public static interface Negate
    extends Decorator.Condition {
    }

    public record InstanceType(Class<?> instanceType) implements Decorator.Decoration
    {
        public String getInstanceCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.instanceType);
        }
    }

    public static interface CaptureBox
    extends Decorator.Condition {
    }

    public record CapturesDecoration(List<SemanticScope.Variable> captures) implements Decorator.Decoration
    {
        public CapturesDecoration(List<SemanticScope.Variable> captures) {
            this.captures = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(captures)));
        }
    }

    public record EncodingDecoration(Def.Encoding encoding) implements Decorator.Decoration
    {
        public static EncodingDecoration of(boolean isStatic, boolean needsInstance, String symbol, String methodName, int captures) {
            return new EncodingDecoration(new Def.Encoding(isStatic, needsInstance, symbol, methodName, captures));
        }
    }

    public record ReferenceDecoration(FunctionRef reference) implements Decorator.Decoration
    {
    }

    public record ParameterNames(List<String> parameterNames) implements Decorator.Decoration
    {
        public ParameterNames(List<String> parameterNames) {
            this.parameterNames = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(parameterNames)));
        }
    }

    public record TypeParameters(List<Class<?>> typeParameters) implements Decorator.Decoration
    {
        public TypeParameters(List<Class<?>> typeParameters) {
            this.typeParameters = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(typeParameters)));
        }
    }

    public record ReturnType(Class<?> returnType) implements Decorator.Decoration
    {
        public String getReturnCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.returnType);
        }
    }

    public record MethodNameDecoration(String methodName) implements Decorator.Decoration
    {
    }

    public record StandardPainlessInstanceBinding(PainlessInstanceBinding painlessInstanceBinding) implements Decorator.Decoration
    {
    }

    public record StandardPainlessClassBinding(PainlessClassBinding painlessClassBinding) implements Decorator.Decoration
    {
    }

    public record ThisPainlessMethod(PainlessMethod thisPainlessMethod) implements Decorator.Decoration
    {
    }

    public record StandardLocalFunction(FunctionTable.LocalFunction localFunction) implements Decorator.Decoration
    {
    }

    public record StandardConstant(Object standardConstant) implements Decorator.Decoration
    {
    }

    public record SetterPainlessMethod(PainlessMethod setterPainlessMethod) implements Decorator.Decoration
    {
    }

    public record GetterPainlessMethod(PainlessMethod getterPainlessMethod) implements Decorator.Decoration
    {
    }

    public static interface DynamicInvocation
    extends Decorator.Condition {
    }

    public record StandardPainlessMethod(PainlessMethod standardPainlessMethod) implements Decorator.Decoration
    {
    }

    public record StandardPainlessConstructor(PainlessConstructor standardPainlessConstructor) implements Decorator.Decoration
    {
    }

    public record StandardPainlessField(PainlessField standardPainlessField) implements Decorator.Decoration
    {
    }

    public record DowncastPainlessCast(PainlessCast downcastPainlessCast) implements Decorator.Decoration
    {
        public DowncastPainlessCast(PainlessCast downcastPainlessCast) {
            this.downcastPainlessCast = Objects.requireNonNull(downcastPainlessCast);
        }
    }

    public record UpcastPainlessCast(PainlessCast upcastPainlessCast) implements Decorator.Decoration
    {
    }

    public record CompoundType(Class<?> compoundType) implements Decorator.Decoration
    {
        public String getCompoundCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.compoundType);
        }
    }

    public record ComparisonType(Class<?> comparisonType) implements Decorator.Decoration
    {
        public String getComparisonCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.comparisonType);
        }
    }

    public record ShiftType(Class<?> shiftType) implements Decorator.Decoration
    {
        public String getShiftCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.shiftType);
        }
    }

    public record BinaryType(Class<?> binaryType) implements Decorator.Decoration
    {
        public String getBinaryCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.binaryType);
        }
    }

    public record UnaryType(Class<?> unaryType) implements Decorator.Decoration
    {
        public String getUnaryCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.unaryType);
        }
    }

    public record IterablePainlessMethod(PainlessMethod iterablePainlessMethod) implements Decorator.Decoration
    {
    }

    public record SemanticVariable(SemanticScope.Variable semanticVariable) implements Decorator.Decoration
    {
    }

    public record ExpressionPainlessCast(PainlessCast expressionPainlessCast) implements Decorator.Decoration
    {
    }

    public static interface ListShortcut
    extends Decorator.Condition {
    }

    public static interface MapShortcut
    extends Decorator.Condition {
    }

    public static interface Shortcut
    extends Decorator.Condition {
    }

    public static interface ContinuousLoop
    extends Decorator.Condition {
    }

    public static interface DefOptimized
    extends Decorator.Condition {
    }

    public record PartialCanonicalTypeName(String partialCanonicalTypeName) implements Decorator.Decoration
    {
    }

    public record StaticType(Class<?> staticType) implements Decorator.Decoration
    {
        public String getStaticCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.staticType);
        }
    }

    public record ValueType(Class<?> valueType) implements Decorator.Decoration
    {
        public String getValueCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.valueType);
        }
    }

    public static interface Internal
    extends Decorator.Condition {
    }

    public static interface Explicit
    extends Decorator.Condition {
    }

    public record TargetType(Class<?> targetType) implements Decorator.Decoration
    {
        public String getTargetCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.targetType);
        }
    }

    public static interface Write
    extends Decorator.Condition {
    }

    public static interface Read
    extends Decorator.Condition {
    }

    public static interface AnyBreak
    extends Decorator.Condition {
    }

    public static interface AnyContinue
    extends Decorator.Condition {
    }

    public static interface AllEscape
    extends Decorator.Condition {
    }

    public static interface LoopEscape
    extends Decorator.Condition {
    }

    public static interface MethodEscape
    extends Decorator.Condition {
    }

    public static interface LastLoop
    extends Decorator.Condition {
    }

    public static interface InLoop
    extends Decorator.Condition {
    }

    public static interface BeginLoop
    extends Decorator.Condition {
    }

    public static interface LastSource
    extends Decorator.Condition {
    }
}

