/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.spi.annotation.InjectConstantAnnotation;

public final class PainlessLookupUtility {
    public static final String ANONYMOUS_CLASS_NAME = "$anonymous";
    public static final String DEF_CLASS_NAME = "def";
    public static final String CONSTRUCTOR_NAME = "<init>";

    public static Class<?> canonicalTypeNameToType(String canonicalTypeName, Map<String, Class<?>> canonicalClassNamesToClasses) {
        Class<def> type;
        Objects.requireNonNull(canonicalTypeName);
        Objects.requireNonNull(canonicalClassNamesToClasses);
        Class clazz = type = DEF_CLASS_NAME.equals(canonicalTypeName) ? def.class : canonicalClassNamesToClasses.get(canonicalTypeName);
        if (type != null) {
            return type;
        }
        int arrayDimensions = 0;
        int arrayIndex = canonicalTypeName.indexOf(91);
        if (arrayIndex != -1) {
            int typeNameLength = canonicalTypeName.length();
            while (arrayIndex < typeNameLength) {
                if (canonicalTypeName.charAt(arrayIndex) == '[' && ++arrayIndex < typeNameLength && canonicalTypeName.charAt(arrayIndex++) == ']') {
                    ++arrayDimensions;
                    continue;
                }
                return null;
            }
            Class clazz2 = type = DEF_CLASS_NAME.equals(canonicalTypeName = canonicalTypeName.substring(0, canonicalTypeName.indexOf(91))) ? def.class : canonicalClassNamesToClasses.get(canonicalTypeName);
            if (type != null) {
                char[] arrayBraces = new char[arrayDimensions];
                Arrays.fill(arrayBraces, '[');
                Object javaTypeName = new String(arrayBraces);
                javaTypeName = type == Boolean.TYPE ? (String)javaTypeName + "Z" : (type == Byte.TYPE ? (String)javaTypeName + "B" : (type == Short.TYPE ? (String)javaTypeName + "S" : (type == Character.TYPE ? (String)javaTypeName + "C" : (type == Integer.TYPE ? (String)javaTypeName + "I" : (type == Long.TYPE ? (String)javaTypeName + "J" : (type == Float.TYPE ? (String)javaTypeName + "F" : (type == Double.TYPE ? (String)javaTypeName + "D" : (String)javaTypeName + "L" + type.getName() + ";")))))));
                try {
                    return Class.forName((String)javaTypeName);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("internal error", cnfe);
                }
            }
        }
        return null;
    }

    public static String typeToCanonicalTypeName(Class<?> type) {
        Objects.requireNonNull(type);
        String canonicalTypeName = type.getCanonicalName();
        if (canonicalTypeName == null) {
            canonicalTypeName = ANONYMOUS_CLASS_NAME;
        } else if (canonicalTypeName.startsWith(def.class.getCanonicalName())) {
            canonicalTypeName = canonicalTypeName.replace(def.class.getCanonicalName(), DEF_CLASS_NAME);
        }
        return canonicalTypeName;
    }

    public static String typesToCanonicalTypeNames(List<Class<?>> types) {
        StringBuilder typesStringBuilder = new StringBuilder("[");
        int anyTypesSize = types.size();
        int anyTypesIndex = 0;
        for (Class<?> painlessType : types) {
            String canonicalTypeName = PainlessLookupUtility.typeToCanonicalTypeName(painlessType);
            typesStringBuilder.append(canonicalTypeName);
            if (++anyTypesIndex >= anyTypesSize) continue;
            typesStringBuilder.append(",");
        }
        typesStringBuilder.append("]");
        return typesStringBuilder.toString();
    }

    public static Class<?> javaTypeToType(Class<?> javaType) {
        Objects.requireNonNull(javaType);
        if (javaType.isArray()) {
            Class<?> javaTypeComponent = javaType.getComponentType();
            int arrayDimensions = 1;
            while (javaTypeComponent.isArray()) {
                javaTypeComponent = javaTypeComponent.getComponentType();
                ++arrayDimensions;
            }
            if (javaTypeComponent == Object.class) {
                char[] arrayBraces = new char[arrayDimensions];
                Arrays.fill(arrayBraces, '[');
                try {
                    return Class.forName(new String(arrayBraces) + "L" + def.class.getName() + ";");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("internal error", cnfe);
                }
            }
        } else if (javaType == Object.class) {
            return def.class;
        }
        return javaType;
    }

    public static Class<?> typeToJavaType(Class<?> type) {
        Objects.requireNonNull(type);
        if (type.isArray()) {
            Class<?> typeComponent = type.getComponentType();
            int arrayDimensions = 1;
            while (typeComponent.isArray()) {
                typeComponent = typeComponent.getComponentType();
                ++arrayDimensions;
            }
            if (typeComponent == def.class) {
                char[] arrayBraces = new char[arrayDimensions];
                Arrays.fill(arrayBraces, '[');
                try {
                    return Class.forName(new String(arrayBraces) + "L" + Object.class.getName() + ";");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("internal error", cnfe);
                }
            }
        } else if (type == def.class) {
            return Object.class;
        }
        return type;
    }

    public static Class<?> typeToBoxedType(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return type;
    }

    public static Class<?> typeToUnboxedType(Class<?> type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return type;
    }

    public static boolean isConstantType(Class<?> type) {
        return type == Boolean.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || type == String.class;
    }

    public static String buildPainlessConstructorKey(int constructorArity) {
        return "<init>/" + constructorArity;
    }

    public static String buildPainlessMethodKey(String methodName, int methodArity) {
        return methodName + "/" + methodArity;
    }

    public static String buildPainlessFieldKey(String fieldName) {
        return fieldName;
    }

    public static Object[] buildInjections(PainlessMethod painlessMethod, Map<String, Object> constants) {
        if (!painlessMethod.annotations().containsKey(InjectConstantAnnotation.class)) {
            return new Object[0];
        }
        List names = ((InjectConstantAnnotation)painlessMethod.annotations().get(InjectConstantAnnotation.class)).injects();
        Object[] injections = new Object[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            Object constant = constants.get(name);
            if (constant == null) {
                throw new IllegalStateException("constant [" + name + "] not found for injection into method [" + PainlessLookupUtility.buildPainlessMethodKey(painlessMethod.javaMethod().getName(), painlessMethod.typeParameters().size()) + "]");
            }
            injections[i] = constant;
        }
        return injections;
    }

    private PainlessLookupUtility() {
    }
}

