/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.PainlessScriptEngine;
import org.elasticsearch.painless.action.PainlessContextAction;
import org.elasticsearch.painless.action.PainlessExecuteAction;
import org.elasticsearch.painless.spi.PainlessExtension;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistLoader;
import org.elasticsearch.painless.spi.annotation.WhitelistAnnotationParser;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public final class PainlessPlugin
extends Plugin
implements ScriptPlugin,
ExtensiblePlugin,
ActionPlugin {
    private static final Map<ScriptContext<?>, List<Whitelist>> whitelists;
    private static final String[] BASE_WHITELIST_FILES;
    public static final List<Whitelist> BASE_WHITELISTS;
    private final SetOnce<PainlessScriptEngine> painlessScriptEngine = new SetOnce();

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        HashMap contextsWithWhitelists = new HashMap();
        for (ScriptContext<?> context : contexts) {
            ArrayList<Whitelist> mergedWhitelists = new ArrayList<Whitelist>(BASE_WHITELISTS);
            List<Whitelist> contextWhitelists = whitelists.get(context);
            if (contextWhitelists != null) {
                mergedWhitelists.addAll(contextWhitelists);
            }
            contextsWithWhitelists.put(context, mergedWhitelists);
        }
        this.painlessScriptEngine.set((Object)new PainlessScriptEngine(settings, contextsWithWhitelists));
        return (ScriptEngine)this.painlessScriptEngine.get();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(this.painlessScriptEngine.get());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CompilerSettings.REGEX_ENABLED, CompilerSettings.REGEX_LIMIT_FACTOR);
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        loader.loadExtensions(PainlessExtension.class).stream().flatMap(extension -> extension.getContextWhitelists().entrySet().stream()).forEach(entry -> {
            List existing = whitelists.computeIfAbsent((ScriptContext)entry.getKey(), c -> new ArrayList());
            existing.addAll((Collection)entry.getValue());
        });
    }

    public List<ScriptContext<?>> getContexts() {
        return Collections.singletonList(PainlessExecuteAction.PainlessTestScript.CONTEXT);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessExecuteAction.INSTANCE, PainlessExecuteAction.TransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessContextAction.INSTANCE, PainlessContextAction.TransportAction.class));
        return actions;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new PainlessExecuteAction.RestAction());
        handlers.add((RestHandler)new PainlessContextAction.RestAction());
        return handlers;
    }

    static {
        BASE_WHITELIST_FILES = new String[]{"org.elasticsearch.txt", "org.elasticsearch.net.txt", "org.elasticsearch.script.fields.txt", "java.lang.txt", "java.math.txt", "java.text.txt", "java.time.txt", "java.time.chrono.txt", "java.time.format.txt", "java.time.temporal.txt", "java.time.zone.txt", "java.util.txt", "java.util.function.txt", "java.util.regex.txt", "java.util.stream.txt", "java.nio.txt"};
        BASE_WHITELISTS = Collections.singletonList(WhitelistLoader.loadFromResourceFiles(PainlessPlugin.class, (Map)WhitelistAnnotationParser.BASE_ANNOTATION_PARSERS, (String[])BASE_WHITELIST_FILES));
        whitelists = new HashMap();
        for (ScriptContext context : ScriptModule.CORE_CONTEXTS.values()) {
            ArrayList<Whitelist> contextWhitelists = new ArrayList<Whitelist>();
            if (PainlessPlugin.class.getResourceAsStream("org.elasticsearch.script." + context.name.replace('-', '_') + ".txt") != null) {
                contextWhitelists.add(WhitelistLoader.loadFromResourceFiles(PainlessPlugin.class, (String[])new String[]{"org.elasticsearch.script." + context.name.replace('-', '_') + ".txt"}));
            }
            whitelists.put(context, contextWhitelists);
        }
        ArrayList<Whitelist> testWhitelists = new ArrayList<Whitelist>();
        for (ScriptContext context : ScriptModule.CORE_CONTEXTS.values()) {
            if (ScriptModule.RUNTIME_FIELDS_CONTEXTS.contains(context)) continue;
            testWhitelists.addAll((Collection)whitelists.get(context));
        }
        testWhitelists.add(WhitelistLoader.loadFromResourceFiles(PainlessPlugin.class, (String[])new String[]{"org.elasticsearch.json.txt"}));
        whitelists.put(PainlessExecuteAction.PainlessTestScript.CONTEXT, testWhitelists);
    }
}

