/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.HttpGetterInfo;
import com.azure.storage.blob.ProgressReporter;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobCopyFromURLHeaders;
import com.azure.storage.blob.implementation.models.BlobCreateSnapshotHeaders;
import com.azure.storage.blob.implementation.models.BlobDownloadHeaders;
import com.azure.storage.blob.implementation.models.BlobGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.BlobGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.BlobStartCopyFromURLHeaders;
import com.azure.storage.blob.implementation.models.BlobTag;
import com.azure.storage.blob.implementation.models.BlobTags;
import com.azure.storage.blob.implementation.models.BlobsDownloadResponse;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.QueryRequest;
import com.azure.storage.blob.implementation.models.QuerySerialization;
import com.azure.storage.blob.implementation.util.BlobQueryReader;
import com.azure.storage.blob.implementation.util.BlobSasImplUtil;
import com.azure.storage.blob.implementation.util.ChunkedDownloadUtils;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobBeginCopySourceRequestConditions;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryAsyncResponse;
import com.azure.storage.blob.models.BlobQueryHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobBeginCopyOptions;
import com.azure.storage.blob.options.BlobCopyFromUrlOptions;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobGetTagsOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobSetAccessTierOptions;
import com.azure.storage.blob.options.BlobSetTagsOptions;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.ReliableDownload;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class BlobAsyncClientBase {
    private final ClientLogger logger = new ClientLogger(BlobAsyncClientBase.class);
    protected final AzureBlobStorageImpl azureBlobStorage;
    private final String snapshot;
    private final String versionId;
    private final CpkInfo customerProvidedKey;
    protected final EncryptionScope encryptionScope;
    protected final String accountName;
    protected final String containerName;
    protected final String blobName;
    protected final BlobServiceVersion serviceVersion;

    protected BlobAsyncClientBase(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey) {
        this(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, null);
    }

    protected BlobAsyncClientBase(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope) {
        this(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, null);
    }

    protected BlobAsyncClientBase(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        if (snapshot != null && versionId != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'snapshot' and 'versionId' cannot be used at the same time."));
        }
        try {
            URI.create(url);
        }
        catch (IllegalArgumentException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)ex);
        }
        this.azureBlobStorage = new AzureBlobStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).build();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.containerName = containerName;
        this.blobName = Utility.urlEncode((String)Utility.urlDecode((String)blobName));
        this.snapshot = snapshot;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.versionId = versionId;
    }

    protected String getEncryptionScope() {
        if (this.encryptionScope == null) {
            return null;
        }
        return this.encryptionScope.getEncryptionScope();
    }

    public BlobAsyncClientBase getSnapshotClient(String snapshot) {
        return new BlobAsyncClientBase(this.getHttpPipeline(), this.getBlobUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), snapshot, this.getCustomerProvidedKey(), this.encryptionScope, this.getVersionId());
    }

    public BlobAsyncClientBase getVersionClient(String versionId) {
        return new BlobAsyncClientBase(this.getHttpPipeline(), this.getBlobUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), this.encryptionScope, versionId);
    }

    public String getBlobUrl() {
        String blobUrl = this.azureBlobStorage.getUrl();
        if (this.isSnapshot()) {
            blobUrl = Utility.appendQueryParameter((String)blobUrl, (String)"snapshot", (String)this.getSnapshotId());
        }
        if (this.getVersionId() != null) {
            blobUrl = Utility.appendQueryParameter((String)blobUrl, (String)"versionid", (String)this.getVersionId());
        }
        return blobUrl;
    }

    public final String getContainerName() {
        return this.containerName;
    }

    public final String getBlobName() {
        return this.blobName == null ? null : Utility.urlDecode((String)this.blobName);
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public Mono<Boolean> exists() {
        try {
            return this.existsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(null, context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
            HttpResponse response = ((BlobStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    public PollerFlux<BlobCopyInfo, Void> beginCopy(String sourceUrl, Duration pollInterval) {
        return this.beginCopy(sourceUrl, null, null, null, null, null, pollInterval);
    }

    public PollerFlux<BlobCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, AccessTier tier, RehydratePriority priority, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration pollInterval) {
        return this.beginCopy(new BlobBeginCopyOptions(sourceUrl).setMetadata(metadata).setTier(tier).setRehydratePriority(priority).setSourceRequestConditions(ModelHelper.populateBlobSourceRequestConditions(sourceModifiedRequestConditions)).setDestinationRequestConditions(destRequestConditions).setPollInterval(pollInterval));
    }

    public PollerFlux<BlobCopyInfo, Void> beginCopy(BlobBeginCopyOptions options) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Duration interval = options.getPollInterval() != null ? options.getPollInterval() : Duration.ofSeconds(1L);
        BlobBeginCopySourceRequestConditions sourceModifiedCondition = options.getSourceRequestConditions() == null ? new BlobBeginCopySourceRequestConditions() : options.getSourceRequestConditions();
        BlobRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new BlobRequestConditions() : options.getDestinationRequestConditions();
        return new PollerFlux(interval, pollingContext -> {
            try {
                return this.onStart(options.getSourceUrl(), options.getMetadata(), options.getTags(), options.getTier(), options.getRehydratePriority(), options.isSealDestination(), sourceModifiedCondition, destinationRequestConditions);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        }, pollingContext -> {
            try {
                return this.onPoll((PollResponse<BlobCopyInfo>)pollingContext.getLatestResponse());
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        }, (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot cancel a poll response that never started.")));
            }
            String copyIdentifier = ((BlobCopyInfo)firstResponse.getValue()).getCopyId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)copyIdentifier)) {
                this.logger.info("Cancelling copy operation for copy id: {}", new Object[]{copyIdentifier});
                return this.abortCopyFromUrl(copyIdentifier).thenReturn((Object)((BlobCopyInfo)firstResponse.getValue()));
            }
            return Mono.empty();
        }, pollingContext -> Mono.empty());
    }

    private Mono<BlobCopyInfo> onStart(String sourceUrl, Map<String, String> metadata, Map<String, String> tags, AccessTier tier, RehydratePriority priority, Boolean sealBlob, BlobBeginCopySourceRequestConditions sourceModifiedRequestConditions, BlobRequestConditions destinationRequestConditions) {
        URL url;
        try {
            url = new URL(sourceUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url.", ex));
        }
        return FluxUtil.withContext(context -> this.azureBlobStorage.blobs().startCopyFromURLWithRestResponseAsync(null, null, url, null, metadata, tier, priority, sourceModifiedRequestConditions.getIfModifiedSince(), sourceModifiedRequestConditions.getIfUnmodifiedSince(), sourceModifiedRequestConditions.getIfMatch(), sourceModifiedRequestConditions.getIfNoneMatch(), sourceModifiedRequestConditions.getTagsConditions(), destinationRequestConditions.getIfModifiedSince(), destinationRequestConditions.getIfUnmodifiedSince(), destinationRequestConditions.getIfMatch(), destinationRequestConditions.getIfNoneMatch(), destinationRequestConditions.getTagsConditions(), destinationRequestConditions.getLeaseId(), null, this.tagsToString(tags), sealBlob, (Context)context)).map(response -> {
            BlobStartCopyFromURLHeaders headers = (BlobStartCopyFromURLHeaders)response.getDeserializedHeaders();
            return new BlobCopyInfo(sourceUrl, headers.getCopyId(), headers.getCopyStatus(), headers.getETag(), headers.getLastModified(), headers.getErrorCode(), headers.getVersionId());
        });
    }

    String tagsToString(Map<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            try {
                sb.append(URLEncoder.encode(entry.getKey(), Charset.defaultCharset().toString()));
                sb.append("=");
                sb.append(URLEncoder.encode(entry.getValue(), Charset.defaultCharset().toString()));
                sb.append("&");
            }
            catch (UnsupportedEncodingException e) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(e));
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private Mono<PollResponse<BlobCopyInfo>> onPoll(PollResponse<BlobCopyInfo> pollResponse) {
        if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.just(pollResponse);
        }
        BlobCopyInfo lastInfo = (BlobCopyInfo)pollResponse.getValue();
        if (lastInfo == null) {
            this.logger.warning("BlobCopyInfo does not exist. Activation operation failed.");
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"COPY_START_FAILED", (boolean)true), null));
        }
        return this.getProperties().map(response -> {
            LongRunningOperationStatus operationStatus;
            CopyStatusType status = response.getCopyStatus();
            BlobCopyInfo result = new BlobCopyInfo(response.getCopySource(), response.getCopyId(), status, response.getETag(), response.getCopyCompletionTime(), response.getCopyStatusDescription(), response.getVersionId());
            switch (status) {
                case SUCCESS: {
                    operationStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                    break;
                }
                case FAILED: {
                    operationStatus = LongRunningOperationStatus.FAILED;
                    break;
                }
                case ABORTED: {
                    operationStatus = LongRunningOperationStatus.USER_CANCELLED;
                    break;
                }
                case PENDING: {
                    operationStatus = LongRunningOperationStatus.IN_PROGRESS;
                    break;
                }
                default: {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("CopyStatusType is not supported. Status: " + (Object)((Object)status)));
                }
            }
            return new PollResponse(operationStatus, (Object)result);
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"POLLING_FAILED", (boolean)true), (Object)lastInfo));
    }

    public Mono<Void> abortCopyFromUrl(String copyId) {
        try {
            return this.abortCopyFromUrlWithResponse(copyId, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> abortCopyFromUrlWithResponse(String copyId, String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.abortCopyFromUrlWithResponse(copyId, leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> abortCopyFromUrlWithResponse(String copyId, String leaseId, Context context) {
        return this.azureBlobStorage.blobs().abortCopyFromURLWithRestResponseAsync(null, null, copyId, null, leaseId, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<String> copyFromUrl(String copySource) {
        try {
            return this.copyFromUrlWithResponse(copySource, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> copyFromUrlWithResponse(String copySource, Map<String, String> metadata, AccessTier tier, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions) {
        return this.copyFromUrlWithResponse(new BlobCopyFromUrlOptions(copySource).setMetadata(metadata).setTier(tier).setSourceRequestConditions(sourceModifiedRequestConditions).setDestinationRequestConditions(destRequestConditions));
    }

    public Mono<Response<String>> copyFromUrlWithResponse(BlobCopyFromUrlOptions options) {
        try {
            return FluxUtil.withContext(context -> this.copyFromUrlWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> copyFromUrlWithResponse(BlobCopyFromUrlOptions options, Context context) {
        URL url;
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        RequestConditions sourceModifiedRequestConditions = options.getSourceRequestConditions() == null ? new RequestConditions() : options.getSourceRequestConditions();
        BlobRequestConditions destRequestConditions = options.getDestinationRequestConditions() == null ? new BlobRequestConditions() : options.getDestinationRequestConditions();
        try {
            url = new URL(options.getCopySource());
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'copySource' is not a valid url."));
        }
        return this.azureBlobStorage.blobs().copyFromURLWithRestResponseAsync(null, null, url, null, options.getMetadata(), options.getTier(), sourceModifiedRequestConditions.getIfModifiedSince(), sourceModifiedRequestConditions.getIfUnmodifiedSince(), sourceModifiedRequestConditions.getIfMatch(), sourceModifiedRequestConditions.getIfNoneMatch(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), destRequestConditions.getTagsConditions(), destRequestConditions.getLeaseId(), null, null, this.tagsToString(options.getTags()), context).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobCopyFromURLHeaders)rb.getDeserializedHeaders()).getCopyId()));
    }

    public Flux<ByteBuffer> download() {
        try {
            return this.downloadWithResponse(null, null, null, false).flatMapMany(ResponseBase::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<BlobDownloadAsyncResponse> downloadWithResponse(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5) {
        try {
            return FluxUtil.withContext(context -> this.downloadWithResponse(range, options, requestConditions, getRangeContentMd5, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<BlobDownloadAsyncResponse> downloadWithResponse(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Context context) {
        return this.downloadHelper(range, options, requestConditions, getRangeContentMd5, context).map(response -> new BlobDownloadAsyncResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue(), response.getDeserializedHeaders()));
    }

    private Mono<ReliableDownload> downloadHelper(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Context context) {
        range = range == null ? new BlobRange(0L) : range;
        Boolean getMD5 = getRangeContentMd5 ? Boolean.valueOf(getRangeContentMd5) : null;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        HttpGetterInfo info = new HttpGetterInfo().setOffset(range.getOffset()).setCount(range.getCount()).setETag(requestConditions.getIfMatch());
        return this.azureBlobStorage.blobs().downloadWithRestResponseAsync(null, null, this.snapshot, this.versionId, null, range.toHeaderValue(), requestConditions.getLeaseId(), getMD5, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.customerProvidedKey, context).map(response -> {
            info.setETag(((BlobDownloadHeaders)response.getDeserializedHeaders()).getETag());
            return new ReliableDownload((BlobsDownloadResponse)response, options, info, updatedInfo -> this.downloadHelper(new BlobRange(updatedInfo.getOffset(), updatedInfo.getCount()), options, new BlobRequestConditions().setIfMatch(info.getETag()), false, context));
        });
    }

    public Mono<BlobProperties> downloadToFile(String filePath) {
        return this.downloadToFile(filePath, false);
    }

    public Mono<BlobProperties> downloadToFile(String filePath, boolean overwrite) {
        try {
            HashSet<OpenOption> openOptions = null;
            if (overwrite) {
                openOptions = new HashSet<OpenOption>();
                openOptions.add(StandardOpenOption.CREATE);
                openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                openOptions.add(StandardOpenOption.READ);
                openOptions.add(StandardOpenOption.WRITE);
            }
            return this.downloadToFileWithResponse(filePath, null, null, null, null, false, openOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobProperties>> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean rangeGetContentMd5) {
        return this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, options, requestConditions, rangeGetContentMd5, null);
    }

    public Mono<Response<BlobProperties>> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions) {
        try {
            com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions = ModelHelper.wrapBlobOptions(ModelHelper.populateAndApplyDefaults(parallelTransferOptions));
            return FluxUtil.withContext(context -> this.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(range).setParallelTransferOptions(finalParallelTransferOptions).setDownloadRetryOptions(options).setRequestConditions(requestConditions).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobProperties>> downloadToFileWithResponse(BlobDownloadToFileOptions options) {
        try {
            return FluxUtil.withContext(context -> this.downloadToFileWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobProperties>> downloadToFileWithResponse(BlobDownloadToFileOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobRange finalRange = options.getRange() == null ? new BlobRange(0L) : options.getRange();
        com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions = ModelHelper.populateAndApplyDefaults(options.getParallelTransferOptions());
        BlobRequestConditions finalConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        Set<OpenOption> openOptions = options.getOpenOptions();
        if (openOptions == null) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE_NEW);
            openOptions.add(StandardOpenOption.WRITE);
            openOptions.add(StandardOpenOption.READ);
        }
        AsynchronousFileChannel channel = this.downloadToFileResourceSupplier(options.getFilePath(), openOptions);
        return Mono.just((Object)channel).flatMap(c -> this.downloadToFileImpl((AsynchronousFileChannel)c, finalRange, finalParallelTransferOptions, options.getDownloadRetryOptions(), finalConditions, options.isRetrieveContentRangeMd5(), context)).doFinally(signalType -> this.downloadToFileCleanup(channel, options.getFilePath(), (SignalType)signalType));
    }

    private AsynchronousFileChannel downloadToFileResourceSupplier(String filePath, Set<OpenOption> openOptions) {
        try {
            return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), openOptions, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    private Mono<Response<BlobProperties>> downloadToFileImpl(AsynchronousFileChannel file, BlobRange finalRange, com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Context context) {
        ReentrantLock progressLock = new ReentrantLock();
        AtomicLong totalProgress = new AtomicLong(0L);
        BiFunction<BlobRange, BlobRequestConditions, Mono<BlobDownloadAsyncResponse>> downloadFunc = (range, conditions) -> this.downloadWithResponse((BlobRange)range, downloadRetryOptions, (BlobRequestConditions)((Object)conditions), rangeGetContentMd5, context);
        return ChunkedDownloadUtils.downloadFirstChunk(finalRange, finalParallelTransferOptions, requestConditions, downloadFunc, true).flatMap(setupTuple3 -> {
            long newCount = (Long)setupTuple3.getT1();
            BlobRequestConditions finalConditions = (BlobRequestConditions)((Object)((Object)setupTuple3.getT2()));
            int numChunks = ChunkedDownloadUtils.calculateNumBlocks(newCount, finalParallelTransferOptions.getBlockSizeLong());
            numChunks = numChunks == 0 ? 1 : numChunks;
            BlobDownloadAsyncResponse initialResponse = (BlobDownloadAsyncResponse)((Object)((Object)setupTuple3.getT3()));
            return Flux.range((int)0, (int)numChunks).flatMap(chunkNum -> ChunkedDownloadUtils.downloadChunk(chunkNum, initialResponse, finalRange, finalParallelTransferOptions, finalConditions, newCount, downloadFunc, response -> BlobAsyncClientBase.writeBodyToFile(response, file, chunkNum.intValue(), finalParallelTransferOptions, progressLock, totalProgress).flux()), finalParallelTransferOptions.getMaxConcurrency().intValue()).then(Mono.just(BlobAsyncClientBase.buildBlobPropertiesResponse(initialResponse)));
        });
    }

    private static Mono<Void> writeBodyToFile(BlobDownloadAsyncResponse response, AsynchronousFileChannel file, long chunkNum, com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions, Lock progressLock, AtomicLong totalProgress) {
        Flux<ByteBuffer> data = (Flux<ByteBuffer>)response.getValue();
        data = ProgressReporter.addParallelProgressReporting(data, ModelHelper.wrapCommonReceiver(finalParallelTransferOptions.getProgressReceiver()), progressLock, totalProgress);
        return FluxUtil.writeFile(data, (AsynchronousFileChannel)file, (long)(chunkNum * finalParallelTransferOptions.getBlockSizeLong()));
    }

    private static Response<BlobProperties> buildBlobPropertiesResponse(BlobDownloadAsyncResponse response) {
        com.azure.storage.blob.models.BlobDownloadHeaders hd = (com.azure.storage.blob.models.BlobDownloadHeaders)response.getDeserializedHeaders();
        long blobSize = BlobAsyncClientBase.getBlobLength(hd);
        BlobProperties properties = new BlobProperties(null, hd.getLastModified(), hd.getETag(), blobSize, hd.getContentType(), hd.getContentMd5(), hd.getContentEncoding(), hd.getContentDisposition(), hd.getContentLanguage(), hd.getCacheControl(), hd.getBlobSequenceNumber(), hd.getBlobType(), hd.getLeaseStatus(), hd.getLeaseState(), hd.getLeaseDuration(), hd.getCopyId(), hd.getCopyStatus(), hd.getCopySource(), hd.getCopyProgress(), hd.getCopyCompletionTime(), hd.getCopyStatusDescription(), hd.isServerEncrypted(), null, null, null, null, null, hd.getEncryptionKeySha256(), hd.getEncryptionScope(), null, hd.getMetadata(), hd.getBlobCommittedBlockCount(), hd.getTagCount(), hd.getVersionId(), null, hd.getObjectReplicationSourcePolicies(), hd.getObjectReplicationDestinationPolicyId(), null, hd.isSealed(), hd.getLastAccessedTime(), null);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)properties);
    }

    static long getBlobLength(com.azure.storage.blob.models.BlobDownloadHeaders headers) {
        return headers.getContentRange() == null ? headers.getContentLength() : ChunkedDownloadUtils.extractTotalBlobLength(headers.getContentRange());
    }

    private void downloadToFileCleanup(AsynchronousFileChannel channel, String filePath, SignalType signalType) {
        try {
            channel.close();
            if (!signalType.equals((Object)SignalType.ON_COMPLETE)) {
                Files.deleteIfExists(Paths.get(filePath, new String[0]));
                this.logger.verbose("Downloading to file failed. Cleaning up resources.");
            }
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(deleteBlobSnapshotOptions, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        return this.azureBlobStorage.blobs().deleteWithRestResponseAsync(null, null, this.snapshot, this.versionId, null, requestConditions.getLeaseId(), deleteBlobSnapshotOptions, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<BlobProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobProperties>> getPropertiesWithResponse(BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobProperties>> getPropertiesWithResponse(BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().getPropertiesWithRestResponseAsync(null, null, this.snapshot, this.versionId, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.customerProvidedKey, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            BlobGetPropertiesHeaders hd = (BlobGetPropertiesHeaders)rb.getDeserializedHeaders();
            BlobProperties properties = new BlobProperties(hd.getCreationTime(), hd.getLastModified(), hd.getETag(), hd.getContentLength() == null ? 0L : hd.getContentLength(), hd.getContentType(), hd.getContentMD5(), hd.getContentEncoding(), hd.getContentDisposition(), hd.getContentLanguage(), hd.getCacheControl(), hd.getBlobSequenceNumber(), hd.getBlobType(), hd.getLeaseStatus(), hd.getLeaseState(), hd.getLeaseDuration(), hd.getCopyId(), hd.getCopyStatus(), hd.getCopySource(), hd.getCopyProgress(), hd.getCopyCompletionTime(), hd.getCopyStatusDescription(), hd.isServerEncrypted(), hd.isIncrementalCopy(), hd.getDestinationSnapshot(), AccessTier.fromString(hd.getAccessTier()), hd.isAccessTierInferred(), ArchiveStatus.fromString(hd.getArchiveStatus()), hd.getEncryptionKeySha256(), hd.getEncryptionScope(), hd.getAccessTierChangeTime(), hd.getMetadata(), hd.getBlobCommittedBlockCount(), hd.getTagCount(), hd.getVersionId(), hd.isCurrentVersion(), ModelHelper.getObjectReplicationSourcePolicies(hd.getObjectReplicationRules()), ModelHelper.getObjectReplicationDestinationPolicyId(hd.getObjectReplicationRules()), RehydratePriority.fromString(hd.getRehydratePriority()), hd.isSealed(), hd.getLastAccessed(), hd.getExpiresOn());
            return new SimpleResponse((Response)rb, (Object)properties);
        });
    }

    public Mono<Void> setHttpHeaders(BlobHttpHeaders headers) {
        try {
            return this.setHttpHeadersWithResponse(headers, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setHttpHeadersWithResponse(BlobHttpHeaders headers, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setHttpHeadersWithResponse(headers, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setHttpHeadersWithResponse(BlobHttpHeaders headers, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        return this.azureBlobStorage.blobs().setHTTPHeadersWithRestResponseAsync(null, null, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, headers, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().setMetadataWithRestResponseAsync(null, null, null, metadata, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.customerProvidedKey, this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Map<String, String>> getTags() {
        return this.getTagsWithResponse(new BlobGetTagsOptions()).map(Response::getValue);
    }

    public Mono<Response<Map<String, String>>> getTagsWithResponse(BlobGetTagsOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getTagsWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Map<String, String>>> getTagsWithResponse(BlobGetTagsOptions options, Context context) {
        options = options == null ? new BlobGetTagsOptions() : options;
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        return this.azureBlobStorage.blobs().getTagsWithRestResponseAsync(null, null, null, null, this.snapshot, this.versionId, requestConditions.getTagsConditions(), context).map(response -> {
            HashMap<String, String> tags = new HashMap<String, String>();
            for (BlobTag tag : response.getValue().getBlobTagSet()) {
                tags.put(tag.getKey(), tag.getValue());
            }
            return new SimpleResponse((Response)response, tags);
        });
    }

    public Mono<Void> setTags(Map<String, String> tags) {
        return this.setTagsWithResponse(new BlobSetTagsOptions(tags)).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> setTagsWithResponse(BlobSetTagsOptions options) {
        try {
            return FluxUtil.withContext(context -> this.setTagsWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setTagsWithResponse(BlobSetTagsOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        ArrayList<BlobTag> tagList = null;
        if (options.getTags() != null) {
            tagList = new ArrayList<BlobTag>();
            for (Map.Entry<String, String> entry : options.getTags().entrySet()) {
                tagList.add(new BlobTag().setKey(entry.getKey()).setValue(entry.getValue()));
            }
        }
        BlobTags t = new BlobTags().setBlobTagSet(tagList);
        return this.azureBlobStorage.blobs().setTagsWithRestResponseAsync(null, null, null, this.versionId, null, null, null, requestConditions.getTagsConditions(), t, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<BlobAsyncClientBase> createSnapshot() {
        try {
            return this.createSnapshotWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobAsyncClientBase>> createSnapshotWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createSnapshotWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobAsyncClientBase>> createSnapshotWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        return this.azureBlobStorage.blobs().createSnapshotWithRestResponseAsync(null, null, null, metadata, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), requestConditions.getLeaseId(), null, this.customerProvidedKey, this.encryptionScope, context).map(rb -> new SimpleResponse((Response)rb, (Object)this.getSnapshotClient(((BlobCreateSnapshotHeaders)rb.getDeserializedHeaders()).getSnapshot())));
    }

    public Mono<Void> setAccessTier(AccessTier tier) {
        try {
            return this.setAccessTierWithResponse(tier, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setAccessTierWithResponse(AccessTier tier, RehydratePriority priority, String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.setTierWithResponse(new BlobSetAccessTierOptions(tier).setPriority(priority).setLeaseId(leaseId), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setAccessTierWithResponse(BlobSetAccessTierOptions options) {
        try {
            return FluxUtil.withContext(context -> this.setTierWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setTierWithResponse(BlobSetAccessTierOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        return this.azureBlobStorage.blobs().setTierWithRestResponseAsync(null, null, options.getTier(), this.snapshot, this.versionId, null, options.getPriority(), null, options.getLeaseId(), options.getTagsConditions(), context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> undelete() {
        try {
            return this.undeleteWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> undeleteWithResponse() {
        try {
            return FluxUtil.withContext(this::undeleteWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> undeleteWithResponse(Context context) {
        return this.azureBlobStorage.blobs().undeleteWithRestResponseAsync(null, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<StorageAccountInfo> getAccountInfo() {
        try {
            return this.getAccountInfoWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountInfoWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse(Context context) {
        return this.azureBlobStorage.blobs().getAccountInfoWithRestResponseAsync(null, null, context).map(rb -> {
            BlobGetAccountInfoHeaders hd = (BlobGetAccountInfoHeaders)rb.getDeserializedHeaders();
            return new SimpleResponse((Response)rb, (Object)new StorageAccountInfo(hd.getSkuName(), hd.getAccountKind()));
        });
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getVersionId()).generateUserDelegationSas(userDelegationKey, this.getAccountName());
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getVersionId()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()));
    }

    public Flux<ByteBuffer> query(String expression) {
        return this.queryWithResponse(new BlobQueryOptions(expression)).flatMapMany(ResponseBase::getValue);
    }

    public Mono<BlobQueryAsyncResponse> queryWithResponse(BlobQueryOptions queryOptions) {
        try {
            return FluxUtil.withContext(context -> this.queryWithResponse(queryOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<BlobQueryAsyncResponse> queryWithResponse(BlobQueryOptions queryOptions, Context context) {
        StorageImplUtils.assertNotNull((String)"queryOptions", (Object)queryOptions);
        BlobRequestConditions requestConditions = queryOptions.getRequestConditions() == null ? new BlobRequestConditions() : queryOptions.getRequestConditions();
        QuerySerialization in = BlobQueryReader.transformInputSerialization(queryOptions.getInputSerialization(), this.logger);
        QuerySerialization out = BlobQueryReader.transformOutputSerialization(queryOptions.getOutputSerialization(), this.logger);
        QueryRequest qr = new QueryRequest().setExpression(queryOptions.getExpression()).setInputSerialization(in).setOutputSerialization(out);
        return this.azureBlobStorage.blobs().queryWithRestResponseAsync(null, null, qr, this.getSnapshotId(), null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), context).map(response -> new BlobQueryAsyncResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), new BlobQueryReader(response.getValue(), queryOptions.getProgressConsumer(), queryOptions.getErrorConsumer()).read(), (BlobQueryHeaders)response.getDeserializedHeaders()));
    }
}

