/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.DataLakeStorageErrorException;
import com.azure.storage.blob.implementation.models.DirectoryHttpHeaders;
import com.azure.storage.blob.implementation.models.DirectorysCreateResponse;
import com.azure.storage.blob.implementation.models.DirectorysDeleteResponse;
import com.azure.storage.blob.implementation.models.DirectorysGetAccessControlResponse;
import com.azure.storage.blob.implementation.models.DirectorysRenameResponse;
import com.azure.storage.blob.implementation.models.DirectorysSetAccessControlResponse;
import com.azure.storage.blob.models.PathRenameMode;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class DirectorysImpl {
    private DirectorysService service;
    private AzureBlobStorageImpl client;

    public DirectorysImpl(AzureBlobStorageImpl client) {
        this.service = (DirectorysService)RestProxy.create(DirectorysService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<DirectorysCreateResponse> createWithRestResponseAsync(String filesystem, String path, Context context) {
        Integer timeout = null;
        String directoryProperties = null;
        String posixPermissions = null;
        String posixUmask = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String resource = "directory";
        String cacheControl = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.create(filesystem, path, this.client.getUrl(), timeout, directoryProperties, posixPermissions, posixUmask, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "directory", cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<DirectorysCreateResponse> createWithRestResponseAsync(String filesystem, String path, Integer timeout, String directoryProperties, String posixPermissions, String posixUmask, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, DirectoryHttpHeaders directoryHttpHeaders, Context context) {
        String resource = "directory";
        String cacheControl = null;
        if (directoryHttpHeaders != null) {
            cacheControl = directoryHttpHeaders.getCacheControl();
        }
        String contentType = null;
        if (directoryHttpHeaders != null) {
            contentType = directoryHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (directoryHttpHeaders != null) {
            contentEncoding = directoryHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (directoryHttpHeaders != null) {
            contentLanguage = directoryHttpHeaders.getContentLanguage();
        }
        String contentDisposition = null;
        if (directoryHttpHeaders != null) {
            contentDisposition = directoryHttpHeaders.getContentDisposition();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.create(filesystem, path, this.client.getUrl(), timeout, directoryProperties, posixPermissions, posixUmask, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, "directory", cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<DirectorysRenameResponse> renameWithRestResponseAsync(String filesystem, String path, String renameSource, Context context) {
        Integer timeout = null;
        String marker = null;
        String directoryProperties = null;
        String posixPermissions = null;
        String posixUmask = null;
        String leaseId = null;
        String sourceLeaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String requestId = null;
        String cacheControl = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        return this.service.rename(filesystem, path, this.client.getUrl(), timeout, marker, this.client.getPathRenameMode(), renameSource, directoryProperties, posixPermissions, posixUmask, leaseId, sourceLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<DirectorysRenameResponse> renameWithRestResponseAsync(String filesystem, String path, String renameSource, Integer timeout, String marker, String directoryProperties, String posixPermissions, String posixUmask, String leaseId, String sourceLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, DirectoryHttpHeaders directoryHttpHeaders, Context context) {
        String cacheControl = null;
        if (directoryHttpHeaders != null) {
            cacheControl = directoryHttpHeaders.getCacheControl();
        }
        String contentType = null;
        if (directoryHttpHeaders != null) {
            contentType = directoryHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (directoryHttpHeaders != null) {
            contentEncoding = directoryHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (directoryHttpHeaders != null) {
            contentLanguage = directoryHttpHeaders.getContentLanguage();
        }
        String contentDisposition = null;
        if (directoryHttpHeaders != null) {
            contentDisposition = directoryHttpHeaders.getContentDisposition();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.rename(filesystem, path, this.client.getUrl(), timeout, marker, this.client.getPathRenameMode(), renameSource, directoryProperties, posixPermissions, posixUmask, leaseId, sourceLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<DirectorysDeleteResponse> deleteWithRestResponseAsync(String filesystem, String path, boolean recursiveDirectoryDelete, Context context) {
        Integer timeout = null;
        String marker = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.delete(filesystem, path, this.client.getUrl(), timeout, recursiveDirectoryDelete, marker, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, context);
    }

    public Mono<DirectorysDeleteResponse> deleteWithRestResponseAsync(String filesystem, String path, boolean recursiveDirectoryDelete, Integer timeout, String marker, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String requestId, Context context) {
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(filesystem, path, this.client.getUrl(), timeout, recursiveDirectoryDelete, marker, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, this.client.getVersion(), requestId, context);
    }

    public Mono<DirectorysSetAccessControlResponse> setAccessControlWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String leaseId = null;
        String owner = null;
        String group = null;
        String posixPermissions = null;
        String posixAcl = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String action = "setAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.setAccessControl(this.client.getUrl(), timeout, leaseId, owner, group, posixPermissions, posixAcl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "setAccessControl", context);
    }

    public Mono<DirectorysSetAccessControlResponse> setAccessControlWithRestResponseAsync(Integer timeout, String leaseId, String owner, String group, String posixPermissions, String posixAcl, String ifMatch, String ifNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String action = "setAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControl(this.client.getUrl(), timeout, leaseId, owner, group, posixPermissions, posixAcl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "setAccessControl", context);
    }

    public Mono<DirectorysGetAccessControlResponse> getAccessControlWithRestResponseAsync(Context context) {
        Integer timeout = null;
        Boolean upn = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String action = "getAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getAccessControl(this.client.getUrl(), timeout, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "getAccessControl", context);
    }

    public Mono<DirectorysGetAccessControlResponse> getAccessControlWithRestResponseAsync(Integer timeout, Boolean upn, String leaseId, String ifMatch, String ifNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String action = "getAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getAccessControl(this.client.getUrl(), timeout, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "getAccessControl", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageDirectorys")
    public static interface DirectorysService {
        @Put(value="{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectorysCreateResponse> create(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-properties") String var5, @HeaderParam(value="x-ms-permissions") String var6, @HeaderParam(value="x-ms-umask") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @QueryParam(value="resource") String var15, @HeaderParam(value="x-ms-cache-control") String var16, @HeaderParam(value="x-ms-content-type") String var17, @HeaderParam(value="x-ms-content-encoding") String var18, @HeaderParam(value="x-ms-content-language") String var19, @HeaderParam(value="x-ms-content-disposition") String var20, Context var21);

        @Put(value="{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectorysRenameResponse> rename(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="continuation") String var5, @QueryParam(value="mode") PathRenameMode var6, @HeaderParam(value="x-ms-rename-source") String var7, @HeaderParam(value="x-ms-properties") String var8, @HeaderParam(value="x-ms-permissions") String var9, @HeaderParam(value="x-ms-umask") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-source-lease-id") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Match") String var15, @HeaderParam(value="If-None-Match") String var16, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var17, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var18, @HeaderParam(value="x-ms-source-if-match") String var19, @HeaderParam(value="x-ms-source-if-none-match") String var20, @HeaderParam(value="x-ms-version") String var21, @HeaderParam(value="x-ms-client-request-id") String var22, @HeaderParam(value="x-ms-cache-control") String var23, @HeaderParam(value="x-ms-content-type") String var24, @HeaderParam(value="x-ms-content-encoding") String var25, @HeaderParam(value="x-ms-content-language") String var26, @HeaderParam(value="x-ms-content-disposition") String var27, Context var28);

        @Delete(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectorysDeleteResponse> delete(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="recursive") boolean var5, @QueryParam(value="continuation") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, Context var14);

        @Patch(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectorysSetAccessControlResponse> setAccessControl(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="x-ms-owner") String var4, @HeaderParam(value="x-ms-group") String var5, @HeaderParam(value="x-ms-permissions") String var6, @HeaderParam(value="x-ms-acl") String var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="x-ms-version") String var13, @QueryParam(value="action") String var14, Context var15);

        @Head(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<DirectorysGetAccessControlResponse> getAccessControl(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @QueryParam(value="upn") Boolean var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-version") String var10, @QueryParam(value="action") String var11, Context var12);
    }
}

