/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlockBlobsCommitBlockListResponse;
import com.azure.storage.blob.implementation.models.BlockBlobsGetBlockListResponse;
import com.azure.storage.blob.implementation.models.BlockBlobsStageBlockFromURLResponse;
import com.azure.storage.blob.implementation.models.BlockBlobsStageBlockResponse;
import com.azure.storage.blob.implementation.models.BlockBlobsUploadResponse;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.BlockLookupList;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BlockBlobsImpl {
    private BlockBlobsService service;
    private AzureBlobStorageImpl client;

    public BlockBlobsImpl(AzureBlobStorageImpl client) {
        this.service = (BlockBlobsService)RestProxy.create(BlockBlobsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<BlockBlobsUploadResponse> uploadWithRestResponseAsync(String containerName, String blob, Flux<ByteBuffer> body, long contentLength, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String leaseId = null;
        AccessTier tier = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String blobTagsString = null;
        String blobType = "BlockBlob";
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String cacheControl = null;
        String contentDisposition = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        String transactionalContentMD5Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        String contentMd5Converted = null;
        return this.service.upload(containerName, blob, this.client.getUrl(), body, timeout, transactionalContentMD5Converted, contentLength, metadata, leaseId, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, "BlockBlob", contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<BlockBlobsUploadResponse> uploadWithRestResponseAsync(String containerName, String blob, Flux<ByteBuffer> body, long contentLength, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String blobType = "BlockBlob";
        String contentType = null;
        if (blobHttpHeaders != null) {
            contentType = blobHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (blobHttpHeaders != null) {
            contentEncoding = blobHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (blobHttpHeaders != null) {
            contentLanguage = blobHttpHeaders.getContentLanguage();
        }
        byte[] contentMd5 = null;
        if (blobHttpHeaders != null) {
            contentMd5 = blobHttpHeaders.getContentMd5();
        }
        String cacheControl = null;
        if (blobHttpHeaders != null) {
            cacheControl = blobHttpHeaders.getCacheControl();
        }
        String contentDisposition = null;
        if (blobHttpHeaders != null) {
            contentDisposition = blobHttpHeaders.getContentDisposition();
        }
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.upload(containerName, blob, this.client.getUrl(), body, timeout, transactionalContentMD5Converted, contentLength, metadata, leaseId, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, "BlockBlob", contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<BlockBlobsStageBlockResponse> stageBlockWithRestResponseAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String requestId = null;
        String comp = "block";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        String transactionalContentMD5Converted = null;
        String transactionalContentCrc64Converted = null;
        return this.service.stageBlock(containerName, blob, this.client.getUrl(), blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, body, timeout, leaseId, this.client.getVersion(), requestId, "block", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<BlockBlobsStageBlockResponse> stageBlockWithRestResponseAsync(String containerName, String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "block";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        return this.service.stageBlock(containerName, blob, this.client.getUrl(), blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, body, timeout, leaseId, this.client.getVersion(), requestId, "block", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<BlockBlobsStageBlockFromURLResponse> stageBlockFromURLWithRestResponseAsync(String containerName, String blob, String blockId, long contentLength, URL sourceUrl, Context context) {
        String sourceRange = null;
        Integer timeout = null;
        String leaseId = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String requestId = null;
        String comp = "block";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        String sourceContentMD5Converted = null;
        String sourceContentcrc64Converted = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        return this.service.stageBlockFromURL(containerName, blob, this.client.getUrl(), blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "block", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<BlockBlobsStageBlockFromURLResponse> stageBlockFromURLWithRestResponseAsync(String containerName, String blob, String blockId, long contentLength, URL sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "block";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString((byte[])sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.stageBlockFromURL(containerName, blob, this.client.getUrl(), blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "block", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<BlockBlobsCommitBlockListResponse> commitBlockListWithRestResponseAsync(String containerName, String blob, BlockLookupList blocks, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String leaseId = null;
        AccessTier tier = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String blobTagsString = null;
        String comp = "blocklist";
        String cacheControl = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        String transactionalContentMD5Converted = null;
        String transactionalContentCrc64Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        String contentMd5Converted = null;
        return this.service.commitBlockList(containerName, blob, this.client.getUrl(), timeout, transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blocks, this.client.getVersion(), requestId, blobTagsString, "blocklist", cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<BlockBlobsCommitBlockListResponse> commitBlockListWithRestResponseAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "blocklist";
        String cacheControl = null;
        if (blobHttpHeaders != null) {
            cacheControl = blobHttpHeaders.getCacheControl();
        }
        String contentType = null;
        if (blobHttpHeaders != null) {
            contentType = blobHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (blobHttpHeaders != null) {
            contentEncoding = blobHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (blobHttpHeaders != null) {
            contentLanguage = blobHttpHeaders.getContentLanguage();
        }
        byte[] contentMd5 = null;
        if (blobHttpHeaders != null) {
            contentMd5 = blobHttpHeaders.getContentMd5();
        }
        String contentDisposition = null;
        if (blobHttpHeaders != null) {
            contentDisposition = blobHttpHeaders.getContentDisposition();
        }
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.commitBlockList(containerName, blob, this.client.getUrl(), timeout, transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blocks, this.client.getVersion(), requestId, blobTagsString, "blocklist", cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<BlockBlobsGetBlockListResponse> getBlockListWithRestResponseAsync(String containerName, String blob, BlockListType listType, Context context) {
        String snapshot = null;
        Integer timeout = null;
        String leaseId = null;
        String ifTags = null;
        String requestId = null;
        String comp = "blocklist";
        return this.service.getBlockList(containerName, blob, this.client.getUrl(), snapshot, listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, "blocklist", context);
    }

    public Mono<BlockBlobsGetBlockListResponse> getBlockListWithRestResponseAsync(String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId, Context context) {
        String comp = "blocklist";
        return this.service.getBlockList(containerName, blob, this.client.getUrl(), snapshot, listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, "blocklist", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageBlockBlobs")
    public static interface BlockBlobsService {
        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlockBlobsUploadResponse> upload(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-MD5") String var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="x-ms-meta-") Map<String, String> var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-access-tier") AccessTier var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, @HeaderParam(value="x-ms-if-tags") String var16, @HeaderParam(value="x-ms-version") String var17, @HeaderParam(value="x-ms-client-request-id") String var18, @HeaderParam(value="x-ms-tags") String var19, @HeaderParam(value="x-ms-blob-type") String var20, @HeaderParam(value="x-ms-blob-content-type") String var21, @HeaderParam(value="x-ms-blob-content-encoding") String var22, @HeaderParam(value="x-ms-blob-content-language") String var23, @HeaderParam(value="x-ms-blob-content-md5") String var24, @HeaderParam(value="x-ms-blob-cache-control") String var25, @HeaderParam(value="x-ms-blob-content-disposition") String var26, @HeaderParam(value="x-ms-encryption-key") String var27, @HeaderParam(value="x-ms-encryption-key-sha256") String var28, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var29, @HeaderParam(value="x-ms-encryption-scope") String var30, Context var31);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlockBlobsStageBlockResponse> stageBlock(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="blockid") String var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-MD5") String var7, @HeaderParam(value="x-ms-content-crc64") String var8, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, @HeaderParam(value="x-ms-encryption-key") String var15, @HeaderParam(value="x-ms-encryption-key-sha256") String var16, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var17, @HeaderParam(value="x-ms-encryption-scope") String var18, Context var19);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlockBlobsStageBlockFromURLResponse> stageBlockFromURL(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="blockid") String var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="x-ms-copy-source") URL var7, @HeaderParam(value="x-ms-source-range") String var8, @HeaderParam(value="x-ms-source-content-md5") String var9, @HeaderParam(value="x-ms-source-content-crc64") String var10, @QueryParam(value="timeout") Integer var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var13, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var14, @HeaderParam(value="x-ms-source-if-match") String var15, @HeaderParam(value="x-ms-source-if-none-match") String var16, @HeaderParam(value="x-ms-version") String var17, @HeaderParam(value="x-ms-client-request-id") String var18, @QueryParam(value="comp") String var19, @HeaderParam(value="x-ms-encryption-key") String var20, @HeaderParam(value="x-ms-encryption-key-sha256") String var21, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var22, @HeaderParam(value="x-ms-encryption-scope") String var23, Context var24);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlockBlobsCommitBlockListResponse> commitBlockList(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="Content-MD5") String var5, @HeaderParam(value="x-ms-content-crc64") String var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-access-tier") AccessTier var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="x-ms-if-tags") String var14, @BodyParam(value="application/xml; charset=utf-8") BlockLookupList var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @HeaderParam(value="x-ms-tags") String var18, @QueryParam(value="comp") String var19, @HeaderParam(value="x-ms-blob-cache-control") String var20, @HeaderParam(value="x-ms-blob-content-type") String var21, @HeaderParam(value="x-ms-blob-content-encoding") String var22, @HeaderParam(value="x-ms-blob-content-language") String var23, @HeaderParam(value="x-ms-blob-content-md5") String var24, @HeaderParam(value="x-ms-blob-content-disposition") String var25, @HeaderParam(value="x-ms-encryption-key") String var26, @HeaderParam(value="x-ms-encryption-key-sha256") String var27, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var28, @HeaderParam(value="x-ms-encryption-scope") String var29, Context var30);

        @Get(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlockBlobsGetBlockListResponse> getBlockList(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="blocklisttype") BlockListType var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-if-tags") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="comp") String var11, Context var12);
    }
}

