/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockFromUrlResponse;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockResponse;
import com.azure.storage.blob.implementation.models.AppendBlobsCreateResponse;
import com.azure.storage.blob.implementation.models.AppendBlobsSealResponse;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AppendBlobsImpl {
    private AppendBlobsService service;
    private AzureBlobStorageImpl client;

    public AppendBlobsImpl(AzureBlobStorageImpl client) {
        this.service = (AppendBlobsService)RestProxy.create(AppendBlobsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<AppendBlobsCreateResponse> createWithRestResponseAsync(String containerName, String blob, long contentLength, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String blobTagsString = null;
        String blobType = "AppendBlob";
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String cacheControl = null;
        String contentDisposition = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        String contentMd5Converted = null;
        return this.service.create(containerName, blob, this.client.getUrl(), timeout, contentLength, metadata, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, "AppendBlob", contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<AppendBlobsCreateResponse> createWithRestResponseAsync(String containerName, String blob, long contentLength, Integer timeout, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String blobType = "AppendBlob";
        String contentType = null;
        if (blobHttpHeaders != null) {
            contentType = blobHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (blobHttpHeaders != null) {
            contentEncoding = blobHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (blobHttpHeaders != null) {
            contentLanguage = blobHttpHeaders.getContentLanguage();
        }
        byte[] contentMd5 = null;
        if (blobHttpHeaders != null) {
            contentMd5 = blobHttpHeaders.getContentMd5();
        }
        String cacheControl = null;
        if (blobHttpHeaders != null) {
            cacheControl = blobHttpHeaders.getCacheControl();
        }
        String contentDisposition = null;
        if (blobHttpHeaders != null) {
            contentDisposition = blobHttpHeaders.getContentDisposition();
        }
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.create(containerName, blob, this.client.getUrl(), timeout, contentLength, metadata, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, "AppendBlob", contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<AppendBlobsAppendBlockResponse> appendBlockWithRestResponseAsync(String containerName, String blob, Flux<ByteBuffer> body, long contentLength, Context context) {
        Integer timeout = null;
        String leaseId = null;
        Long maxSize = null;
        Long appendPosition = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "appendblock";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        String transactionalContentMD5Converted = null;
        String transactionalContentCrc64Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.appendBlock(containerName, blob, this.client.getUrl(), body, timeout, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "appendblock", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<AppendBlobsAppendBlockResponse> appendBlockWithRestResponseAsync(String containerName, String blob, Flux<ByteBuffer> body, long contentLength, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "appendblock";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.appendBlock(containerName, blob, this.client.getUrl(), body, timeout, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "appendblock", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<AppendBlobsAppendBlockFromUrlResponse> appendBlockFromUrlWithRestResponseAsync(String containerName, String blob, URL sourceUrl, long contentLength, Context context) {
        String sourceRange = null;
        Integer timeout = null;
        String leaseId = null;
        Long maxSize = null;
        Long appendPosition = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String requestId = null;
        String comp = "appendblock";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        String sourceContentMD5Converted = null;
        String sourceContentcrc64Converted = null;
        String transactionalContentMD5Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        return this.service.appendBlockFromUrl(containerName, blob, this.client.getUrl(), sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, contentLength, transactionalContentMD5Converted, leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "appendblock", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<AppendBlobsAppendBlockFromUrlResponse> appendBlockFromUrlWithRestResponseAsync(String containerName, String blob, URL sourceUrl, long contentLength, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "appendblock";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString((byte[])sourceContentcrc64);
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.appendBlockFromUrl(containerName, blob, this.client.getUrl(), sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, contentLength, transactionalContentMD5Converted, leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, "appendblock", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<AppendBlobsSealResponse> sealWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        String requestId = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        Long appendPosition = null;
        String comp = "seal";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.seal(containerName, blob, this.client.getUrl(), timeout, this.client.getVersion(), requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, appendPosition, "seal", context);
    }

    public Mono<AppendBlobsSealResponse> sealWithRestResponseAsync(String containerName, String blob, Integer timeout, String requestId, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, Long appendPosition, Context context) {
        String comp = "seal";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.seal(containerName, blob, this.client.getUrl(), timeout, this.client.getVersion(), requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, appendPosition, "seal", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageAppendBlobs")
    public static interface AppendBlobsService {
        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<AppendBlobsCreateResponse> create(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-if-tags") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="x-ms-tags") String var16, @HeaderParam(value="x-ms-blob-type") String var17, @HeaderParam(value="x-ms-blob-content-type") String var18, @HeaderParam(value="x-ms-blob-content-encoding") String var19, @HeaderParam(value="x-ms-blob-content-language") String var20, @HeaderParam(value="x-ms-blob-content-md5") String var21, @HeaderParam(value="x-ms-blob-cache-control") String var22, @HeaderParam(value="x-ms-blob-content-disposition") String var23, @HeaderParam(value="x-ms-encryption-key") String var24, @HeaderParam(value="x-ms-encryption-key-sha256") String var25, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var26, @HeaderParam(value="x-ms-encryption-scope") String var27, Context var28);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<AppendBlobsAppendBlockResponse> appendBlock(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-blob-condition-maxsize") Long var11, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Match") String var15, @HeaderParam(value="If-None-Match") String var16, @HeaderParam(value="x-ms-if-tags") String var17, @HeaderParam(value="x-ms-version") String var18, @HeaderParam(value="x-ms-client-request-id") String var19, @QueryParam(value="comp") String var20, @HeaderParam(value="x-ms-encryption-key") String var21, @HeaderParam(value="x-ms-encryption-key-sha256") String var22, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var23, @HeaderParam(value="x-ms-encryption-scope") String var24, Context var25);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<AppendBlobsAppendBlockFromUrlResponse> appendBlockFromUrl(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @HeaderParam(value="x-ms-copy-source") URL var4, @HeaderParam(value="x-ms-source-range") String var5, @HeaderParam(value="x-ms-source-content-md5") String var6, @HeaderParam(value="x-ms-source-content-crc64") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="Content-Length") long var9, @HeaderParam(value="Content-MD5") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-blob-condition-maxsize") Long var13, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var14, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var15, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var16, @HeaderParam(value="If-Match") String var17, @HeaderParam(value="If-None-Match") String var18, @HeaderParam(value="x-ms-if-tags") String var19, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var20, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var21, @HeaderParam(value="x-ms-source-if-match") String var22, @HeaderParam(value="x-ms-source-if-none-match") String var23, @HeaderParam(value="x-ms-version") String var24, @HeaderParam(value="x-ms-client-request-id") String var25, @QueryParam(value="comp") String var26, @HeaderParam(value="x-ms-encryption-key") String var27, @HeaderParam(value="x-ms-encryption-key-sha256") String var28, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var29, @HeaderParam(value="x-ms-encryption-scope") String var30, Context var31);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<AppendBlobsSealResponse> seal(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var12, @QueryParam(value="comp") String var13, Context var14);
    }
}

