/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.concurrent.Semaphore;
import java.util.function.LongSupplier;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;
import org.elasticsearch.xpack.enrich.EnrichPlugin;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;
import org.elasticsearch.xpack.enrich.EnrichPolicyRunner;
import org.elasticsearch.xpack.enrich.EnrichStore;
import org.elasticsearch.xpack.enrich.ExecuteEnrichPolicyTask;
import org.elasticsearch.xpack.enrich.action.InternalExecutePolicyAction;

public class EnrichPolicyExecutor {
    public static final String TASK_ACTION = "policy_execution";
    private final ClusterService clusterService;
    private final Client client;
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final LongSupplier nowSupplier;
    private final int fetchSize;
    private final EnrichPolicyLocks policyLocks;
    private final int maximumConcurrentPolicyExecutions;
    private final int maxForceMergeAttempts;
    private final Semaphore policyExecutionPermits;

    public EnrichPolicyExecutor(Settings settings, ClusterService clusterService, Client client, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, EnrichPolicyLocks policyLocks, LongSupplier nowSupplier) {
        this.clusterService = clusterService;
        this.client = client;
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.nowSupplier = nowSupplier;
        this.policyLocks = policyLocks;
        this.fetchSize = (Integer)EnrichPlugin.ENRICH_FETCH_SIZE_SETTING.get(settings);
        this.maximumConcurrentPolicyExecutions = (Integer)EnrichPlugin.ENRICH_MAX_CONCURRENT_POLICY_EXECUTIONS.get(settings);
        this.maxForceMergeAttempts = (Integer)EnrichPlugin.ENRICH_MAX_FORCE_MERGE_ATTEMPTS.get(settings);
        this.policyExecutionPermits = new Semaphore(this.maximumConcurrentPolicyExecutions);
    }

    public void coordinatePolicyExecution(ExecuteEnrichPolicyAction.Request request, ActionListener<ExecuteEnrichPolicyAction.Response> listener) {
        this.tryLockingPolicy(request.getName());
        try {
            this.client.execute((ActionType)InternalExecutePolicyAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> {
                if (response.getStatus() != null) {
                    this.releasePolicy(request.getName());
                    listener.onResponse(response);
                } else {
                    this.waitAndThenRelease(request.getName(), (ExecuteEnrichPolicyAction.Response)response);
                    listener.onResponse(response);
                }
            }, e -> {
                this.releasePolicy(request.getName());
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            this.releasePolicy(request.getName());
            throw e2;
        }
    }

    public void runPolicyLocally(ExecuteEnrichPolicyTask task, String policyName, ActionListener<ExecuteEnrichPolicyStatus> listener) {
        try {
            EnrichPolicy policy = EnrichStore.getPolicy(policyName, this.clusterService.state());
            if (policy == null) {
                throw new ResourceNotFoundException("policy [{}] does not exist", new Object[]{policyName});
            }
            task.setStatus(new ExecuteEnrichPolicyStatus("SCHEDULED"));
            Runnable runnable = this.createPolicyRunner(policyName, policy, task, listener);
            this.threadPool.executor("generic").execute(runnable);
        }
        catch (Exception e) {
            task.setStatus(new ExecuteEnrichPolicyStatus("FAILED"));
            throw e;
        }
    }

    private void tryLockingPolicy(String policyName) {
        this.policyLocks.lockPolicy(policyName);
        if (!this.policyExecutionPermits.tryAcquire()) {
            this.policyLocks.releasePolicy(policyName);
            throw new EsRejectedExecutionException("Policy execution failed. Policy execution for [" + policyName + "] would exceed maximum concurrent policy executions [" + this.maximumConcurrentPolicyExecutions + "]");
        }
    }

    private void releasePolicy(String policyName) {
        try {
            this.policyExecutionPermits.release();
        }
        finally {
            this.policyLocks.releasePolicy(policyName);
        }
    }

    private void waitAndThenRelease(String policyName, ExecuteEnrichPolicyAction.Response response) {
        GetTaskRequest getTaskRequest = new GetTaskRequest();
        getTaskRequest.setTaskId(response.getTaskId());
        getTaskRequest.setWaitForCompletion(true);
        this.client.admin().cluster().getTask(getTaskRequest, ActionListener.wrap(() -> this.releasePolicy(policyName)));
    }

    private Runnable createPolicyRunner(String policyName, EnrichPolicy policy, ExecuteEnrichPolicyTask task, ActionListener<ExecuteEnrichPolicyStatus> listener) {
        return new EnrichPolicyRunner(policyName, policy, task, listener, this.clusterService, this.client, this.indexNameExpressionResolver, this.nowSupplier, this.fetchSize, this.maxForceMergeAttempts);
    }
}

