/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.Index;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;

public final class EnrichCache {
    private final Cache<CacheKey, List<Map<?, ?>>> cache;
    private volatile Metadata metadata;

    EnrichCache(long maxSize) {
        this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
    }

    List<Map<?, ?>> get(SearchRequest searchRequest) {
        String enrichIndex = this.getEnrichIndexKey(searchRequest);
        CacheKey cacheKey = new CacheKey(enrichIndex, searchRequest);
        List response = (List)this.cache.get((Object)cacheKey);
        if (response != null) {
            return EnrichCache.deepCopy(response, false);
        }
        return null;
    }

    void put(SearchRequest searchRequest, List<Map<?, ?>> response) {
        String enrichIndex = this.getEnrichIndexKey(searchRequest);
        CacheKey cacheKey = new CacheKey(enrichIndex, searchRequest);
        this.cache.put((Object)cacheKey, response);
    }

    void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public EnrichStatsAction.Response.CacheStats getStats(String localNodeId) {
        Cache.CacheStats cacheStats = this.cache.stats();
        return new EnrichStatsAction.Response.CacheStats(localNodeId, (long)this.cache.count(), cacheStats.getHits(), cacheStats.getMisses(), cacheStats.getEvictions());
    }

    private String getEnrichIndexKey(SearchRequest searchRequest) {
        String alias = searchRequest.indices()[0];
        IndexAbstraction ia = (IndexAbstraction)this.metadata.getIndicesLookup().get(alias);
        return ((Index)ia.getIndices().get(0)).getName();
    }

    List<Map<?, ?>> toCacheValue(SearchResponse response) {
        ArrayList<Map> result = new ArrayList<Map>(response.getHits().getHits().length);
        for (SearchHit hit : response.getHits()) {
            result.add(EnrichCache.deepCopy(hit.getSourceAsMap(), true));
        }
        return Collections.unmodifiableList(result);
    }

    static <T> T deepCopy(T value, boolean unmodifiable) {
        return (T)EnrichCache.innerDeepCopy(value, unmodifiable);
    }

    private static Object innerDeepCopy(Object value, boolean unmodifiable) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            Map copy = Maps.newMapWithExpectedSize((int)mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                copy.put(entry.getKey(), EnrichCache.innerDeepCopy(entry.getValue(), unmodifiable));
            }
            return unmodifiable ? Collections.unmodifiableMap(copy) : copy;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(listValue.size());
            for (Object itemValue : listValue) {
                copy.add(EnrichCache.innerDeepCopy(itemValue, unmodifiable));
            }
            return unmodifiable ? Collections.unmodifiableList(copy) : copy;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.copyOf(bytes, bytes.length);
        }
        if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        throw new IllegalArgumentException("unexpected value type [" + value.getClass() + "]");
    }

    private static class CacheKey {
        final String enrichIndex;
        final SearchRequest searchRequest;

        private CacheKey(String enrichIndex, SearchRequest searchRequest) {
            this.enrichIndex = enrichIndex;
            this.searchRequest = searchRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.enrichIndex.equals(cacheKey.enrichIndex) && this.searchRequest.equals((Object)cacheKey.searchRequest);
        }

        public int hashCode() {
            return Objects.hash(this.enrichIndex, this.searchRequest);
        }
    }
}

