/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class NamedXContentRegistry {
    public static final NamedXContentRegistry EMPTY = new NamedXContentRegistry(Collections.emptyList());
    private final Map<RestApiVersion, Map<Class<?>, Map<String, Entry>>> registry;

    public NamedXContentRegistry(List<Entry> entries) {
        this.registry = Collections.unmodifiableMap(this.createRegistry(entries));
    }

    private Map<RestApiVersion, Map<Class<?>, Map<String, Entry>>> createRegistry(List<Entry> entries) {
        if (entries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap newRegistry = new HashMap();
        for (Entry entry : entries) {
            for (String name : entry.name.getAllNamesIncludedDeprecated()) {
                if (RestApiVersion.minimumSupported().matches(entry.restApiCompatibility)) {
                    this.registerParsers(newRegistry, entry, name, RestApiVersion.minimumSupported());
                }
                if (!RestApiVersion.current().matches(entry.restApiCompatibility)) continue;
                this.registerParsers(newRegistry, entry, name, RestApiVersion.current());
            }
        }
        return newRegistry;
    }

    private void registerParsers(Map<RestApiVersion, Map<Class<?>, Map<String, Entry>>> newRegistry, Entry entry, String name, RestApiVersion restApiVersion) {
        Map classRegistry = newRegistry.computeIfAbsent(restApiVersion, v -> new HashMap());
        Map parsers = classRegistry.computeIfAbsent(entry.categoryClass, v -> new HashMap());
        Entry old = parsers.put(name, entry);
        if (old != null) {
            throw new IllegalArgumentException("NamedXContent [" + entry.categoryClass.getName() + "][" + entry.name + "] is already registered for [" + old.getClass().getName() + "], cannot register [" + entry.parser.getClass().getName() + "]");
        }
    }

    public <T, C> T parseNamedObject(Class<T> categoryClass, String name, XContentParser parser, C context) throws IOException {
        Entry entry = this.lookupParser(categoryClass, name, parser);
        return categoryClass.cast(entry.parser.parse(parser, context));
    }

    public <T> Entry lookupParser(Class<T> categoryClass, String name, XContentParser parser) {
        Map parsers = (Map)this.registry.getOrDefault(parser.getRestApiVersion(), Collections.emptyMap()).get(categoryClass);
        if (parsers == null) {
            if (this.registry.isEmpty()) {
                throw new XContentParseException("named objects are not supported for this parser");
            }
            throw new XContentParseException("unknown named object category [" + categoryClass.getName() + "]");
        }
        Entry entry = (Entry)parsers.get(name);
        if (entry == null) {
            throw new NamedObjectNotFoundException(parser.getTokenLocation(), "unknown field [" + name + "]", parsers.keySet());
        }
        if (!entry.name.match(name, parser.getDeprecationHandler())) {
            throw new XContentParseException(parser.getTokenLocation(), "unable to parse " + categoryClass.getSimpleName() + " with name [" + name + "]: parser didn't match");
        }
        return entry;
    }

    public static class Entry {
        public final Class<?> categoryClass;
        public final ParseField name;
        public final Function<RestApiVersion, Boolean> restApiCompatibility;
        private final ContextParser<Object, ?> parser;

        public <T> Entry(Class<T> categoryClass, ParseField name, CheckedFunction<XContentParser, ? extends T, IOException> parser) {
            this(categoryClass, name, (XContentParser p, Object c) -> parser.apply((Object)p), name.getForRestApiVersion());
        }

        public <T> Entry(Class<T> categoryClass, ParseField name, CheckedFunction<XContentParser, ? extends T, IOException> parser, Function<RestApiVersion, Boolean> restApiCompatibility) {
            this(categoryClass, name, (XContentParser p, Object c) -> parser.apply((Object)p), restApiCompatibility);
        }

        public <T> Entry(Class<T> categoryClass, ParseField name, ContextParser<Object, ? extends T> parser) {
            this(categoryClass, name, parser, name.getForRestApiVersion());
        }

        public <T> Entry(Class<T> categoryClass, ParseField name, ContextParser<Object, ? extends T> parser, Function<RestApiVersion, Boolean> restApiCompatibility) {
            this.categoryClass = Objects.requireNonNull(categoryClass);
            this.name = Objects.requireNonNull(name);
            this.parser = Objects.requireNonNull(parser);
            this.restApiCompatibility = restApiCompatibility;
        }
    }
}

