/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.repository.url;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.url.http.URLHttpClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.url.URLRepository;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class URLRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    private final SetOnce<URLHttpClient.Factory> httpClientFactory = new SetOnce();

    public List<Setting<?>> getSettings() {
        return Arrays.asList(URLRepository.ALLOWED_URLS_SETTING, URLRepository.REPOSITORIES_URL_SETTING, URLRepository.SUPPORTED_PROTOCOLS_SETTING);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        return Collections.singletonMap("url", metadata -> {
            assert (this.httpClientFactory.get() != null) : "Expected to get a configured http client factory";
            return new URLRepository(metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings, (URLHttpClient.Factory)this.httpClientFactory.get());
        });
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        URLHttpClient.Factory apacheURLHttpClientFactory = new URLHttpClient.Factory();
        this.httpClientFactory.set((Object)apacheURLHttpClientFactory);
        return List.of(apacheURLHttpClientFactory);
    }

    public void close() throws IOException {
        super.close();
        IOUtils.closeWhileHandlingException((Closeable)((Closeable)this.httpClientFactory.get()));
    }
}

