/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plugin;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncStatusRequest;
import org.elasticsearch.xpack.core.async.StoredAsyncResponse;
import org.elasticsearch.xpack.core.async.StoredAsyncTask;
import org.elasticsearch.xpack.ql.async.QlStatusResponse;

public abstract class AbstractTransportQlAsyncGetStatusAction<Response extends ActionResponse, AsyncTask extends StoredAsyncTask<Response>>
extends HandledTransportAction<GetAsyncStatusRequest, QlStatusResponse> {
    private final String actionName;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final Class<? extends AsyncTask> asyncTaskClass;
    private final AsyncTaskIndexService<StoredAsyncResponse<Response>> store;

    public AbstractTransportQlAsyncGetStatusAction(String actionName, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool, BigArrays bigArrays, Class<? extends AsyncTask> asyncTaskClass) {
        super(actionName, transportService, actionFilters, GetAsyncStatusRequest::new);
        this.actionName = actionName;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.asyncTaskClass = asyncTaskClass;
        Writeable.Reader reader = in -> new StoredAsyncResponse(this.responseReader(), in);
        this.store = new AsyncTaskIndexService(".async-search", clusterService, threadPool.getThreadContext(), client, "async_search", reader, registry, bigArrays);
    }

    protected void doExecute(Task task, GetAsyncStatusRequest request, ActionListener<QlStatusResponse> listener) {
        AsyncExecutionId searchId = AsyncExecutionId.decode((String)request.getId());
        DiscoveryNode node = this.clusterService.state().nodes().get(searchId.getTaskId().getNodeId());
        DiscoveryNode localNode = this.clusterService.state().getNodes().getLocalNode();
        if (node == null || Objects.equals(node, localNode)) {
            this.store.retrieveStatus(request, this.taskManager, this.asyncTaskClass, AbstractTransportQlAsyncGetStatusAction::getStatusResponse, QlStatusResponse::getStatusFromStoredSearch, listener);
        } else {
            this.transportService.sendRequest(node, this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, QlStatusResponse::new, "same"));
        }
    }

    private static QlStatusResponse getStatusResponse(StoredAsyncTask<?> asyncTask) {
        return new QlStatusResponse(asyncTask.getExecutionId().getEncoded(), true, true, asyncTask.getStartTime(), asyncTask.getExpirationTimeMillis(), null);
    }

    protected abstract Writeable.Reader<Response> responseReader();
}

