/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.shutdown.DeleteShutdownNodeAction;

public class TransportDeleteShutdownNodeAction
extends AcknowledgedTransportMasterNodeAction<DeleteShutdownNodeAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteShutdownNodeAction.class);

    @Inject
    public TransportDeleteShutdownNodeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/shutdown/delete", transportService, clusterService, threadPool, actionFilters, DeleteShutdownNodeAction.Request::new, indexNameExpressionResolver, "same");
    }

    protected void masterOperation(Task task, final DeleteShutdownNodeAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        NodesShutdownMetadata nodesShutdownMetadata = (NodesShutdownMetadata)state.metadata().custom("node_shutdown");
        if (nodesShutdownMetadata == null || nodesShutdownMetadata.getAllNodeMetadataMap().get(request.getNodeId()) == null) {
            throw new ResourceNotFoundException("node [" + request.getNodeId() + "] is not currently shutting down", new Object[0]);
        }
        this.clusterService.submitStateUpdateTask("delete-node-shutdown-" + request.getNodeId(), (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                NodesShutdownMetadata currentShutdownMetadata = (NodesShutdownMetadata)currentState.metadata().custom("node_shutdown");
                logger.info("removing shutdown record for node [{}]", (Object)request.getNodeId());
                return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).putCustom("node_shutdown", (Metadata.Custom)currentShutdownMetadata.removeSingleNodeMetadata(request.getNodeId()))).build();
            }

            public void onFailure(Exception e) {
                logger.error((Message)new ParameterizedMessage("failed to delete shutdown for node [{}]", (Object)request.getNodeId()), (Throwable)e);
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                TransportDeleteShutdownNodeAction.this.clusterService.getRerouteService().reroute("node registered for removal from cluster", Priority.NORMAL, (ActionListener)new ActionListener<ClusterState>(){

                    public void onResponse(ClusterState clusterState) {
                        logger.trace("started reroute after deleting node [{}}] shutdown", (Object)request.getNodeId());
                        listener.onResponse((Object)AcknowledgedResponse.TRUE);
                    }

                    public void onFailure(Exception e) {
                        logger.warn((Message)new ParameterizedMessage("failed to start reroute after deleting node [{}] shutdown", (Object)request.getNodeId()), (Throwable)e);
                        listener.onFailure(e);
                    }
                });
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    protected ClusterBlockException checkBlock(DeleteShutdownNodeAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

