/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.service.ClusterService;

public class NodeSeenService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(NodeSeenService.class);
    final ClusterService clusterService;

    public NodeSeenService(ClusterService clusterService) {
        this.clusterService = clusterService;
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        boolean thisNodeJustBecameMaster = !event.previousState().nodes().isLocalNodeElectedMaster() && event.state().nodes().isLocalNodeElectedMaster();
        if (!(event.nodesAdded() || thisNodeJustBecameMaster)) {
            return;
        }
        NodesShutdownMetadata eventShutdownMetadata = (NodesShutdownMetadata)event.state().metadata().custom("node_shutdown");
        if (eventShutdownMetadata == null) {
            return;
        }
        final Set nodesNotPreviouslySeen = eventShutdownMetadata.getAllNodeMetadataMap().values().stream().filter(singleNodeShutdownMetadata -> !singleNodeShutdownMetadata.getNodeSeen()).map(SingleNodeShutdownMetadata::getNodeId).filter(nodeId -> event.state().nodes().nodeExists(nodeId)).collect(Collectors.toUnmodifiableSet());
        if (!nodesNotPreviouslySeen.isEmpty()) {
            this.clusterService.submitStateUpdateTask("shutdown-seen-nodes-updater", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) throws Exception {
                    NodesShutdownMetadata currentShutdownMetadata = (NodesShutdownMetadata)currentState.metadata().custom("node_shutdown");
                    Map newShutdownMetadataMap = currentShutdownMetadata.getAllNodeMetadataMap().values().stream().map(singleNodeShutdownMetadata -> {
                        if (nodesNotPreviouslySeen.contains(singleNodeShutdownMetadata.getNodeId()) || currentState.nodes().nodeExists(singleNodeShutdownMetadata.getNodeId())) {
                            return SingleNodeShutdownMetadata.builder((SingleNodeShutdownMetadata)singleNodeShutdownMetadata).setNodeSeen(true).build();
                        }
                        return singleNodeShutdownMetadata;
                    }).collect(Collectors.toUnmodifiableMap(SingleNodeShutdownMetadata::getNodeId, Function.identity()));
                    NodesShutdownMetadata newNodesMetadata = new NodesShutdownMetadata(newShutdownMetadataMap);
                    if (newNodesMetadata.equals((Object)currentShutdownMetadata)) {
                        return currentState;
                    }
                    return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).putCustom("node_shutdown", (Metadata.Custom)newNodesMetadata).build()).build();
                }

                public void onFailure(Exception e) {
                    logger.warn((Message)new ParameterizedMessage("failed to mark shutting down nodes as seen: {}", (Object)nodesNotPreviouslySeen), (Throwable)e);
                }
            }, ClusterStateTaskExecutor.unbatched());
        }
    }
}

