/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.history;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.ilm.IndexLifecycle;

public class SnapshotLifecycleTemplateRegistry
extends IndexTemplateRegistry {
    public static final int INDEX_TEMPLATE_VERSION = 5;
    public static final String SLM_TEMPLATE_VERSION_VARIABLE = "xpack.slm.template.version";
    public static final String SLM_TEMPLATE_NAME = ".slm-history";
    public static final String SLM_POLICY_NAME = "slm-history-ilm-policy";
    private final boolean slmHistoryEnabled;
    public static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS = SnapshotLifecycleTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(".slm-history", "/slm-history.json", 5, "xpack.slm.template.version")});
    private static final List<LifecyclePolicy> LIFECYCLE_POLICIES = List.of(new LifecyclePolicyConfig("slm-history-ilm-policy", "/slm-history-ilm-policy.json").load(new NamedXContentRegistry(IndexLifecycle.NAMED_X_CONTENT_ENTRIES)));

    protected boolean requiresMasterNode() {
        return true;
    }

    public SnapshotLifecycleTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.slmHistoryEnabled = (Boolean)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (!this.slmHistoryEnabled) {
            return Map.of();
        }
        return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
    }

    protected List<LifecyclePolicy> getPolicyConfigs() {
        if (!this.slmHistoryEnabled) {
            return Collections.emptyList();
        }
        return LIFECYCLE_POLICIES;
    }

    protected String getOrigin() {
        return "index_lifecycle";
    }

    public boolean validate(ClusterState state) {
        boolean allTemplatesPresent = this.getComposableTemplateConfigs().keySet().stream().allMatch(name -> state.metadata().templatesV2().containsKey(name));
        Optional<Map> maybePolicies = Optional.ofNullable((IndexLifecycleMetadata)state.metadata().custom("index_lifecycle")).map(IndexLifecycleMetadata::getPolicies);
        Set policyNames = this.getPolicyConfigs().stream().map(LifecyclePolicy::getName).collect(Collectors.toSet());
        boolean allPoliciesPresent = maybePolicies.map(policies -> policies.keySet().containsAll(policyNames)).orElse(false);
        return allTemplatesPresent && allPoliciesPresent;
    }
}

