/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleStatsAction;

public class TransportGetSnapshotLifecycleStatsAction
extends TransportMasterNodeAction<GetSnapshotLifecycleStatsAction.Request, GetSnapshotLifecycleStatsAction.Response> {
    @Inject
    public TransportGetSnapshotLifecycleStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/stats", transportService, clusterService, threadPool, actionFilters, GetSnapshotLifecycleStatsAction.Request::new, indexNameExpressionResolver, GetSnapshotLifecycleStatsAction.Response::new, "same");
    }

    protected void masterOperation(Task task, GetSnapshotLifecycleStatsAction.Request request, ClusterState state, ActionListener<GetSnapshotLifecycleStatsAction.Response> listener) {
        SnapshotLifecycleMetadata slmMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        if (slmMeta == null) {
            listener.onResponse((Object)new GetSnapshotLifecycleStatsAction.Response(new SnapshotLifecycleStats()));
        } else {
            listener.onResponse((Object)new GetSnapshotLifecycleStatsAction.Response(slmMeta.getStats()));
        }
    }

    protected ClusterBlockException checkBlock(GetSnapshotLifecycleStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

