/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.slm.SnapshotRetentionTask;

public class UpdateSnapshotLifecycleStatsTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(SnapshotRetentionTask.class);
    private final SnapshotLifecycleStats runStats;
    static final String TASK_SOURCE = "update_slm_stats";

    UpdateSnapshotLifecycleStatsTask(SnapshotLifecycleStats runStats) {
        this.runStats = runStats;
    }

    public ClusterState execute(ClusterState currentState) {
        Metadata currentMeta = currentState.metadata();
        SnapshotLifecycleMetadata currentSlmMeta = (SnapshotLifecycleMetadata)currentMeta.custom("snapshot_lifecycle");
        if (currentSlmMeta == null) {
            return currentState;
        }
        SnapshotLifecycleStats newMetrics = currentSlmMeta.getStats().merge(this.runStats);
        SnapshotLifecycleMetadata newSlmMeta = new SnapshotLifecycleMetadata(currentSlmMeta.getSnapshotConfigurations(), currentSlmMeta.getOperationMode(), newMetrics);
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentMeta).putCustom("snapshot_lifecycle", (Metadata.Custom)newSlmMeta)).build();
    }

    public void onFailure(Exception e) {
        logger.error((Message)new ParameterizedMessage("failed to update cluster state with snapshot lifecycle stats, source: [update_slm_stats], missing stats: [{}]", (Object)this.runStats), (Throwable)e);
    }
}

