/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.action.MoveToStepAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;

public class TransportMoveToStepAction
extends TransportMasterNodeAction<MoveToStepAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportMoveToStepAction.class);
    IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportMoveToStepAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexLifecycleService indexLifecycleService) {
        super("cluster:admin/ilm/_move/post", transportService, clusterService, threadPool, actionFilters, MoveToStepAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, "same");
        this.indexLifecycleService = indexLifecycleService;
    }

    protected void masterOperation(Task task, final MoveToStepAction.Request request, final ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        final IndexMetadata indexMetadata = state.metadata().index(request.getIndex());
        if (indexMetadata == null) {
            listener.onFailure((Exception)new IllegalArgumentException("index [" + request.getIndex() + "] does not exist"));
            return;
        }
        String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
        if (policyName == null) {
            listener.onFailure((Exception)new IllegalArgumentException("index [" + request.getIndex() + "] is not managed by ILM"));
            return;
        }
        final MoveToStepAction.Request.PartialStepKey abstractTargetKey = request.getNextStepKey();
        String targetStr = abstractTargetKey.getPhase() + "/" + abstractTargetKey.getAction() + "/" + abstractTargetKey.getName();
        Step.StepKey concreteTargetStepKey = this.indexLifecycleService.resolveStepKey(state, indexMetadata.getIndex(), abstractTargetKey.getPhase(), abstractTargetKey.getAction(), abstractTargetKey.getName());
        if (concreteTargetStepKey == null) {
            String message = "cannot move index [" + indexMetadata.getIndex().getName() + "] with policy [" + policyName + "]: unable to determine concrete step key from target next step key: " + abstractTargetKey;
            logger.warn(message);
            listener.onFailure((Exception)new IllegalArgumentException(message));
            return;
        }
        this.clusterService.submitStateUpdateTask("index[" + request.getIndex() + "]-move-to-step-" + targetStr, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, listener){
            final SetOnce<Step.StepKey> concreteTargetKey;
            {
                super(arg0, arg1);
                this.concreteTargetKey = new SetOnce();
            }

            public ClusterState execute(ClusterState currentState) {
                Step.StepKey concreteTargetStepKey = TransportMoveToStepAction.this.indexLifecycleService.resolveStepKey(state, indexMetadata.getIndex(), abstractTargetKey.getPhase(), abstractTargetKey.getAction(), abstractTargetKey.getName());
                if (concreteTargetStepKey == null) {
                    logger.error("unable to move index " + indexMetadata.getIndex() + " as we are unable to resolve a concrete step key from target next step key: " + abstractTargetKey);
                    return currentState;
                }
                this.concreteTargetKey.set((Object)concreteTargetStepKey);
                return TransportMoveToStepAction.this.indexLifecycleService.moveClusterStateToStep(currentState, indexMetadata.getIndex(), request.getCurrentStepKey(), (Step.StepKey)this.concreteTargetKey.get());
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                IndexMetadata newIndexMetadata = newState.metadata().index(indexMetadata.getIndex());
                if (newIndexMetadata == null) {
                    logger.debug("index [" + indexMetadata.getIndex() + "] has been deleted after moving to step [" + this.concreteTargetKey.get() + "], skipping async action check");
                    return;
                }
                TransportMoveToStepAction.this.indexLifecycleService.maybeRunAsyncAction(newState, newIndexMetadata, (Step.StepKey)this.concreteTargetKey.get());
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    protected ClusterBlockException checkBlock(MoveToStepAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

