/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class OperationModeUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(OperationModeUpdateTask.class);
    @Nullable
    private final OperationMode ilmMode;
    @Nullable
    private final OperationMode slmMode;

    public static AckedClusterStateUpdateTask wrap(final OperationModeUpdateTask task, AckedRequest request, ActionListener<AcknowledgedResponse> listener) {
        return new AckedClusterStateUpdateTask(task.priority(), request, listener){

            public ClusterState execute(ClusterState currentState) {
                return task.execute(currentState);
            }
        };
    }

    private OperationModeUpdateTask(Priority priority, OperationMode ilmMode, OperationMode slmMode) {
        super(priority);
        this.ilmMode = ilmMode;
        this.slmMode = slmMode;
    }

    public static OperationModeUpdateTask ilmMode(OperationMode mode) {
        return new OperationModeUpdateTask(OperationModeUpdateTask.getPriority(mode), mode, null);
    }

    public static OperationModeUpdateTask slmMode(OperationMode mode) {
        return new OperationModeUpdateTask(OperationModeUpdateTask.getPriority(mode), null, mode);
    }

    private static Priority getPriority(OperationMode mode) {
        if (mode == OperationMode.STOPPED || mode == OperationMode.STOPPING) {
            return Priority.IMMEDIATE;
        }
        return Priority.NORMAL;
    }

    OperationMode getILMOperationMode() {
        return this.ilmMode;
    }

    OperationMode getSLMOperationMode() {
        return this.slmMode;
    }

    public ClusterState execute(ClusterState currentState) {
        ClusterState newState = currentState;
        newState = this.updateILMState(newState);
        newState = this.updateSLMState(newState);
        return newState;
    }

    private ClusterState updateILMState(ClusterState currentState) {
        OperationMode newMode;
        if (this.ilmMode == null) {
            return currentState;
        }
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
        if (currentMetadata != null && !currentMetadata.getOperationMode().isValidChange(this.ilmMode)) {
            return currentState;
        }
        if (currentMetadata == null) {
            currentMetadata = IndexLifecycleMetadata.EMPTY;
        }
        if (!(newMode = currentMetadata.getOperationMode().isValidChange(this.ilmMode) ? this.ilmMode : currentMetadata.getOperationMode()).equals((Object)this.ilmMode)) {
            logger.info("updating ILM operation mode to {}", (Object)newMode);
        }
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).putCustom("index_lifecycle", (Metadata.Custom)new IndexLifecycleMetadata(currentMetadata.getPolicyMetadatas(), newMode))).build();
    }

    private ClusterState updateSLMState(ClusterState currentState) {
        OperationMode newMode;
        if (this.slmMode == null) {
            return currentState;
        }
        SnapshotLifecycleMetadata currentMetadata = (SnapshotLifecycleMetadata)currentState.metadata().custom("snapshot_lifecycle");
        if (currentMetadata != null && !currentMetadata.getOperationMode().isValidChange(this.slmMode)) {
            return currentState;
        }
        if (currentMetadata == null) {
            currentMetadata = SnapshotLifecycleMetadata.EMPTY;
        }
        if (!(newMode = currentMetadata.getOperationMode().isValidChange(this.slmMode) ? this.slmMode : currentMetadata.getOperationMode()).equals((Object)this.slmMode)) {
            logger.info("updating SLM operation mode to {}", (Object)newMode);
        }
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).putCustom("snapshot_lifecycle", (Metadata.Custom)new SnapshotLifecycleMetadata(currentMetadata.getSnapshotConfigurations(), newMode, currentMetadata.getStats()))).build();
    }

    public void onFailure(Exception e) {
        logger.error("unable to update lifecycle metadata with new ilm mode [" + this.ilmMode + "], slm mode [" + this.slmMode + "]", (Throwable)e);
    }

    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
        if (this.ilmMode != null) {
            logger.info("ILM operation mode updated to {}", (Object)this.ilmMode);
        }
        if (this.slmMode != null) {
            logger.info("SLM operation mode updated to {}", (Object)this.slmMode);
        }
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ilmMode, this.slmMode);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OperationModeUpdateTask other = (OperationModeUpdateTask)((Object)obj);
        return Objects.equals(this.priority(), other.priority()) && Objects.equals(this.ilmMode, other.ilmMode) && Objects.equals(this.slmMode, other.slmMode);
    }
}

