/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.Closeable;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ShutdownAwarePlugin;
import org.elasticsearch.shutdown.PluginShutdownService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleOriginationDateParser;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.ilm.IndexLifecycleRunner;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;
import org.elasticsearch.xpack.ilm.OperationModeUpdateTask;
import org.elasticsearch.xpack.ilm.PolicyStepsRegistry;
import org.elasticsearch.xpack.ilm.TimeValueSchedule;
import org.elasticsearch.xpack.ilm.history.ILMHistoryStore;

public class IndexLifecycleService
implements ClusterStateListener,
ClusterStateApplier,
SchedulerEngine.Listener,
Closeable,
IndexEventListener,
ShutdownAwarePlugin {
    private static final Logger logger = LogManager.getLogger(IndexLifecycleService.class);
    private static final Set<String> IGNORE_STEPS_MAINTENANCE_REQUESTED = Set.of("shrink", "rollup");
    private volatile boolean isMaster = false;
    private volatile TimeValue pollInterval;
    private final SetOnce<SchedulerEngine> scheduler = new SetOnce();
    private final Clock clock;
    private final PolicyStepsRegistry policyRegistry;
    private final IndexLifecycleRunner lifecycleRunner;
    private final Settings settings;
    private final ClusterService clusterService;
    private final LongSupplier nowSupplier;
    private SchedulerEngine.Job scheduledJob;

    public IndexLifecycleService(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, Clock clock, LongSupplier nowSupplier, NamedXContentRegistry xContentRegistry, ILMHistoryStore ilmHistoryStore, XPackLicenseState licenseState) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.clock = clock;
        this.nowSupplier = nowSupplier;
        this.scheduledJob = null;
        this.policyRegistry = new PolicyStepsRegistry(xContentRegistry, client, licenseState);
        this.lifecycleRunner = new IndexLifecycleRunner(this.policyRegistry, ilmHistoryStore, clusterService, threadPool, nowSupplier);
        this.pollInterval = (TimeValue)LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING.get(settings);
        clusterService.addStateApplier((ClusterStateApplier)this);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING, this::updatePollInterval);
    }

    public void maybeRunAsyncAction(ClusterState clusterState, IndexMetadata indexMetadata, Step.StepKey nextStepKey) {
        String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
        this.lifecycleRunner.maybeRunAsyncAction(clusterState, indexMetadata, policyName, nextStepKey);
    }

    public Step.StepKey resolveStepKey(ClusterState state, Index index, String phase, @Nullable String action, @Nullable String name) {
        if (name == null) {
            if (action == null) {
                return this.policyRegistry.getFirstStepForPhase(state, index, phase);
            }
            return this.policyRegistry.getFirstStepForPhaseAndAction(state, index, phase, action);
        }
        assert (action != null) : "action should never be null because we don't allow constructing a partial step key with only a phase and name";
        return new Step.StepKey(phase, action, name);
    }

    public ClusterState moveClusterStateToStep(ClusterState currentState, Index index, Step.StepKey currentStepKey, Step.StepKey newStepKey) {
        IndexLifecycleTransition.validateTransition(currentState.getMetadata().index(index), currentStepKey, newStepKey, this.policyRegistry);
        return IndexLifecycleTransition.moveClusterStateToStep(index, currentState, newStepKey, this.nowSupplier, this.policyRegistry, true);
    }

    public ClusterState moveClusterStateToPreviouslyFailedStep(ClusterState currentState, String[] indices) {
        ClusterState newState = currentState;
        for (String index : indices) {
            newState = IndexLifecycleTransition.moveClusterStateToPreviouslyFailedStep(newState, index, this.nowSupplier, this.policyRegistry, false);
        }
        return newState;
    }

    void onMaster(ClusterState clusterState) {
        this.maybeScheduleJob();
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)clusterState.metadata().custom("index_lifecycle");
        if (currentMetadata != null) {
            OperationMode currentMode = currentMetadata.getOperationMode();
            if (OperationMode.STOPPED.equals((Object)currentMode)) {
                return;
            }
            boolean safeToStop = true;
            for (IndexMetadata idxMeta : clusterState.metadata().indices().values()) {
                String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings());
                if (Strings.isNullOrEmpty((String)policyName)) continue;
                LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
                Step.StepKey stepKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
                try {
                    if (OperationMode.STOPPING == currentMode) {
                        if (stepKey != null && IGNORE_STEPS_MAINTENANCE_REQUESTED.contains(stepKey.getName())) {
                            logger.info("waiting to stop ILM because index [{}] with policy [{}] is currently in step [{}]", (Object)idxMeta.getIndex().getName(), (Object)policyName, (Object)stepKey.getName());
                            this.lifecycleRunner.maybeRunAsyncAction(clusterState, idxMeta, policyName, stepKey);
                            safeToStop = false;
                            continue;
                        }
                        logger.info("skipping policy execution of step [{}] for index [{}] with policy [{}] because ILM is stopping", (Object)(stepKey == null ? "n/a" : stepKey.getName()), (Object)idxMeta.getIndex().getName(), (Object)policyName);
                        continue;
                    }
                    this.lifecycleRunner.maybeRunAsyncAction(clusterState, idxMeta, policyName, stepKey);
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.warn((Message)new ParameterizedMessage("async action execution failed during master election trigger for index [{}] with policy [{}] in step [{}], lifecycle state: [{}]", new Object[]{idxMeta.getIndex().getName(), policyName, stepKey, lifecycleState.asMap()}), (Throwable)e);
                        continue;
                    }
                    logger.warn((Message)new ParameterizedMessage("async action execution failed during master election trigger for index [{}] with policy [{}] in step [{}]", new Object[]{idxMeta.getIndex().getName(), policyName, stepKey}), (Throwable)e);
                }
            }
            if (safeToStop && OperationMode.STOPPING == currentMode) {
                this.clusterService.submitStateUpdateTask("ilm_operation_mode_update[stopped]", (ClusterStateTaskConfig)OperationModeUpdateTask.ilmMode(OperationMode.STOPPED), ClusterStateTaskExecutor.unbatched());
            }
        }
    }

    public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
        if (IndexLifecycleOriginationDateParser.shouldParseIndexName((Settings)indexSettings)) {
            IndexLifecycleOriginationDateParser.parseIndexNameAndExtractDate((String)index.getName());
        }
    }

    private void updatePollInterval(TimeValue newInterval) {
        this.pollInterval = newInterval;
        this.maybeScheduleJob();
    }

    SchedulerEngine getScheduler() {
        return (SchedulerEngine)this.scheduler.get();
    }

    SchedulerEngine.Job getScheduledJob() {
        return this.scheduledJob;
    }

    private synchronized void maybeScheduleJob() {
        if (this.isMaster) {
            if (this.scheduler.get() == null && !this.isClusterServiceStoppedOrClosed()) {
                this.scheduler.set((Object)new SchedulerEngine(this.settings, this.clock));
                ((SchedulerEngine)this.scheduler.get()).register((SchedulerEngine.Listener)this);
            }
            if (this.scheduler.get() != null) {
                this.scheduledJob = new SchedulerEngine.Job("ilm", (SchedulerEngine.Schedule)new TimeValueSchedule(this.pollInterval));
                ((SchedulerEngine)this.scheduler.get()).add(this.scheduledJob);
            }
        }
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.onMaster(event.state());
            } else {
                this.cancelJob();
                this.policyRegistry.clear();
            }
        }
        if (this.isMaster) {
            for (Index index : event.indicesDeleted()) {
                this.policyRegistry.delete(index);
            }
            IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)event.state().metadata().custom("index_lifecycle");
            if (lifecycleMetadata != null) {
                this.triggerPolicies(event.state(), true);
            }
        }
    }

    public void applyClusterState(ClusterChangedEvent event) {
        IndexLifecycleMetadata ilmMetadata;
        if (event.localNodeMaster() && (ilmMetadata = (IndexLifecycleMetadata)event.state().metadata().custom("index_lifecycle")) != null && (!event.previousState().nodes().isLocalNodeElectedMaster() || ilmMetadata != event.previousState().metadata().custom("index_lifecycle"))) {
            this.policyRegistry.update(ilmMetadata);
        }
    }

    private void cancelJob() {
        if (this.scheduler.get() != null) {
            ((SchedulerEngine)this.scheduler.get()).remove("ilm");
            this.scheduledJob = null;
        }
    }

    public void triggered(SchedulerEngine.Event event) {
        if (event.getJobName().equals("ilm")) {
            logger.trace("job triggered: " + event.getJobName() + ", " + event.getScheduledTime() + ", " + event.getTriggeredTime());
            this.triggerPolicies(this.clusterService.state(), false);
        }
    }

    public boolean policyExists(String policyId) {
        return this.policyRegistry.policyExists(policyId);
    }

    void triggerPolicies(ClusterState clusterState, boolean fromClusterStateChange) {
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)clusterState.metadata().custom("index_lifecycle");
        if (currentMetadata == null) {
            return;
        }
        OperationMode currentMode = currentMetadata.getOperationMode();
        if (OperationMode.STOPPED.equals((Object)currentMode)) {
            return;
        }
        boolean safeToStop = true;
        for (IndexMetadata idxMeta : clusterState.metadata().indices().values()) {
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings());
            if (Strings.isNullOrEmpty((String)policyName)) continue;
            LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
            Step.StepKey stepKey = Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
            try {
                if (OperationMode.STOPPING == currentMode) {
                    if (stepKey != null && IGNORE_STEPS_MAINTENANCE_REQUESTED.contains(stepKey.getName())) {
                        logger.info("waiting to stop ILM because index [{}] with policy [{}] is currently in step [{}]", (Object)idxMeta.getIndex().getName(), (Object)policyName, (Object)stepKey.getName());
                        if (fromClusterStateChange) {
                            this.lifecycleRunner.runPolicyAfterStateChange(policyName, idxMeta);
                        } else {
                            this.lifecycleRunner.runPeriodicStep(policyName, clusterState.metadata(), idxMeta);
                        }
                        safeToStop = false;
                        continue;
                    }
                    logger.info("skipping policy execution of step [{}] for index [{}] with policy [{}] because ILM is stopping", (Object)(stepKey == null ? "n/a" : stepKey.getName()), (Object)idxMeta.getIndex().getName(), (Object)policyName);
                    continue;
                }
                if (fromClusterStateChange) {
                    this.lifecycleRunner.runPolicyAfterStateChange(policyName, idxMeta);
                    continue;
                }
                this.lifecycleRunner.runPeriodicStep(policyName, clusterState.metadata(), idxMeta);
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.warn((Message)new ParameterizedMessage("async action execution failed during policy trigger for index [{}] with policy [{}] in step [{}], lifecycle state: [{}]", new Object[]{idxMeta.getIndex().getName(), policyName, stepKey, lifecycleState.asMap()}), (Throwable)e);
                    continue;
                }
                logger.warn((Message)new ParameterizedMessage("async action execution failed during policy trigger for index [{}] with policy [{}] in step [{}]", new Object[]{idxMeta.getIndex().getName(), policyName, stepKey}), (Throwable)e);
            }
        }
        if (safeToStop && OperationMode.STOPPING == currentMode) {
            this.clusterService.submitStateUpdateTask("ilm_operation_mode_update[stopped]", (ClusterStateTaskConfig)OperationModeUpdateTask.ilmMode(OperationMode.STOPPED), ClusterStateTaskExecutor.unbatched());
        }
    }

    @Override
    public synchronized void close() {
        assert (this.isClusterServiceStoppedOrClosed()) : "close is called by closing the plugin, which is expected to happen after the cluster service is stopped";
        SchedulerEngine engine = (SchedulerEngine)this.scheduler.get();
        if (engine != null) {
            engine.stop();
        }
    }

    private boolean isClusterServiceStoppedOrClosed() {
        Lifecycle.State state = this.clusterService.lifecycleState();
        return state == Lifecycle.State.STOPPED || state == Lifecycle.State.CLOSED;
    }

    PolicyStepsRegistry getPolicyRegistry() {
        return this.policyRegistry;
    }

    static Set<String> indicesOnShuttingDownNodesInDangerousStep(ClusterState state, String nodeId) {
        Set shutdownNodes = PluginShutdownService.shutdownTypeNodes((ClusterState)state, (SingleNodeShutdownMetadata.Type[])new SingleNodeShutdownMetadata.Type[]{SingleNodeShutdownMetadata.Type.REMOVE, SingleNodeShutdownMetadata.Type.REPLACE});
        if (shutdownNodes.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> indicesPreventingShutdown = state.metadata().indices().stream().filter(indexToMetadata -> Strings.hasText((String)((String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(((IndexMetadata)indexToMetadata.getValue()).getSettings())))).filter(indexToMetadata -> "shrink".equals(((IndexMetadata)indexToMetadata.getValue()).getLifecycleExecutionState().action())).filter(indexToMetadata -> {
            String step = ((IndexMetadata)indexToMetadata.getValue()).getLifecycleExecutionState().step();
            return "set-single-node-allocation".equals(step) || "check-shrink-allocation".equals(step) || "shrink".equals(step) || "shrunk-shards-allocated".equals(step);
        }).filter(indexToMetadata -> {
            String nodePicked = ((IndexMetadata)indexToMetadata.getValue()).getSettings().get(IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_id");
            return nodeId.equals(nodePicked);
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        logger.trace("with nodes marked as shutdown for removal {}, indices {} are preventing shutdown", (Object)shutdownNodes, indicesPreventingShutdown);
        return indicesPreventingShutdown;
    }

    public boolean safeToShutdown(String nodeId, SingleNodeShutdownMetadata.Type shutdownType) {
        switch (shutdownType) {
            case RESTART: {
                return true;
            }
            case REPLACE: 
            case REMOVE: {
                Set<String> indices = IndexLifecycleService.indicesOnShuttingDownNodesInDangerousStep(this.clusterService.state(), nodeId);
                return indices.isEmpty();
            }
        }
        throw new IllegalArgumentException("unknown shutdown type: " + shutdownType);
    }

    public void signalShutdown(Collection<String> shutdownNodeIds) {
    }
}

