/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.logstash.action.GetPipelineAction;
import org.elasticsearch.xpack.logstash.action.GetPipelineRequest;
import org.elasticsearch.xpack.logstash.action.GetPipelineResponse;

public class RestGetPipelineAction
extends BaseRestHandler {
    public String getName() {
        return "logstash_get_pipeline";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_logstash/pipeline"), new RestHandler.Route(RestRequest.Method.GET, "/_logstash/pipeline/{id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final List<String> ids = List.of(request.paramAsStringArray("id", Strings.EMPTY_ARRAY));
        return restChannel -> client.execute((ActionType)GetPipelineAction.INSTANCE, (ActionRequest)new GetPipelineRequest(ids), (ActionListener)new RestToXContentListener<GetPipelineResponse>(restChannel){

            protected RestStatus getStatus(GetPipelineResponse response) {
                if (response.pipelines().isEmpty() && !ids.isEmpty()) {
                    return RestStatus.NOT_FOUND;
                }
                return RestStatus.OK;
            }
        });
    }
}

