/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.content;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.elasticsearch.xpack.sql.proto.content.ParseException;
import org.elasticsearch.xpack.sql.proto.content.ParserUtils;
import org.elasticsearch.xpack.sql.proto.core.CheckedFunction;

public abstract class AbstractObjectParser<Value, Context>
implements BiFunction<JsonParser, Context, Value> {
    protected String name;

    public void declareBoolean(BiConsumer<Value, Boolean> consumer, String field) {
        this.declareField(consumer, ParserUtils::booleanValue, field, ValueType.BOOLEAN);
    }

    public void declareInt(BiConsumer<Value, Integer> consumer, String field) {
        this.declareField(consumer, ParserUtils::intValue, field, ValueType.INT);
    }

    public void declareString(BiConsumer<Value, String> consumer, String field) {
        this.declareField(consumer, ParserUtils::text, field, ValueType.STRING);
    }

    public <T> void declareObject(BiConsumer<Value, T> consumer, ContextParser<Context, T> objectParser, String field) {
        this.declareField(consumer, objectParser, field, ValueType.OBJECT);
    }

    public <T> void declareObjectArray(BiConsumer<Value, List<T>> consumer, ContextParser<Context, T> objectParser, String field) {
        this.declareFieldArray(consumer, objectParser, field, ValueType.OBJECT_ARRAY);
    }

    public <T> void declareFieldArray(BiConsumer<Value, List<T>> consumer, ContextParser<Context, T> itemParser, String field, ValueType type) {
        this.declareField(consumer, (JsonParser p, Context c) -> AbstractObjectParser.parseArray(p, () -> itemParser.parse(p, c)), field, type);
    }

    public <T> void declareField(BiConsumer<Value, T> consumer, CheckedFunction<JsonParser, T, IOException> parser, String parseField, ValueType type) {
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        this.declareField(consumer, (JsonParser p, Context c) -> parser.apply(p), parseField, type);
    }

    public abstract <T> void declareField(BiConsumer<Value, T> var1, ContextParser<Context, T> var2, String var3, ValueType var4);

    @Override
    public Value apply(JsonParser parser, Context context) {
        try {
            return this.parse(parser, context);
        }
        catch (IOException e) {
            throw new ParseException(ParserUtils.location(parser), "[" + this.name + "] failed to parse object", e);
        }
    }

    abstract Value parse(JsonParser var1, Context var2) throws IOException;

    private static <T> List<T> parseArray(JsonParser parser, IOSupplier<T> supplier) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        JsonToken token = parser.currentToken();
        if (token.isScalarValue() || token == JsonToken.VALUE_NULL || token == JsonToken.START_OBJECT) {
            list.add(supplier.get());
        } else {
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                token = parser.currentToken();
                if (token.isScalarValue() || token == JsonToken.VALUE_NULL || token == JsonToken.START_OBJECT) {
                    list.add(supplier.get());
                    continue;
                }
                throw new IllegalStateException("expected value but got [" + token + "]");
            }
        }
        return list;
    }

    public static enum ValueType {
        STRING(JsonToken.VALUE_STRING, new JsonToken[0]),
        STRING_OR_NULL(JsonToken.VALUE_STRING, JsonToken.VALUE_NULL),
        FLOAT(JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        FLOAT_OR_NULL(JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING, JsonToken.VALUE_NULL),
        DOUBLE(JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        DOUBLE_OR_NULL(JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING, JsonToken.VALUE_NULL),
        LONG(JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        LONG_OR_NULL(JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING, JsonToken.VALUE_NULL),
        INT(JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        INT_OR_NULL(JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING, JsonToken.VALUE_NULL),
        BOOLEAN(JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE, JsonToken.VALUE_STRING),
        BOOLEAN_OR_NULL(JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE, JsonToken.VALUE_STRING, JsonToken.VALUE_NULL),
        STRING_ARRAY(JsonToken.START_ARRAY, JsonToken.VALUE_STRING),
        FLOAT_ARRAY(JsonToken.START_ARRAY, JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        DOUBLE_ARRAY(JsonToken.START_ARRAY, JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        LONG_ARRAY(JsonToken.START_ARRAY, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        INT_ARRAY(JsonToken.START_ARRAY, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING),
        BOOLEAN_ARRAY(JsonToken.START_ARRAY, JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE),
        OBJECT(JsonToken.START_OBJECT, new JsonToken[0]),
        OBJECT_OR_NULL(JsonToken.START_OBJECT, JsonToken.VALUE_NULL),
        OBJECT_ARRAY(JsonToken.START_OBJECT, JsonToken.START_ARRAY),
        OBJECT_ARRAY_OR_NULL(JsonToken.START_OBJECT, JsonToken.START_ARRAY, JsonToken.VALUE_NULL),
        OBJECT_OR_BOOLEAN(JsonToken.START_OBJECT, JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE),
        OBJECT_OR_STRING(JsonToken.START_OBJECT, JsonToken.VALUE_STRING),
        OBJECT_OR_LONG(JsonToken.START_OBJECT, JsonToken.VALUE_NUMBER_INT),
        OBJECT_ARRAY_BOOLEAN_OR_STRING(JsonToken.START_OBJECT, JsonToken.START_ARRAY, JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE, JsonToken.VALUE_STRING),
        OBJECT_ARRAY_OR_STRING(JsonToken.START_OBJECT, JsonToken.START_ARRAY, JsonToken.VALUE_STRING),
        OBJECT_ARRAY_STRING_OR_NUMBER(JsonToken.START_OBJECT, JsonToken.START_ARRAY, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT),
        VALUE(JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE, JsonToken.VALUE_NULL, JsonToken.VALUE_EMBEDDED_OBJECT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_STRING),
        VALUE_OBJECT_ARRAY(JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE, JsonToken.VALUE_NULL, JsonToken.VALUE_EMBEDDED_OBJECT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_STRING, JsonToken.START_OBJECT, JsonToken.START_ARRAY),
        VALUE_ARRAY(JsonToken.VALUE_FALSE, JsonToken.VALUE_TRUE, JsonToken.VALUE_NULL, JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);

        private final EnumSet<JsonToken> tokens;

        private ValueType(JsonToken first, JsonToken ... rest) {
            this.tokens = EnumSet.of(first, rest);
        }

        public EnumSet<JsonToken> supportedTokens() {
            return this.tokens;
        }
    }

    public static interface ContextParser<Context, T> {
        public T parse(JsonParser var1, Context var2) throws IOException;
    }

    private static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

