/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.search.SearchProgressActionListener;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShard;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.core.search.action.AsyncStatusResponse;
import org.elasticsearch.xpack.search.MutableSearchResponse;

final class AsyncSearchTask
extends SearchTask
implements AsyncTask {
    private final AsyncExecutionId searchId;
    private final Client client;
    private final ThreadPool threadPool;
    private final Supplier<AggregationReduceContext> aggReduceContextSupplier;
    private final Listener progressListener;
    private final Map<String, String> originHeaders;
    private boolean hasInitialized;
    private boolean hasCompleted;
    private long completionId;
    private final List<Runnable> initListeners = new ArrayList<Runnable>();
    private final Map<Long, Consumer<AsyncSearchResponse>> completionListeners = new HashMap<Long, Consumer<AsyncSearchResponse>>();
    private volatile long expirationTimeMillis;
    private final AtomicBoolean isCancelling = new AtomicBoolean(false);
    private final AtomicReference<MutableSearchResponse> searchResponse = new AtomicReference();

    AsyncSearchTask(long id, String type, String action, TaskId parentTaskId, Supplier<String> descriptionSupplier, TimeValue keepAlive, Map<String, String> originHeaders, Map<String, String> taskHeaders, AsyncExecutionId searchId, Client client, ThreadPool threadPool, Function<Supplier<Boolean>, Supplier<AggregationReduceContext>> aggReduceContextSupplierFactory) {
        super(id, type, action, () -> "async_search{" + (String)descriptionSupplier.get() + "}", parentTaskId, taskHeaders);
        this.expirationTimeMillis = this.getStartTime() + keepAlive.getMillis();
        this.originHeaders = originHeaders;
        this.searchId = searchId;
        this.client = client;
        this.threadPool = threadPool;
        this.aggReduceContextSupplier = aggReduceContextSupplierFactory.apply(() -> ((AsyncSearchTask)this).isCancelled());
        this.progressListener = new Listener();
        this.setProgressListener((SearchProgressListener)this.progressListener);
    }

    public Map<String, String> getOriginHeaders() {
        return this.originHeaders;
    }

    public AsyncExecutionId getExecutionId() {
        return this.searchId;
    }

    Listener getSearchProgressActionListener() {
        return this.progressListener;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTimeMillis = expirationTime;
    }

    public void cancelTask(TaskManager taskManager, Runnable runnable, String reason) {
        this.cancelTask(runnable, reason);
    }

    public void cancelTask(final Runnable runnable, String reason) {
        if (!this.isCancelled() && this.isCancelling.compareAndSet(false, true)) {
            CancelTasksRequest req = ((CancelTasksRequest)new CancelTasksRequest().setTargetTaskId(this.searchId.getTaskId())).setReason(reason);
            this.client.admin().cluster().cancelTasks(req, (ActionListener)new ActionListener<CancelTasksResponse>(){

                public void onResponse(CancelTasksResponse cancelTasksResponse) {
                    runnable.run();
                }

                public void onFailure(Exception exc) {
                    AsyncSearchTask.this.isCancelling.compareAndSet(true, false);
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    protected void onCancelled() {
        super.onCancelled();
        this.isCancelling.compareAndSet(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(ActionListener<AsyncSearchResponse> listener, TimeValue waitForCompletion) {
        boolean executeImmediately = false;
        long startTime = this.threadPool.relativeTimeInMillis();
        AsyncSearchTask asyncSearchTask = this;
        synchronized (asyncSearchTask) {
            if (this.hasCompleted) {
                executeImmediately = true;
            } else {
                this.addInitListener(() -> {
                    TimeValue remainingWaitForCompletion;
                    if (waitForCompletion.getMillis() > 0L) {
                        long elapsedTime = this.threadPool.relativeTimeInMillis() - startTime;
                        remainingWaitForCompletion = TimeValue.timeValueMillis((long)Math.max(0L, waitForCompletion.getMillis() - elapsedTime));
                    } else {
                        remainingWaitForCompletion = TimeValue.ZERO;
                    }
                    this.internalAddCompletionListener(listener, remainingWaitForCompletion);
                });
            }
        }
        if (executeImmediately) {
            listener.onResponse((Object)this.getResponseWithHeaders());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(Consumer<AsyncSearchResponse> listener) {
        boolean executeImmediately = false;
        AsyncSearchTask asyncSearchTask = this;
        synchronized (asyncSearchTask) {
            if (this.hasCompleted) {
                executeImmediately = true;
            } else {
                this.completionListeners.put(this.completionId++, listener);
            }
        }
        if (executeImmediately) {
            listener.accept(this.getResponseWithHeaders());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAddCompletionListener(ActionListener<AsyncSearchResponse> listener, TimeValue waitForCompletion) {
        boolean executeImmediately = false;
        AsyncSearchTask asyncSearchTask = this;
        synchronized (asyncSearchTask) {
            if (this.hasCompleted || waitForCompletion.getMillis() == 0L) {
                executeImmediately = true;
            } else {
                Scheduler.ScheduledCancellable cancellable;
                AtomicBoolean hasRun = new AtomicBoolean(false);
                long id = this.completionId++;
                try {
                    cancellable = this.threadPool.schedule(() -> {
                        if (hasRun.compareAndSet(false, true)) {
                            this.removeCompletionListener(id);
                            listener.onResponse((Object)this.getResponseWithHeaders());
                        }
                    }, waitForCompletion, "generic");
                }
                catch (Exception exc) {
                    listener.onFailure(exc);
                    return;
                }
                this.completionListeners.put(id, arg_0 -> AsyncSearchTask.lambda$internalAddCompletionListener$3(hasRun, (Scheduler.Cancellable)cancellable, listener, arg_0));
            }
        }
        if (executeImmediately) {
            listener.onResponse((Object)this.getResponseWithHeaders());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCompletionListener(long id) {
        AsyncSearchTask asyncSearchTask = this;
        synchronized (asyncSearchTask) {
            if (!this.hasCompleted) {
                this.completionListeners.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInitListener(Runnable listener) {
        boolean executeImmediately = false;
        AsyncSearchTask asyncSearchTask = this;
        synchronized (asyncSearchTask) {
            if (this.hasInitialized) {
                executeImmediately = true;
            } else {
                this.initListeners.add(listener);
            }
        }
        if (executeImmediately) {
            listener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInitListeners() {
        AsyncSearchTask asyncSearchTask = this;
        synchronized (asyncSearchTask) {
            if (this.hasInitialized) {
                return;
            }
            this.hasInitialized = true;
        }
        for (Runnable listener : this.initListeners) {
            listener.run();
        }
        this.initListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCompletionListeners() {
        HashMap<Long, Consumer<AsyncSearchResponse>> completionsListenersCopy;
        AsyncSearchTask asyncSearchTask = this;
        synchronized (asyncSearchTask) {
            if (this.hasCompleted) {
                return;
            }
            this.hasCompleted = true;
            completionsListenersCopy = new HashMap<Long, Consumer<AsyncSearchResponse>>(this.completionListeners);
            this.completionListeners.clear();
        }
        AsyncSearchResponse finalResponse = this.getResponse();
        for (Consumer consumer : completionsListenersCopy.values()) {
            consumer.accept(finalResponse);
        }
    }

    private AsyncSearchResponse getResponse() {
        return this.getResponse(false);
    }

    private AsyncSearchResponse getResponseWithHeaders() {
        return this.getResponse(true);
    }

    private AsyncSearchResponse getResponse(boolean restoreResponseHeaders) {
        AsyncSearchResponse asyncSearchResponse;
        MutableSearchResponse mutableSearchResponse = this.searchResponse.get();
        assert (mutableSearchResponse != null);
        this.checkCancellation();
        try {
            asyncSearchResponse = mutableSearchResponse.toAsyncSearchResponse(this, this.expirationTimeMillis, restoreResponseHeaders);
        }
        catch (Exception e) {
            ElasticsearchStatusException exception = new ElasticsearchStatusException("Async search: error while reducing partial results", ExceptionsHelper.status((Throwable)e), (Throwable)e, new Object[0]);
            asyncSearchResponse = mutableSearchResponse.toAsyncSearchResponse(this, this.expirationTimeMillis, (ElasticsearchException)exception);
        }
        return asyncSearchResponse;
    }

    private synchronized void checkCancellation() {
        long now = System.currentTimeMillis();
        if (!this.hasCompleted && this.expirationTimeMillis < now) {
            this.cancelTask(() -> {}, "async search has expired");
        }
    }

    public static AsyncStatusResponse getStatusResponse(AsyncSearchTask asyncTask) {
        MutableSearchResponse mutableSearchResponse = asyncTask.searchResponse.get();
        assert (mutableSearchResponse != null);
        return mutableSearchResponse.toStatusResponse(asyncTask.searchId.getEncoded(), asyncTask.getStartTime(), asyncTask.expirationTimeMillis);
    }

    private static /* synthetic */ void lambda$internalAddCompletionListener$3(AtomicBoolean hasRun, Scheduler.Cancellable cancellable, ActionListener listener, AsyncSearchResponse resp) {
        if (hasRun.compareAndSet(false, true)) {
            cancellable.cancel();
            listener.onResponse((Object)resp);
        }
    }

    class Listener
    extends SearchProgressActionListener {
        Listener() {
        }

        protected void onQueryResult(int shardIndex) {
            AsyncSearchTask.this.checkCancellation();
        }

        protected void onFetchResult(int shardIndex) {
            AsyncSearchTask.this.checkCancellation();
        }

        protected void onQueryFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
            AsyncSearchTask.this.checkCancellation();
            AsyncSearchTask.this.searchResponse.get().addQueryFailure(shardIndex, new ShardSearchFailure(exc, (SearchShardTarget)(shardTarget.getNodeId() != null ? shardTarget : null)));
        }

        protected void onFetchFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
            AsyncSearchTask.this.checkCancellation();
        }

        protected void onListShards(List<SearchShard> shards, List<SearchShard> skipped, SearchResponse.Clusters clusters, boolean fetchPhase) {
            AsyncSearchTask.this.checkCancellation();
            AsyncSearchTask.this.searchResponse.compareAndSet(null, new MutableSearchResponse(shards.size() + skipped.size(), skipped.size(), clusters, AsyncSearchTask.this.threadPool.getThreadContext()));
            AsyncSearchTask.this.executeInitListeners();
        }

        public void onPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggregations, int reducePhase) {
            AsyncSearchTask.this.checkCancellation();
            Supplier<InternalAggregations> reducedAggs = aggregations == null ? () -> null : () -> InternalAggregations.topLevelReduce(Collections.singletonList(aggregations), (AggregationReduceContext)AsyncSearchTask.this.aggReduceContextSupplier.get());
            AsyncSearchTask.this.searchResponse.get().updatePartialResponse(shards.size(), totalHits, reducedAggs, reducePhase);
        }

        public void onFinalReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggregations, int reducePhase) {
            AsyncSearchTask.this.checkCancellation();
            AsyncSearchTask.this.searchResponse.get().updatePartialResponse(shards.size(), totalHits, () -> aggregations, reducePhase);
        }

        public void onResponse(SearchResponse response) {
            AsyncSearchTask.this.searchResponse.get().updateFinalResponse(response);
            AsyncSearchTask.this.executeCompletionListeners();
        }

        public void onFailure(Exception exc) {
            AsyncSearchTask.this.searchResponse.compareAndSet(null, new MutableSearchResponse(-1, -1, null, AsyncSearchTask.this.threadPool.getThreadContext()));
            AsyncSearchTask.this.searchResponse.get().updateWithFailure((ElasticsearchException)new ElasticsearchStatusException("error while executing search", ExceptionsHelper.status((Throwable)exc), (Throwable)exc, new Object[0]));
            AsyncSearchTask.this.executeInitListeners();
            AsyncSearchTask.this.executeCompletionListeners();
        }
    }
}

