/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.IndexDeprecationChecks;
import org.elasticsearch.xpack.deprecation.NodeDeprecationChecks;

public class DeprecationChecks {
    public static final Setting<List<String>> SKIP_DEPRECATIONS_SETTING = Setting.listSetting((String)"deprecation.skip_deprecated_settings", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static List<Function<ClusterState, DeprecationIssue>> CLUSTER_SETTINGS_CHECKS = Collections.emptyList();
    static final List<NodeDeprecationCheck<Settings, PluginsAndModules, ClusterState, XPackLicenseState, DeprecationIssue>> NODE_SETTINGS_CHECKS = List.of(NodeDeprecationChecks::checkSharedDataPathSetting, NodeDeprecationChecks::checkReservedPrefixedRealmNames, NodeDeprecationChecks::checkSingleDataNodeWatermarkSetting, NodeDeprecationChecks::checkExporterUseIngestPipelineSettings, NodeDeprecationChecks::checkExporterPipelineMasterTimeoutSetting, NodeDeprecationChecks::checkExporterCreateLegacyTemplateSetting, NodeDeprecationChecks::checkMonitoringSettingHistoryDuration, NodeDeprecationChecks::checkMonitoringSettingHistoryDuration, NodeDeprecationChecks::checkMonitoringSettingCollectIndexRecovery, NodeDeprecationChecks::checkMonitoringSettingCollectIndices, NodeDeprecationChecks::checkMonitoringSettingCollectCcrTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectEnrichStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectIndexRecoveryStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectIndexStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectMlJobStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectNodeStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectClusterStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersHost, NodeDeprecationChecks::checkMonitoringSettingExportersBulkTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersConnectionTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersConnectionReadTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersAuthUsername, NodeDeprecationChecks::checkMonitoringSettingExportersAuthPass, NodeDeprecationChecks::checkMonitoringSettingExportersSSL, NodeDeprecationChecks::checkMonitoringSettingExportersProxyBase, NodeDeprecationChecks::checkMonitoringSettingExportersSniffEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersHeaders, NodeDeprecationChecks::checkMonitoringSettingExportersTemplateTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersMasterTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersType, NodeDeprecationChecks::checkMonitoringSettingExportersAlertsEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersAlertsBlacklist, NodeDeprecationChecks::checkMonitoringSettingExportersIndexNameTimeFormat, NodeDeprecationChecks::checkMonitoringSettingDecommissionAlerts, NodeDeprecationChecks::checkMonitoringSettingEsCollectionEnabled, NodeDeprecationChecks::checkMonitoringSettingCollectionEnabled, NodeDeprecationChecks::checkMonitoringSettingCollectionInterval, NodeDeprecationChecks::checkScriptContextCache, NodeDeprecationChecks::checkScriptContextCompilationsRateLimitSetting, NodeDeprecationChecks::checkScriptContextCacheSizeSetting, NodeDeprecationChecks::checkScriptContextCacheExpirationSetting, NodeDeprecationChecks::checkEnforceDefaultTierPreferenceSetting, NodeDeprecationChecks::checkLifecyleStepMasterTimeoutSetting, NodeDeprecationChecks::checkEqlEnabledSetting, NodeDeprecationChecks::checkNodeAttrData);
    static List<Function<IndexMetadata, DeprecationIssue>> INDEX_SETTINGS_CHECKS = List.of(IndexDeprecationChecks::oldIndicesCheck, IndexDeprecationChecks::translogRetentionSettingCheck, IndexDeprecationChecks::checkIndexDataPath, IndexDeprecationChecks::storeTypeSettingCheck, IndexDeprecationChecks::frozenIndexSettingCheck);

    private DeprecationChecks() {
    }

    static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface NodeDeprecationCheck<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

