/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.persistence;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;

public class ResultsPersisterService {
    public static final Set<RestStatus> IRRECOVERABLE_REST_STATUSES = Collections.unmodifiableSet(new HashSet<RestStatus>(Arrays.asList(RestStatus.GONE, RestStatus.NOT_IMPLEMENTED, RestStatus.NOT_FOUND, RestStatus.BAD_REQUEST, RestStatus.UNAUTHORIZED, RestStatus.FORBIDDEN, RestStatus.METHOD_NOT_ALLOWED, RestStatus.NOT_ACCEPTABLE)));
    private static final Logger LOGGER = LogManager.getLogger(ResultsPersisterService.class);
    public static final Setting<Integer> PERSIST_RESULTS_MAX_RETRIES = Setting.intSetting((String)"xpack.ml.persist_results_max_retries", (int)20, (int)0, (int)50, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    private static final int MAX_RETRY_SLEEP_MILLIS = (int)Duration.ofMinutes(15L).toMillis();
    private static final int MIN_RETRY_SLEEP_MILLIS = 50;
    private static final int MAX_RETRY_EXPONENT = 24;
    private final ThreadPool threadPool;
    private final OriginSettingClient client;
    private final Map<Object, RetryableAction<?>> onGoingRetryableSearchActions = ConcurrentCollections.newConcurrentMap();
    private final Map<Object, RetryableAction<?>> onGoingRetryableBulkActions = ConcurrentCollections.newConcurrentMap();
    private volatile int maxFailureRetries;
    private volatile boolean isShutdown = false;
    private volatile boolean isResetMode = false;

    public ResultsPersisterService(ThreadPool threadPool, OriginSettingClient client, ClusterService clusterService, Settings settings) {
        this.threadPool = threadPool;
        this.client = client;
        this.maxFailureRetries = (Integer)PERSIST_RESULTS_MAX_RETRIES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(PERSIST_RESULTS_MAX_RETRIES, this::setMaxFailureRetries);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                ResultsPersisterService.this.shutdown();
            }
        });
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                this.isResetMode = MlMetadata.getMlMetadata((ClusterState)event.state()).isResetMode();
                if (this.isResetMode) {
                    CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("Reset mode has been enabled");
                    for (RetryableAction<?> action : this.onGoingRetryableBulkActions.values()) {
                        action.cancel((Exception)exception);
                    }
                    this.onGoingRetryableBulkActions.clear();
                }
            }
        });
    }

    void shutdown() {
        this.isShutdown = true;
        if (this.onGoingRetryableSearchActions.isEmpty() && this.onGoingRetryableBulkActions.isEmpty()) {
            return;
        }
        CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("Node is shutting down");
        for (RetryableAction<?> action : this.onGoingRetryableSearchActions.values()) {
            action.cancel((Exception)exception);
        }
        for (RetryableAction<?> action : this.onGoingRetryableBulkActions.values()) {
            action.cancel((Exception)exception);
        }
        this.onGoingRetryableSearchActions.clear();
        this.onGoingRetryableBulkActions.clear();
    }

    void setMaxFailureRetries(int value) {
        this.maxFailureRetries = value;
    }

    public BulkResponse indexWithRetry(String jobId, String indexName, ToXContent object, ToXContent.Params params, WriteRequest.RefreshPolicy refreshPolicy, String id, boolean requireAlias, Supplier<Boolean> shouldRetry, Consumer<String> retryMsgHandler) throws IOException {
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(refreshPolicy);
        try (XContentBuilder content = object.toXContent(XContentFactory.jsonBuilder(), params);){
            bulkRequest.add(new IndexRequest(indexName).id(id).source(content).setRequireAlias(requireAlias));
        }
        return this.bulkIndexWithRetry(bulkRequest, jobId, shouldRetry, retryMsgHandler);
    }

    public BulkResponse bulkIndexWithRetry(BulkRequest bulkRequest, String jobId, Supplier<Boolean> shouldRetry, Consumer<String> retryMsgHandler) {
        return this.bulkIndexWithRetry(bulkRequest, jobId, shouldRetry, retryMsgHandler, (arg_0, arg_1) -> ((OriginSettingClient)this.client).bulk(arg_0, arg_1));
    }

    public BulkResponse bulkIndexWithHeadersWithRetry(Map<String, String> headers, BulkRequest bulkRequest, String jobId, Supplier<Boolean> shouldRetry, Consumer<String> retryMsgHandler) {
        return this.bulkIndexWithRetry(bulkRequest, jobId, shouldRetry, retryMsgHandler, (providedBulkRequest, listener) -> ClientHelper.executeWithHeadersAsync((Map)headers, (String)"ml", (Client)this.client, (ActionType)BulkAction.INSTANCE, (ActionRequest)providedBulkRequest, (ActionListener)listener));
    }

    private BulkResponse bulkIndexWithRetry(BulkRequest bulkRequest, String jobId, Supplier<Boolean> shouldRetry, Consumer<String> retryMsgHandler, BiConsumer<BulkRequest, ActionListener<BulkResponse>> actionExecutor) {
        if (this.isShutdown || this.isResetMode) {
            throw new ElasticsearchException("Bulk indexing has failed as {}", new Object[]{this.isShutdown ? "node is shutting down." : "machine learning feature is being reset."});
        }
        PlainActionFuture getResponse = PlainActionFuture.newFuture();
        Object key = new Object();
        ActionListener removeListener = ActionListener.runBefore((ActionListener)getResponse, () -> this.onGoingRetryableBulkActions.remove(key));
        BulkRetryableAction bulkRetryableAction = new BulkRetryableAction(jobId, new BulkRequestRewriter(bulkRequest), () -> !this.isShutdown && !this.isResetMode && (Boolean)shouldRetry.get() != false, retryMsgHandler, actionExecutor, (ActionListener<BulkResponse>)removeListener);
        this.onGoingRetryableBulkActions.put(key, bulkRetryableAction);
        bulkRetryableAction.run();
        if (this.isShutdown || this.isResetMode) {
            bulkRetryableAction.cancel((Exception)new CancellableThreads.ExecutionCancelledException(this.isShutdown ? "Node is shutting down" : "Machine learning feature is being reset"));
        }
        return (BulkResponse)getResponse.actionGet();
    }

    public SearchResponse searchWithRetry(SearchRequest searchRequest, String jobId, Supplier<Boolean> shouldRetry, Consumer<String> retryMsgHandler) {
        PlainActionFuture getResponse = PlainActionFuture.newFuture();
        Object key = new Object();
        ActionListener removeListener = ActionListener.runBefore((ActionListener)getResponse, () -> this.onGoingRetryableSearchActions.remove(key));
        SearchRetryableAction mlRetryableAction = new SearchRetryableAction(jobId, searchRequest, this.client, () -> !this.isShutdown && (Boolean)shouldRetry.get() != false, retryMsgHandler, (ActionListener<SearchResponse>)removeListener);
        this.onGoingRetryableSearchActions.put(key, mlRetryableAction);
        mlRetryableAction.run();
        if (this.isShutdown) {
            mlRetryableAction.cancel((Exception)new CancellableThreads.ExecutionCancelledException("Node is shutting down"));
        }
        return (SearchResponse)getResponse.actionGet();
    }

    private static boolean isIrrecoverable(Exception ex) {
        Throwable t = ExceptionsHelper.unwrapCause((Throwable)ex);
        return IRRECOVERABLE_REST_STATUSES.contains(ExceptionsHelper.status((Throwable)t));
    }

    private static BulkRequest buildNewRequestFromFailures(BulkRequest bulkRequest, BulkResponse bulkResponse) {
        BulkRequest bulkRequestOfFailures = new BulkRequest();
        Set failedDocIds = Arrays.stream(bulkResponse.getItems()).filter(BulkItemResponse::isFailed).map(BulkItemResponse::getId).collect(Collectors.toSet());
        bulkRequest.requests().forEach(docWriteRequest -> {
            if (failedDocIds.contains(docWriteRequest.id())) {
                bulkRequestOfFailures.add(docWriteRequest);
            }
        });
        return bulkRequestOfFailures;
    }

    private class BulkRetryableAction
    extends MlRetryableAction<BulkRequest, BulkResponse> {
        private final BulkRequestRewriter bulkRequestRewriter;

        BulkRetryableAction(String jobId, BulkRequestRewriter bulkRequestRewriter, Supplier<Boolean> shouldRetry, Consumer<String> msgHandler, BiConsumer<BulkRequest, ActionListener<BulkResponse>> actionExecutor, ActionListener<BulkResponse> listener) {
            super(jobId, shouldRetry, msgHandler, (request, retryableListener) -> actionExecutor.accept((BulkRequest)request, (ActionListener<BulkResponse>)ActionListener.wrap(bulkResponse -> {
                if (!bulkResponse.hasFailures()) {
                    retryableListener.onResponse(bulkResponse);
                    return;
                }
                for (BulkItemResponse itemResponse : bulkResponse.getItems()) {
                    if (!itemResponse.isFailed() || !ResultsPersisterService.isIrrecoverable(itemResponse.getFailure().getCause())) continue;
                    Throwable unwrappedParticular = ExceptionsHelper.unwrapCause((Throwable)itemResponse.getFailure().getCause());
                    LOGGER.warn((Message)new ParameterizedMessage("[{}] experienced failure that cannot be automatically retried. Bulk failure message [{}]", (Object)jobId, (Object)bulkResponse.buildFailureMessage()), unwrappedParticular);
                    retryableListener.onFailure((Exception)((Object)new IrrecoverableException("{} experienced failure that cannot be automatically retried. See logs for bulk failures", ExceptionsHelper.status((Throwable)unwrappedParticular), unwrappedParticular, jobId)));
                    return;
                }
                bulkRequestRewriter.rewriteRequest((BulkResponse)bulkResponse);
                retryableListener.onFailure((Exception)new RecoverableException());
            }, arg_0 -> ((ActionListener)retryableListener).onFailure(arg_0))), listener);
            this.bulkRequestRewriter = bulkRequestRewriter;
        }

        @Override
        public BulkRequest buildRequest() {
            return this.bulkRequestRewriter.getBulkRequest();
        }

        @Override
        public String getName() {
            return "index";
        }
    }

    private static class BulkRequestRewriter {
        private volatile BulkRequest bulkRequest;

        BulkRequestRewriter(BulkRequest initialRequest) {
            this.bulkRequest = initialRequest;
        }

        void rewriteRequest(BulkResponse bulkResponse) {
            if (!bulkResponse.hasFailures()) {
                return;
            }
            this.bulkRequest = ResultsPersisterService.buildNewRequestFromFailures(this.bulkRequest, bulkResponse);
        }

        BulkRequest getBulkRequest() {
            return this.bulkRequest;
        }
    }

    private class SearchRetryableAction
    extends MlRetryableAction<SearchRequest, SearchResponse> {
        private final SearchRequest searchRequest;

        SearchRetryableAction(String jobId, SearchRequest searchRequest, OriginSettingClient client, Supplier<Boolean> shouldRetry, Consumer<String> msgHandler, ActionListener<SearchResponse> listener) {
            super(jobId, shouldRetry, msgHandler, (request, retryableListener) -> client.search(request, ActionListener.wrap(searchResponse -> {
                if (RestStatus.OK.equals((Object)searchResponse.status())) {
                    retryableListener.onResponse(searchResponse);
                    return;
                }
                retryableListener.onFailure((Exception)((Object)new ElasticsearchStatusException("search failed with status {}", searchResponse.status(), new Object[]{searchResponse.status()})));
            }, arg_0 -> ((ActionListener)retryableListener).onFailure(arg_0))), listener);
            this.searchRequest = searchRequest;
        }

        @Override
        public SearchRequest buildRequest() {
            return this.searchRequest;
        }

        @Override
        public String getName() {
            return "search";
        }
    }

    private abstract class MlRetryableAction<Request, Response>
    extends RetryableAction<Response> {
        final String jobId;
        final Supplier<Boolean> shouldRetry;
        final Consumer<String> msgHandler;
        final BiConsumer<Request, ActionListener<Response>> action;
        volatile int currentAttempt;
        volatile long currentMax;

        MlRetryableAction(String jobId, Supplier<Boolean> shouldRetry, Consumer<String> msgHandler, BiConsumer<Request, ActionListener<Response>> action, ActionListener<Response> listener) {
            super(LOGGER, ResultsPersisterService.this.threadPool, TimeValue.timeValueMillis((long)50L), TimeValue.MAX_VALUE, listener, "ml_utility");
            this.currentAttempt = 0;
            this.currentMax = 50L;
            this.jobId = jobId;
            this.shouldRetry = shouldRetry;
            this.msgHandler = msgHandler;
            this.action = action;
        }

        public abstract Request buildRequest();

        public abstract String getName();

        public void tryAction(ActionListener<Response> listener) {
            ++this.currentAttempt;
            this.action.accept(this.buildRequest(), listener);
        }

        public boolean shouldRetry(Exception e) {
            if (ResultsPersisterService.isIrrecoverable(e)) {
                LOGGER.warn((Message)new ParameterizedMessage("[{}] experienced failure that cannot be automatically retried", (Object)this.jobId), (Throwable)e);
                return false;
            }
            if (!this.shouldRetry.get().booleanValue()) {
                LOGGER.info(() -> new ParameterizedMessage("[{}] should not retry {} after [{}] attempts", new Object[]{this.jobId, this.getName(), this.currentAttempt}), (Throwable)e);
                return false;
            }
            if (this.currentAttempt > ResultsPersisterService.this.maxFailureRetries) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to {} after [{}] attempts.", new Object[]{this.jobId, this.getName(), this.currentAttempt}), (Throwable)e);
                return false;
            }
            return true;
        }

        protected long calculateDelayBound(long previousDelayBound) {
            int uncappedBackoff = ((1 << Math.min(this.currentAttempt, 24)) - 1) * 50;
            this.currentMax = Math.min(uncappedBackoff, MAX_RETRY_SLEEP_MILLIS);
            String msg = new ParameterizedMessage("failed to {} after [{}] attempts. Will attempt again.", (Object)this.getName(), (Object)this.currentAttempt).getFormattedMessage();
            LOGGER.warn(() -> new ParameterizedMessage("[{}] {}", (Object)this.jobId, (Object)msg));
            this.msgHandler.accept(msg);
            return this.currentMax;
        }

        public void cancel(Exception e) {
            super.cancel(e);
            LOGGER.debug(() -> new ParameterizedMessage("[{}] retrying cancelled for action [{}]", (Object)this.jobId, (Object)this.getName()), (Throwable)e);
        }
    }

    static class IrrecoverableException
    extends ElasticsearchStatusException {
        IrrecoverableException(String msg, RestStatus status, Throwable cause, Object ... args) {
            super(msg, status, cause, args);
        }
    }

    static class RecoverableException
    extends Exception {
        RecoverableException() {
        }
    }
}

