/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.Locale;
import java.util.OptionalLong;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.MachineLearning;

public final class NativeMemoryCalculator {
    private static final long STATIC_JVM_UPPER_THRESHOLD = ByteSizeValue.ofGb((long)2L).getBytes();
    public static final long MINIMUM_AUTOMATIC_NODE_SIZE = ByteSizeValue.ofGb((long)1L).getBytes();
    private static final long OS_OVERHEAD = ByteSizeValue.ofMb((long)200L).getBytes();

    private NativeMemoryCalculator() {
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, Settings settings) {
        if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) {
            return OptionalLong.empty();
        }
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), (int)((Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings)), (boolean)((Boolean)MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT.get(settings)));
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, ClusterSettings settings) {
        if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) {
            return OptionalLong.empty();
        }
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), (int)((Integer)settings.get(MachineLearning.MAX_MACHINE_MEMORY_PERCENT)), (boolean)((Boolean)settings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT)));
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, int maxMemoryPercent, boolean useAutoPercent) {
        if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) {
            return OptionalLong.empty();
        }
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), maxMemoryPercent, useAutoPercent);
    }

    private static OptionalLong allowedBytesForMl(String nodeBytes, String jvmBytes, int maxMemoryPercent, boolean useAuto) {
        long machineMemory;
        assert (nodeBytes != null) : "This private method should only be called for ML nodes, and all ML nodes should have the ml.machine_memory node attribute";
        if (nodeBytes == null) {
            return OptionalLong.empty();
        }
        try {
            machineMemory = Long.parseLong(nodeBytes);
        }
        catch (NumberFormatException e) {
            assert (e == null) : "ml.machine_memory should parse because we set it internally: invalid value was " + nodeBytes;
            return OptionalLong.empty();
        }
        Long jvmMemory = null;
        try {
            if (!Strings.isNullOrEmpty((String)jvmBytes)) {
                jvmMemory = Long.parseLong(jvmBytes);
            }
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(NativeMemoryCalculator.allowedBytesForMl(machineMemory, jvmMemory, maxMemoryPercent, useAuto));
    }

    public static long calculateApproxNecessaryNodeSize(long nativeMachineMemory, Long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (nativeMachineMemory == 0L) {
            return 0L;
        }
        if (useAuto) {
            if ((double)((jvmSize = Long.valueOf(jvmSize == null ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNativeMemorySize(nativeMachineMemory) : jvmSize)) + OS_OVERHEAD) / (double)nativeMachineMemory > 0.1) {
                return Math.max(nativeMachineMemory + jvmSize + OS_OVERHEAD, MINIMUM_AUTOMATIC_NODE_SIZE);
            }
            return Math.round((double)nativeMachineMemory / 0.9);
        }
        return (long)(100.0 / (double)maxMemoryPercent * (double)nativeMachineMemory);
    }

    public static double modelMemoryPercent(long machineMemory, Long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (useAuto) {
            if (machineMemory - (jvmSize = Long.valueOf(jvmSize == null ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(machineMemory) : jvmSize)) < OS_OVERHEAD || machineMemory == 0L) {
                assert (false) : String.format(Locale.ROOT, "machine memory [%d] minus jvm [%d] is less than overhead [%d]", machineMemory, jvmSize, OS_OVERHEAD);
                return maxMemoryPercent;
            }
            return Math.min(90.0, (double)(machineMemory - jvmSize - OS_OVERHEAD) / (double)machineMemory * 100.0);
        }
        return maxMemoryPercent;
    }

    static long allowedBytesForMl(long machineMemory, Long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (machineMemory <= 0L) {
            return 0L;
        }
        if (useAuto && jvmSize != null) {
            if (machineMemory - jvmSize <= OS_OVERHEAD) {
                return machineMemory / 100L;
            }
            double memoryProportion = Math.min(0.9, (double)(machineMemory - jvmSize - OS_OVERHEAD) / (double)machineMemory);
            return Math.round((double)machineMemory * memoryProportion);
        }
        return (long)((double)machineMemory * ((double)maxMemoryPercent / 100.0));
    }

    public static long allowedBytesForMl(long machineMemory, int maxMemoryPercent, boolean useAuto) {
        return NativeMemoryCalculator.allowedBytesForMl(machineMemory, useAuto ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(machineMemory) : machineMemory / 2L, maxMemoryPercent, useAuto);
    }

    public static long dynamicallyCalculateJvmSizeFromNodeSize(long nodeSize) {
        if (nodeSize < ByteSizeValue.ofMb((long)1280L).getBytes()) {
            return (long)((double)nodeSize * 0.4);
        }
        if (nodeSize < ByteSizeValue.ofGb((long)8L).getBytes()) {
            return (long)((double)nodeSize * 0.25);
        }
        return STATIC_JVM_UPPER_THRESHOLD;
    }

    public static long dynamicallyCalculateJvmSizeFromNativeMemorySize(long nativeMachineMemory) {
        long nativeAndOverhead = nativeMachineMemory + OS_OVERHEAD;
        if ((double)nativeAndOverhead < (double)ByteSizeValue.ofGb((long)2L).getBytes() * 0.6) {
            return Math.round((double)nativeAndOverhead / 0.6 * 0.4);
        }
        if ((double)nativeAndOverhead < (double)ByteSizeValue.ofGb((long)8L).getBytes() * 0.75) {
            return Math.round((double)nativeAndOverhead / 0.75 * 0.25);
        }
        return STATIC_JVM_UPPER_THRESHOLD;
    }

    public static ByteSizeValue calculateMaxModelMemoryLimitToFit(ClusterSettings clusterSettings, DiscoveryNodes nodes) {
        long maxMlMemory = 0L;
        int numMlNodes = 0;
        for (DiscoveryNode node : nodes) {
            OptionalLong limit = NativeMemoryCalculator.allowedBytesForMl(node, clusterSettings);
            if (limit.isEmpty()) continue;
            maxMlMemory = Math.max(maxMlMemory, limit.getAsLong());
            ++numMlNodes;
        }
        long maxMlNodeSize = ((ByteSizeValue)clusterSettings.get(MachineLearning.MAX_ML_NODE_SIZE)).getBytes();
        int maxLazyNodes = (Integer)clusterSettings.get(MachineLearning.MAX_LAZY_ML_NODES);
        if (maxMlNodeSize > 0L && numMlNodes < maxLazyNodes) {
            maxMlMemory = Math.max(maxMlMemory, NativeMemoryCalculator.allowedBytesForMl(maxMlNodeSize, (int)((Integer)clusterSettings.get(MachineLearning.MAX_MACHINE_MEMORY_PERCENT)), (boolean)((Boolean)clusterSettings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT))));
        }
        if (maxMlMemory == 0L) {
            return null;
        }
        maxMlMemory -= Math.max(Job.PROCESS_MEMORY_OVERHEAD.getBytes(), DataFrameAnalyticsConfig.PROCESS_MEMORY_OVERHEAD.getBytes());
        return ByteSizeValue.ofMb((long)ByteSizeUnit.BYTES.toMB(Math.max(0L, maxMlMemory -= MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes())));
    }

    public static ByteSizeValue calculateTotalMlMemory(ClusterSettings clusterSettings, DiscoveryNodes nodes) {
        long totalMlMemory = 0L;
        for (DiscoveryNode node : nodes) {
            OptionalLong limit = NativeMemoryCalculator.allowedBytesForMl(node, clusterSettings);
            if (limit.isEmpty()) continue;
            totalMlMemory += limit.getAsLong();
        }
        return ByteSizeValue.ofMb((long)ByteSizeUnit.BYTES.toMB(totalMlMemory));
    }

    public static ByteSizeValue getMaxModelMemoryLimit(ClusterService clusterService) {
        DiscoveryNodes nodes;
        ByteSizeValue modelMemoryLimitToFit;
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)clusterSettings.get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L) {
            return maxModelMemoryLimit;
        }
        Boolean autoMemory = (Boolean)clusterSettings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT);
        if (autoMemory.booleanValue() && (modelMemoryLimitToFit = NativeMemoryCalculator.calculateMaxModelMemoryLimitToFit(clusterSettings, nodes = clusterService.state().getNodes())) != null) {
            return modelMemoryLimitToFit;
        }
        return ByteSizeValue.ZERO;
    }
}

