/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationStatus;

public class RestStartTrainedModelDeploymentAction
extends BaseRestHandler {
    public String getName() {
        return "xpack_ml_start_trained_models_deployment_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_ml/trained_models/{" + StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName() + "}/deployment/_start"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        StartTrainedModelDeploymentAction.Request request;
        String modelId = restRequest.param(StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            request = StartTrainedModelDeploymentAction.Request.parseRequest((String)modelId, (XContentParser)restRequest.contentOrSourceParamParser());
        } else {
            request = new StartTrainedModelDeploymentAction.Request(modelId);
            if (restRequest.hasParam(StartTrainedModelDeploymentAction.Request.TIMEOUT.getPreferredName())) {
                TimeValue openTimeout = restRequest.paramAsTime(StartTrainedModelDeploymentAction.Request.TIMEOUT.getPreferredName(), StartTrainedModelDeploymentAction.DEFAULT_TIMEOUT);
                request.setTimeout(openTimeout);
            }
            request.setWaitForState(AllocationStatus.State.fromString((String)restRequest.param(StartTrainedModelDeploymentAction.Request.WAIT_FOR.getPreferredName(), AllocationStatus.State.STARTED.toString())));
            request.setInferenceThreads(restRequest.paramAsInt(StartTrainedModelDeploymentAction.Request.INFERENCE_THREADS.getPreferredName(), request.getInferenceThreads()));
            request.setModelThreads(restRequest.paramAsInt(StartTrainedModelDeploymentAction.Request.MODEL_THREADS.getPreferredName(), request.getModelThreads()));
            request.setQueueCapacity(restRequest.paramAsInt(StartTrainedModelDeploymentAction.Request.QUEUE_CAPACITY.getPreferredName(), request.getQueueCapacity()));
        }
        return channel -> client.execute((ActionType)StartTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

