/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.cat;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.xpack.core.common.table.TableColumnAttributeBuilder;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.ml.rest.RestCompatibilityChecker;

public class RestCatJobsAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/anomaly_detectors/{" + Job.ID + "}"), new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/anomaly_detectors"));
    }

    public String getName() {
        return "cat_ml_get_jobs_action";
    }

    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest restRequest, NodeClient client) {
        String jobId = restRequest.param(Job.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)jobId)) {
            jobId = "_all";
        }
        GetJobsStatsAction.Request request = new GetJobsStatsAction.Request(jobId);
        RestCompatibilityChecker.checkAndSetDeprecatedParam("allow_no_jobs", "allow_no_match", RestApiVersion.V_7, restRequest, (r, s) -> r.paramAsBoolean(s, request.allowNoMatch()), arg_0 -> ((GetJobsStatsAction.Request)request).setAllowNoMatch(arg_0));
        return channel -> client.execute((ActionType)GetJobsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestResponseListener<GetJobsStatsAction.Response>(channel){

            public RestResponse buildResponse(GetJobsStatsAction.Response getJobStatsResponse) throws Exception {
                return RestTable.buildResponse((Table)RestCatJobsAction.this.buildTable(restRequest, getJobStatsResponse), (RestChannel)this.channel);
            }
        });
    }

    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/ml/anomaly_detectors\n");
        sb.append("/_cat/ml/anomaly_detectors/{job_id}\n");
    }

    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"id", TableColumnAttributeBuilder.builder((String)"the job_id").build());
        table.addCell((Object)"state", TableColumnAttributeBuilder.builder((String)"the job state").setAliases(new String[]{"s"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build());
        table.addCell((Object)"opened_time", TableColumnAttributeBuilder.builder((String)"the amount of time the job has been opened", (boolean)false).setAliases(new String[]{"ot"}).build());
        table.addCell((Object)"assignment_explanation", TableColumnAttributeBuilder.builder((String)"why the job is or is not assigned to a node", (boolean)false).setAliases(new String[]{"ae"}).build());
        table.addCell((Object)"data.processed_records", TableColumnAttributeBuilder.builder((String)"number of processed records").setAliases(new String[]{"dpr", "dataProcessedRecords"}).build());
        table.addCell((Object)"data.processed_fields", TableColumnAttributeBuilder.builder((String)"number of processed fields", (boolean)false).setAliases(new String[]{"dpf", "dataProcessedFields"}).build());
        table.addCell((Object)"data.input_bytes", TableColumnAttributeBuilder.builder((String)"total input bytes", (boolean)false).setAliases(new String[]{"dib", "dataInputBytes"}).build());
        table.addCell((Object)"data.input_records", TableColumnAttributeBuilder.builder((String)"total record count", (boolean)false).setAliases(new String[]{"dir", "dataInputRecords"}).build());
        table.addCell((Object)"data.input_fields", TableColumnAttributeBuilder.builder((String)"total field count", (boolean)false).setAliases(new String[]{"dif", "dataInputFields"}).build());
        table.addCell((Object)"data.invalid_dates", TableColumnAttributeBuilder.builder((String)"number of records with invalid dates", (boolean)false).setAliases(new String[]{"did", "dataInvalidDates"}).build());
        table.addCell((Object)"data.missing_fields", TableColumnAttributeBuilder.builder((String)"number of records with missing fields", (boolean)false).setAliases(new String[]{"dmf", "dataMissingFields"}).build());
        table.addCell((Object)"data.out_of_order_timestamps", TableColumnAttributeBuilder.builder((String)"number of records handled out of order", (boolean)false).setAliases(new String[]{"doot", "dataOutOfOrderTimestamps"}).build());
        table.addCell((Object)"data.empty_buckets", TableColumnAttributeBuilder.builder((String)"number of empty buckets", (boolean)false).setAliases(new String[]{"deb", "dataEmptyBuckets"}).build());
        table.addCell((Object)"data.sparse_buckets", TableColumnAttributeBuilder.builder((String)"number of sparse buckets", (boolean)false).setAliases(new String[]{"dsb", "dataSparseBuckets"}).build());
        table.addCell((Object)"data.buckets", TableColumnAttributeBuilder.builder((String)"total bucket count", (boolean)false).setAliases(new String[]{"db", "dataBuckets"}).build());
        table.addCell((Object)"data.earliest_record", TableColumnAttributeBuilder.builder((String)"earliest record time", (boolean)false).setAliases(new String[]{"der", "dataEarliestRecord"}).build());
        table.addCell((Object)"data.latest_record", TableColumnAttributeBuilder.builder((String)"latest record time", (boolean)false).setAliases(new String[]{"dlr", "dataLatestRecord"}).build());
        table.addCell((Object)"data.last", TableColumnAttributeBuilder.builder((String)"last time data was seen", (boolean)false).setAliases(new String[]{"dl", "dataLast"}).build());
        table.addCell((Object)"data.last_empty_bucket", TableColumnAttributeBuilder.builder((String)"last time an empty bucket occurred", (boolean)false).setAliases(new String[]{"dleb", "dataLastEmptyBucket"}).build());
        table.addCell((Object)"data.last_sparse_bucket", TableColumnAttributeBuilder.builder((String)"last time a sparse bucket occurred", (boolean)false).setAliases(new String[]{"dlsb", "dataLastSparseBucket"}).build());
        table.addCell((Object)"model.bytes", TableColumnAttributeBuilder.builder((String)"model size").setAliases(new String[]{"mb", "modelBytes"}).build());
        table.addCell((Object)"model.memory_status", TableColumnAttributeBuilder.builder((String)"current memory status").setAliases(new String[]{"mms", "modelMemoryStatus"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build());
        table.addCell((Object)"model.bytes_exceeded", TableColumnAttributeBuilder.builder((String)"how much the model has exceeded the limit", (boolean)false).setAliases(new String[]{"mbe", "modelBytesExceeded"}).build());
        table.addCell((Object)"model.memory_limit", TableColumnAttributeBuilder.builder((String)"model memory limit", (boolean)false).setAliases(new String[]{"mml", "modelMemoryLimit"}).build());
        table.addCell((Object)"model.by_fields", TableColumnAttributeBuilder.builder((String)"count of 'by' fields", (boolean)false).setAliases(new String[]{"mbf", "modelByFields"}).build());
        table.addCell((Object)"model.over_fields", TableColumnAttributeBuilder.builder((String)"count of 'over' fields", (boolean)false).setAliases(new String[]{"mof", "modelOverFields"}).build());
        table.addCell((Object)"model.partition_fields", TableColumnAttributeBuilder.builder((String)"count of 'partition' fields", (boolean)false).setAliases(new String[]{"mpf", "modelPartitionFields"}).build());
        table.addCell((Object)"model.bucket_allocation_failures", TableColumnAttributeBuilder.builder((String)"number of bucket allocation failures", (boolean)false).setAliases(new String[]{"mbaf", "modelBucketAllocationFailures"}).build());
        table.addCell((Object)"model.categorization_status", TableColumnAttributeBuilder.builder((String)"current categorization status", (boolean)false).setAliases(new String[]{"mcs", "modelCategorizationStatus"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build());
        table.addCell((Object)"model.categorized_doc_count", TableColumnAttributeBuilder.builder((String)"count of categorized documents", (boolean)false).setAliases(new String[]{"mcdc", "modelCategorizedDocCount"}).build());
        table.addCell((Object)"model.total_category_count", TableColumnAttributeBuilder.builder((String)"count of categories", (boolean)false).setAliases(new String[]{"mtcc", "modelTotalCategoryCount"}).build());
        table.addCell((Object)"model.frequent_category_count", TableColumnAttributeBuilder.builder((String)"count of frequent categories", (boolean)false).setAliases(new String[]{"mfcc", "modelFrequentCategoryCount"}).build());
        table.addCell((Object)"model.rare_category_count", TableColumnAttributeBuilder.builder((String)"count of rare categories", (boolean)false).setAliases(new String[]{"mrcc", "modelRareCategoryCount"}).build());
        table.addCell((Object)"model.dead_category_count", TableColumnAttributeBuilder.builder((String)"count of dead categories", (boolean)false).setAliases(new String[]{"mdcc", "modelDeadCategoryCount"}).build());
        table.addCell((Object)"model.failed_category_count", TableColumnAttributeBuilder.builder((String)"count of failed categories", (boolean)false).setAliases(new String[]{"mfcc", "modelFailedCategoryCount"}).build());
        table.addCell((Object)"model.log_time", TableColumnAttributeBuilder.builder((String)"when the model stats were gathered", (boolean)false).setAliases(new String[]{"mlt", "modelLogTime"}).build());
        table.addCell((Object)"model.timestamp", TableColumnAttributeBuilder.builder((String)"the time of the last record when the model stats were gathered", (boolean)false).setAliases(new String[]{"mt", "modelTimestamp"}).build());
        table.addCell((Object)"forecasts.total", TableColumnAttributeBuilder.builder((String)"total number of forecasts").setAliases(new String[]{"ft", "forecastsTotal"}).build());
        table.addCell((Object)"forecasts.memory.min", TableColumnAttributeBuilder.builder((String)"minimum memory used by forecasts", (boolean)false).setAliases(new String[]{"fmmin", "forecastsMemoryMin"}).build());
        table.addCell((Object)"forecasts.memory.max", TableColumnAttributeBuilder.builder((String)"maximum memory used by forecasts", (boolean)false).setAliases(new String[]{"fmmax", "forecastsMemoryMax"}).build());
        table.addCell((Object)"forecasts.memory.avg", TableColumnAttributeBuilder.builder((String)"average memory used by forecasts", (boolean)false).setAliases(new String[]{"fmavg", "forecastsMemoryAvg"}).build());
        table.addCell((Object)"forecasts.memory.total", TableColumnAttributeBuilder.builder((String)"total memory used by all forecasts", (boolean)false).setAliases(new String[]{"fmt", "forecastsMemoryTotal"}).build());
        table.addCell((Object)"forecasts.records.min", TableColumnAttributeBuilder.builder((String)"minimum record count for forecasts", (boolean)false).setAliases(new String[]{"frmin", "forecastsRecordsMin"}).build());
        table.addCell((Object)"forecasts.records.max", TableColumnAttributeBuilder.builder((String)"maximum record count for forecasts", (boolean)false).setAliases(new String[]{"frmax", "forecastsRecordsMax"}).build());
        table.addCell((Object)"forecasts.records.avg", TableColumnAttributeBuilder.builder((String)"average record count for forecasts", (boolean)false).setAliases(new String[]{"fravg", "forecastsRecordsAvg"}).build());
        table.addCell((Object)"forecasts.records.total", TableColumnAttributeBuilder.builder((String)"total record count for all forecasts", (boolean)false).setAliases(new String[]{"frt", "forecastsRecordsTotal"}).build());
        table.addCell((Object)"forecasts.time.min", TableColumnAttributeBuilder.builder((String)"minimum runtime for forecasts", (boolean)false).setAliases(new String[]{"ftmin", "forecastsTimeMin"}).build());
        table.addCell((Object)"forecasts.time.max", TableColumnAttributeBuilder.builder((String)"maximum run time for forecasts", (boolean)false).setAliases(new String[]{"ftmax", "forecastsTimeMax"}).build());
        table.addCell((Object)"forecasts.time.avg", TableColumnAttributeBuilder.builder((String)"average runtime for all forecasts (milliseconds)", (boolean)false).setAliases(new String[]{"ftavg", "forecastsTimeAvg"}).build());
        table.addCell((Object)"forecasts.time.total", TableColumnAttributeBuilder.builder((String)"total runtime for all forecasts", (boolean)false).setAliases(new String[]{"ftt", "forecastsTimeTotal"}).build());
        table.addCell((Object)"node.id", TableColumnAttributeBuilder.builder((String)"id of the assigned node", (boolean)false).setAliases(new String[]{"ni", "nodeId"}).build());
        table.addCell((Object)"node.name", TableColumnAttributeBuilder.builder((String)"name of the assigned node", (boolean)false).setAliases(new String[]{"nn", "nodeName"}).build());
        table.addCell((Object)"node.ephemeral_id", TableColumnAttributeBuilder.builder((String)"ephemeral id of the assigned node", (boolean)false).setAliases(new String[]{"ne", "nodeEphemeralId"}).build());
        table.addCell((Object)"node.address", TableColumnAttributeBuilder.builder((String)"network address of the assigned node", (boolean)false).setAliases(new String[]{"na", "nodeAddress"}).build());
        table.addCell((Object)"buckets.count", TableColumnAttributeBuilder.builder((String)"bucket count").setAliases(new String[]{"bc", "bucketsCount"}).build());
        table.addCell((Object)"buckets.time.total", TableColumnAttributeBuilder.builder((String)"total bucket processing time", (boolean)false).setAliases(new String[]{"btt", "bucketsTimeTotal"}).build());
        table.addCell((Object)"buckets.time.min", TableColumnAttributeBuilder.builder((String)"minimum bucket processing time", (boolean)false).setAliases(new String[]{"btmin", "bucketsTimeMin"}).build());
        table.addCell((Object)"buckets.time.max", TableColumnAttributeBuilder.builder((String)"maximum bucket processing time", (boolean)false).setAliases(new String[]{"btmax", "bucketsTimeMax"}).build());
        table.addCell((Object)"buckets.time.exp_avg", TableColumnAttributeBuilder.builder((String)"exponential average bucket processing time (milliseconds)", (boolean)false).setAliases(new String[]{"btea", "bucketsTimeExpAvg"}).build());
        table.addCell((Object)"buckets.time.exp_avg_hour", TableColumnAttributeBuilder.builder((String)"exponential average bucket processing time by hour (milliseconds)", (boolean)false).setAliases(new String[]{"bteah", "bucketsTimeExpAvgHour"}).build());
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, GetJobsStatsAction.Response jobStats) {
        Table table = this.getTableWithHeader(request);
        jobStats.getResponse().results().forEach(job -> {
            table.startRow();
            table.addCell((Object)job.getJobId());
            table.addCell((Object)job.getState().value());
            table.addCell((Object)job.getOpenTime());
            table.addCell((Object)job.getAssignmentExplanation());
            DataCounts dataCounts = job.getDataCounts();
            table.addCell((Object)dataCounts.getProcessedRecordCount());
            table.addCell((Object)dataCounts.getProcessedFieldCount());
            table.addCell((Object)ByteSizeValue.ofBytes((long)dataCounts.getInputBytes()));
            table.addCell((Object)dataCounts.getInputRecordCount());
            table.addCell((Object)dataCounts.getInputFieldCount());
            table.addCell((Object)dataCounts.getInvalidDateCount());
            table.addCell((Object)dataCounts.getMissingFieldCount());
            table.addCell((Object)dataCounts.getOutOfOrderTimeStampCount());
            table.addCell((Object)dataCounts.getEmptyBucketCount());
            table.addCell((Object)dataCounts.getSparseBucketCount());
            table.addCell((Object)dataCounts.getBucketCount());
            table.addCell((Object)dataCounts.getEarliestRecordTimeStamp());
            table.addCell((Object)dataCounts.getLatestRecordTimeStamp());
            table.addCell((Object)dataCounts.getLastDataTimeStamp());
            table.addCell((Object)dataCounts.getLatestEmptyBucketTimeStamp());
            table.addCell((Object)dataCounts.getLatestSparseBucketTimeStamp());
            ModelSizeStats modelSizeStats = job.getModelSizeStats();
            table.addCell(modelSizeStats == null ? null : ByteSizeValue.ofBytes((long)modelSizeStats.getModelBytes()));
            table.addCell(modelSizeStats == null ? null : modelSizeStats.getMemoryStatus().toString());
            table.addCell(modelSizeStats == null || modelSizeStats.getModelBytesExceeded() == null ? null : ByteSizeValue.ofBytes((long)modelSizeStats.getModelBytesExceeded()));
            table.addCell(modelSizeStats == null || modelSizeStats.getModelBytesMemoryLimit() == null ? null : ByteSizeValue.ofBytes((long)modelSizeStats.getModelBytesMemoryLimit()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getTotalByFieldCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getTotalOverFieldCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getTotalPartitionFieldCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getBucketAllocationFailuresCount()));
            table.addCell(modelSizeStats == null ? null : modelSizeStats.getCategorizationStatus().toString());
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getCategorizedDocCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getTotalCategoryCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getFrequentCategoryCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getRareCategoryCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getDeadCategoryCount()));
            table.addCell(modelSizeStats == null ? null : Long.valueOf(modelSizeStats.getFailedCategoryCount()));
            table.addCell((Object)(modelSizeStats == null ? null : modelSizeStats.getLogTime()));
            table.addCell((Object)(modelSizeStats == null ? null : modelSizeStats.getTimestamp()));
            ForecastStats forecastStats = job.getForecastStats();
            boolean missingForecastStats = forecastStats == null || forecastStats.getTotal() <= 0L;
            table.addCell(forecastStats == null ? null : Long.valueOf(forecastStats.getTotal()));
            table.addCell(missingForecastStats ? null : ByteSizeValue.ofBytes((long)((long)forecastStats.getMemoryStats().getMin())));
            table.addCell(missingForecastStats ? null : ByteSizeValue.ofBytes((long)((long)forecastStats.getMemoryStats().getMax())));
            table.addCell(missingForecastStats ? null : ByteSizeValue.ofBytes((long)Math.round(forecastStats.getMemoryStats().getAvg())));
            table.addCell(missingForecastStats ? null : ByteSizeValue.ofBytes((long)((long)forecastStats.getMemoryStats().getTotal())));
            table.addCell(missingForecastStats ? null : Double.valueOf(forecastStats.getRecordStats().getMin()));
            table.addCell(missingForecastStats ? null : Double.valueOf(forecastStats.getRecordStats().getMax()));
            table.addCell(missingForecastStats ? null : Double.valueOf(forecastStats.getRecordStats().getAvg()));
            table.addCell(missingForecastStats ? null : Double.valueOf(forecastStats.getRecordStats().getTotal()));
            table.addCell(missingForecastStats ? null : TimeValue.timeValueMillis((long)((long)forecastStats.getRuntimeStats().getMin())));
            table.addCell(missingForecastStats ? null : TimeValue.timeValueMillis((long)((long)forecastStats.getRuntimeStats().getMax())));
            table.addCell(missingForecastStats ? null : Double.valueOf(forecastStats.getRuntimeStats().getAvg()));
            table.addCell(missingForecastStats ? null : TimeValue.timeValueMillis((long)((long)forecastStats.getRuntimeStats().getTotal())));
            DiscoveryNode node = job.getNode();
            table.addCell((Object)(node == null ? null : node.getId()));
            table.addCell((Object)(node == null ? null : node.getName()));
            table.addCell((Object)(node == null ? null : node.getEphemeralId()));
            table.addCell(node == null ? null : node.getAddress().toString());
            TimingStats timingStats = job.getTimingStats();
            table.addCell(timingStats == null ? null : Long.valueOf(timingStats.getBucketCount()));
            table.addCell(timingStats == null ? null : TimeValue.timeValueMillis((long)((long)timingStats.getTotalBucketProcessingTimeMs())));
            table.addCell(timingStats == null || timingStats.getMinBucketProcessingTimeMs() == null ? null : TimeValue.timeValueMillis((long)timingStats.getMinBucketProcessingTimeMs().longValue()));
            table.addCell(timingStats == null || timingStats.getMaxBucketProcessingTimeMs() == null ? null : TimeValue.timeValueMillis((long)timingStats.getMaxBucketProcessingTimeMs().longValue()));
            table.addCell((Object)(timingStats == null ? null : timingStats.getExponentialAvgBucketProcessingTimeMs()));
            table.addCell((Object)(timingStats == null ? null : timingStats.getExponentialAvgBucketProcessingTimePerHourMs()));
            table.endRow();
        });
        return table;
    }
}

