/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;

public class ProcessWorkerExecutorService
extends AbstractExecutorService {
    private static final Logger logger = LogManager.getLogger(ProcessWorkerExecutorService.class);
    private final ThreadContext contextHolder;
    private final String processName;
    private final CountDownLatch awaitTermination = new CountDownLatch(1);
    private final BlockingQueue<Runnable> queue;
    private final AtomicReference<Exception> error = new AtomicReference();
    private volatile boolean running = true;

    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    public ProcessWorkerExecutorService(ThreadContext contextHolder, String processName, int queueCapacity) {
        this.contextHolder = Objects.requireNonNull(contextHolder);
        this.processName = Objects.requireNonNull(processName);
        this.queue = new LinkedBlockingQueue<Runnable>(queueCapacity);
    }

    public int queueSize() {
        return this.queue.size();
    }

    public void shutdownWithError(Exception e) {
        this.error.set(e);
        this.shutdown();
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    @Override
    public boolean isTerminated() {
        return this.awaitTermination.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitTermination.await(timeout, unit);
    }

    @Override
    public synchronized void execute(Runnable command) {
        if (this.isShutdown()) {
            EsRejectedExecutionException rejected = new EsRejectedExecutionException(this.processName + " worker service has shutdown", true);
            if (command instanceof AbstractRunnable) {
                AbstractRunnable runnable = (AbstractRunnable)command;
                runnable.onRejection((Exception)((Object)rejected));
                return;
            }
            throw rejected;
        }
        boolean added = this.queue.offer(this.contextHolder.preserveContext(command));
        if (!added) {
            throw new EsRejectedExecutionException(this.processName + " queue is full. Unable to execute command", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            Object runnable;
            while (this.running) {
                runnable = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error(() -> new ParameterizedMessage("error handling process [{}] operation", (Object)this.processName), (Throwable)e);
                }
                EsExecutors.rethrowErrors((Runnable)this.contextHolder.unwrap((Runnable)runnable));
            }
            runnable = this;
            synchronized (runnable) {
                if (!this.queue.isEmpty()) {
                    ArrayList notExecuted = new ArrayList();
                    this.queue.drainTo(notExecuted);
                    String msg = "unable to process as " + this.processName + " worker service has shutdown";
                    Exception ex = this.error.get();
                    for (Runnable runnable2 : notExecuted) {
                        if (!(runnable2 instanceof AbstractRunnable)) continue;
                        AbstractRunnable ar = (AbstractRunnable)runnable2;
                        if (ex != null) {
                            ar.onFailure(ex);
                            continue;
                        }
                        ar.onRejection((Exception)((Object)new EsRejectedExecutionException(msg, true)));
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.awaitTermination.countDown();
        }
    }
}

