/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence.overallbuckets;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ml.job.results.OverallBucket;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsProcessor;

public class OverallBucketsAggregator
implements OverallBucketsProcessor {
    private final long bucketSpanSeconds;
    private final long bucketSpanMillis;
    private double maxOverallScore = 0.0;
    private Map<String, Double> maxScoreByJob = new TreeMap<String, Double>();
    private boolean isInterim = false;
    private Long startTime;
    private final List<OverallBucket> aggregated = new ArrayList<OverallBucket>();

    public OverallBucketsAggregator(TimeValue bucketSpan) {
        this.bucketSpanSeconds = bucketSpan.seconds();
        this.bucketSpanMillis = bucketSpan.millis();
    }

    @Override
    public synchronized void process(List<OverallBucket> buckets) {
        if (buckets.isEmpty()) {
            return;
        }
        if (this.startTime == null) {
            this.startTime = Intervals.alignToFloor((long)buckets.get(0).getTimestamp().getTime(), (long)this.bucketSpanMillis);
        }
        for (OverallBucket bucket : buckets) {
            long bucketTime = bucket.getTimestamp().getTime();
            if (bucketTime >= this.startTime + this.bucketSpanMillis) {
                this.aggregated.add(this.outputBucket());
                this.startNextBucket(bucketTime);
            }
            this.processBucket(bucket);
        }
    }

    private OverallBucket outputBucket() {
        ArrayList jobs = new ArrayList(this.maxScoreByJob.size());
        this.maxScoreByJob.entrySet().stream().forEach(entry -> jobs.add(new OverallBucket.JobInfo((String)entry.getKey(), ((Double)entry.getValue()).doubleValue())));
        return new OverallBucket(new Date(this.startTime), this.bucketSpanSeconds, this.maxOverallScore, jobs, this.isInterim);
    }

    private void startNextBucket(long bucketTime) {
        this.maxOverallScore = 0.0;
        this.maxScoreByJob.clear();
        this.isInterim = false;
        this.startTime = Intervals.alignToFloor((long)bucketTime, (long)this.bucketSpanMillis);
    }

    private void processBucket(OverallBucket bucket) {
        this.maxOverallScore = Math.max(this.maxOverallScore, bucket.getOverallScore());
        bucket.getJobs().stream().forEach(j -> {
            double currentMax = this.maxScoreByJob.computeIfAbsent(j.getJobId(), k -> 0.0);
            if (j.getMaxAnomalyScore() > currentMax) {
                this.maxScoreByJob.put(j.getJobId(), j.getMaxAnomalyScore());
            }
        });
        this.isInterim |= bucket.isInterim();
    }

    @Override
    public synchronized List<OverallBucket> finish() {
        if (this.startTime != null) {
            this.aggregated.add(this.outputBucket());
        }
        return this.aggregated;
    }

    @Override
    public synchronized int size() {
        return this.aggregated.size();
    }
}

