/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CancelJobModelSnapshotUpgradeAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.UpdateJobProcessNotifier;
import org.elasticsearch.xpack.ml.job.categorization.CategorizationAnalyzer;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateParams;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.VoidChainTaskExecutor;

public class JobManager {
    private static final Version MIN_NODE_VERSION_FOR_STANDARD_CATEGORIZATION_ANALYZER = Version.V_7_14_0;
    private static final Logger logger = LogManager.getLogger(JobManager.class);
    private final JobResultsProvider jobResultsProvider;
    private final JobResultsPersister jobResultsPersister;
    private final ClusterService clusterService;
    private final AnomalyDetectionAuditor auditor;
    private final Client client;
    private final ThreadPool threadPool;
    private final UpdateJobProcessNotifier updateJobProcessNotifier;
    private final JobConfigProvider jobConfigProvider;
    private final NamedXContentRegistry xContentRegistry;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Supplier<ByteSizeValue> maxModelMemoryLimitSupplier;

    public JobManager(JobResultsProvider jobResultsProvider, JobResultsPersister jobResultsPersister, ClusterService clusterService, AnomalyDetectionAuditor auditor, ThreadPool threadPool, Client client, UpdateJobProcessNotifier updateJobProcessNotifier, NamedXContentRegistry xContentRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<ByteSizeValue> maxModelMemoryLimitSupplier) {
        this.jobResultsProvider = Objects.requireNonNull(jobResultsProvider);
        this.jobResultsPersister = Objects.requireNonNull(jobResultsPersister);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.auditor = Objects.requireNonNull(auditor);
        this.client = Objects.requireNonNull(client);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.updateJobProcessNotifier = updateJobProcessNotifier;
        this.jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        this.xContentRegistry = xContentRegistry;
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
        this.maxModelMemoryLimitSupplier = Objects.requireNonNull(maxModelMemoryLimitSupplier);
    }

    public void jobExists(String jobId, ActionListener<Boolean> listener) {
        this.jobConfigProvider.jobExists(jobId, true, listener);
    }

    public void getJob(String jobId, ActionListener<Job> jobListener) {
        this.jobConfigProvider.getJob(jobId, (ActionListener<Job.Builder>)ActionListener.wrap(r -> jobListener.onResponse((Object)r.build()), arg_0 -> jobListener.onFailure(arg_0)));
    }

    public void expandJobBuilders(String expression, boolean allowNoMatch, ActionListener<List<Job.Builder>> jobsListener) {
        this.jobConfigProvider.expandJobs(expression, allowNoMatch, false, jobsListener);
    }

    public void expandJobs(String expression, boolean allowNoMatch, ActionListener<QueryPage<Job>> jobsListener) {
        this.expandJobBuilders(expression, allowNoMatch, (ActionListener<List<Job.Builder>>)ActionListener.wrap(jobBuilders -> jobsListener.onResponse((Object)new QueryPage(jobBuilders.stream().map(Job.Builder::build).collect(Collectors.toList()), (long)jobBuilders.size(), Job.RESULTS_FIELD)), arg_0 -> jobsListener.onFailure(arg_0)));
    }

    static void validateCategorizationAnalyzerOrSetDefault(Job.Builder jobBuilder, AnalysisRegistry analysisRegistry, Version minNodeVersion) throws IOException {
        AnalysisConfig analysisConfig = jobBuilder.getAnalysisConfig();
        CategorizationAnalyzerConfig categorizationAnalyzerConfig = analysisConfig.getCategorizationAnalyzerConfig();
        if (categorizationAnalyzerConfig != null) {
            CategorizationAnalyzer.verifyConfigBuilder(new CategorizationAnalyzerConfig.Builder(categorizationAnalyzerConfig), analysisRegistry);
        } else if (analysisConfig.getCategorizationFieldName() != null && minNodeVersion.onOrAfter(MIN_NODE_VERSION_FOR_STANDARD_CATEGORIZATION_ANALYZER)) {
            AnalysisConfig.Builder analysisConfigBuilder = new AnalysisConfig.Builder(analysisConfig).setCategorizationAnalyzerConfig(CategorizationAnalyzerConfig.buildStandardCategorizationAnalyzer((List)analysisConfig.getCategorizationFilters())).setCategorizationFilters(null);
            jobBuilder.setAnalysisConfig(analysisConfigBuilder);
        }
    }

    public void putJob(PutJobAction.Request request, AnalysisRegistry analysisRegistry, ClusterState state, final ActionListener<PutJobAction.Response> actionListener) throws IOException {
        Version minNodeVersion = state.getNodes().getMinNodeVersion();
        Job.Builder jobBuilder = request.getJobBuilder();
        jobBuilder.validateAnalysisLimitsAndSetDefaults(this.maxModelMemoryLimitSupplier.get());
        jobBuilder.validateModelSnapshotRetentionSettingsAndSetDefaults();
        JobManager.validateCategorizationAnalyzerOrSetDefault(jobBuilder, analysisRegistry, minNodeVersion);
        final Job job = jobBuilder.build(new Date());
        ActionListener<Boolean> putJobListener = new ActionListener<Boolean>(){

            public void onResponse(Boolean mappingsUpdated) {
                JobManager.this.jobConfigProvider.putJob(job, (ActionListener<IndexResponse>)ActionListener.wrap(response -> {
                    JobManager.this.auditor.info(job.getId(), Messages.getMessage((String)"Job created"));
                    actionListener.onResponse((Object)new PutJobAction.Response(job));
                }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
            }

            public void onFailure(Exception e) {
                Matcher matcher;
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IllegalArgumentException && (matcher = Pattern.compile("can't merge a non object mapping \\[(.*)\\] with an object mapping").matcher(e.getMessage())).matches()) {
                    String msg = Messages.getMessage((String)"This job would cause a mapping clash with existing field [{0}] - avoid the clash by assigning a dedicated results index", (Object[])new Object[]{matcher.group(1)});
                    actionListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)msg, (Throwable)e, (Object[])new Object[0]));
                    return;
                }
                actionListener.onFailure(e);
            }
        };
        ActionListener addDocMappingsListener = ActionListener.wrap(arg_0 -> this.lambda$putJob$2(state, request, (ActionListener)putJobListener, arg_0), arg_0 -> ((ActionListener)putJobListener).onFailure(arg_0));
        ActionListener checkForLeftOverDocs = ActionListener.wrap(matchedIds -> {
            if (matchedIds.isEmpty()) {
                if (job.getDatafeedConfig().isPresent()) {
                    try {
                        DatafeedJobValidator.validate((DatafeedConfig)((DatafeedConfig)job.getDatafeedConfig().get()), (Job)job, (NamedXContentRegistry)this.xContentRegistry);
                    }
                    catch (Exception e) {
                        actionListener.onFailure(e);
                        return;
                    }
                }
                this.jobResultsProvider.createJobResultIndex(job, state, (ActionListener<Boolean>)addDocMappingsListener);
            } else {
                actionListener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"job and group names must be unique but job [{0}] and group [{0}] have the same name", (Object[])new Object[]{matchedIds.get(0)}), new Object[0]));
            }
        }, arg_0 -> actionListener.onFailure(arg_0));
        ActionListener checkNoJobsWithGroupId = ActionListener.wrap(groupExists -> {
            if (groupExists.booleanValue()) {
                actionListener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"job and group names must be unique but job [{0}] and group [{0}] have the same name", (Object[])new Object[]{job.getId()}), new Object[0]));
                return;
            }
            if (job.getGroups().isEmpty()) {
                checkForLeftOverDocs.onResponse(Collections.emptyList());
            } else {
                this.jobConfigProvider.jobIdMatches(job.getGroups(), (ActionListener<List<String>>)checkForLeftOverDocs);
            }
        }, arg_0 -> actionListener.onFailure(arg_0));
        ActionListener checkNoGroupWithTheJobId = ActionListener.wrap(ok -> this.jobConfigProvider.groupExists(job.getId(), (ActionListener<Boolean>)checkNoJobsWithGroupId), arg_0 -> actionListener.onFailure(arg_0));
        this.jobConfigProvider.jobExists(job.getId(), false, (ActionListener<Boolean>)ActionListener.wrap(jobExists -> {
            if (jobExists.booleanValue()) {
                actionListener.onFailure((Exception)ExceptionsHelper.jobAlreadyExists((String)job.getId()));
            } else {
                this.jobResultsProvider.checkForLeftOverDocuments(job, (ActionListener<Boolean>)checkNoGroupWithTheJobId);
            }
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    public void updateJob(UpdateJobAction.Request request, ActionListener<PutJobAction.Response> actionListener) {
        Runnable doUpdate = () -> this.jobConfigProvider.updateJobWithValidation(request.getJobId(), request.getJobUpdate(), this.maxModelMemoryLimitSupplier.get(), this::validate, (ActionListener<Job>)ActionListener.wrap(updatedJob -> this.postJobUpdate(request, (Job)updatedJob, actionListener), arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
        Runnable checkMappingsAreUpToDate = () -> ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)this.clusterService.state(), (TimeValue)request.masterNodeTimeout(), (ActionListener)ActionListener.wrap(bool -> doUpdate.run(), arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
        if (request.getJobUpdate().getGroups() != null && !request.getJobUpdate().getGroups().isEmpty()) {
            this.jobConfigProvider.jobIdMatches(request.getJobUpdate().getGroups(), (ActionListener<List<String>>)ActionListener.wrap(matchingIds -> {
                if (matchingIds.isEmpty()) {
                    checkMappingsAreUpToDate.run();
                } else {
                    actionListener.onFailure((Exception)new ResourceAlreadyExistsException(Messages.getMessage((String)"job and group names must be unique but job [{0}] and group [{0}] have the same name", (Object[])new Object[]{matchingIds.get(0)}), new Object[0]));
                }
            }, arg_0 -> actionListener.onFailure(arg_0)));
        } else {
            checkMappingsAreUpToDate.run();
        }
    }

    public void deleteJob(DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.deleteJob(request, this.client, state, listener);
    }

    public void deleteJob(DeleteJobAction.Request request, Client clientToUse, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        CheckedConsumer configResponseHandler = jobDeleted -> {
            if (jobDeleted.booleanValue()) {
                logger.info("Job [" + jobId + "] deleted");
                this.auditor.info(jobId, Messages.getMessage((String)"Job deleted"));
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onResponse((Object)AcknowledgedResponse.FALSE);
            }
        };
        CheckedConsumer removeFromCalendarsHandler = response -> this.jobConfigProvider.deleteJob(jobId, false, (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> configResponseHandler.accept((Object)Boolean.TRUE), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        CheckedConsumer deleteJobStateHandler = response -> this.jobResultsProvider.removeJobFromCalendars(jobId, (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)removeFromCalendarsHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        ActionListener cancelUpgradesListener = ActionListener.wrap(r -> new JobDataDeleter(clientToUse, jobId).deleteJobDocuments(this.jobConfigProvider, this.indexNameExpressionResolver, state, (CheckedConsumer<Boolean, Exception>)deleteJobStateHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), arg_0 -> listener.onFailure(arg_0));
        clientToUse.execute((ActionType)CancelJobModelSnapshotUpgradeAction.INSTANCE, (ActionRequest)new CancelJobModelSnapshotUpgradeAction.Request(jobId, "_all"), cancelUpgradesListener);
    }

    private void postJobUpdate(UpdateJobAction.Request request, Job updatedJob, ActionListener<PutJobAction.Response> actionListener) {
        JobUpdate jobUpdate = request.getJobUpdate();
        if (jobUpdate.isAutodetectProcessUpdate()) {
            if (this.isJobOpen(this.clusterService.state(), request.getJobId())) {
                this.updateJobProcessNotifier.submitJobUpdate(UpdateParams.fromJobUpdate(jobUpdate), (ActionListener<Boolean>)ActionListener.wrap(isUpdated -> {
                    if (isUpdated.booleanValue()) {
                        this.auditJobUpdatedIfNotInternal(request);
                    } else {
                        logger.error("[{}] Updating autodetect failed for job update [{}]", (Object)jobUpdate.getJobId(), (Object)jobUpdate);
                    }
                }, e -> logger.error((Message)new ParameterizedMessage("[{}] Updating autodetect failed with an exception, job update [{}] ", (Object)jobUpdate.getJobId(), (Object)jobUpdate), (Throwable)e)));
            }
        } else {
            org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[2];
            supplierArray[0] = () -> ((JobUpdate)jobUpdate).getJobId();
            supplierArray[1] = () -> ((JobUpdate)jobUpdate).toString();
            logger.debug("[{}] No process update required for job update: {}", supplierArray);
            this.auditJobUpdatedIfNotInternal(request);
        }
        actionListener.onResponse((Object)new PutJobAction.Response(updatedJob));
    }

    private void validate(Job job, JobUpdate jobUpdate, ActionListener<Void> handler) {
        VoidChainTaskExecutor voidChainTaskExecutor = new VoidChainTaskExecutor(this.client.threadPool().executor("ml_utility"), true);
        this.validateModelSnapshotIdUpdate(job, jobUpdate.getModelSnapshotId(), voidChainTaskExecutor);
        this.validateAnalysisLimitsUpdate(job, jobUpdate.getAnalysisLimits(), voidChainTaskExecutor);
        voidChainTaskExecutor.execute(ActionListener.wrap(aVoids -> handler.onResponse(null), arg_0 -> handler.onFailure(arg_0)));
    }

    private void validateModelSnapshotIdUpdate(Job job, String modelSnapshotId, VoidChainTaskExecutor voidChainTaskExecutor) {
        if (modelSnapshotId != null && !ModelSnapshot.isTheEmptySnapshot((String)modelSnapshotId)) {
            voidChainTaskExecutor.add(listener -> this.jobResultsProvider.getModelSnapshot(job.getId(), modelSnapshotId, newModelSnapshot -> {
                if (newModelSnapshot == null) {
                    String message = Messages.getMessage((String)"No model snapshot with id [{0}] exists for job [{1}]", (Object[])new Object[]{modelSnapshotId, job.getId()});
                    listener.onFailure((Exception)new ResourceNotFoundException(message, new Object[0]));
                    return;
                }
                this.jobResultsProvider.getModelSnapshot(job.getId(), job.getModelSnapshotId(), oldModelSnapshot -> {
                    if (oldModelSnapshot != null && ((ModelSnapshot)newModelSnapshot.result).getTimestamp().before(((ModelSnapshot)oldModelSnapshot.result).getTimestamp())) {
                        String message = "Job [" + job.getId() + "] has a more recent model snapshot [" + ((ModelSnapshot)oldModelSnapshot.result).getSnapshotId() + "]";
                        listener.onFailure((Exception)new IllegalArgumentException(message));
                    }
                    listener.onResponse(null);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }
    }

    private void validateAnalysisLimitsUpdate(Job job, AnalysisLimits newLimits, VoidChainTaskExecutor voidChainTaskExecutor) {
        if (newLimits == null || newLimits.getModelMemoryLimit() == null) {
            return;
        }
        Long newModelMemoryLimit = newLimits.getModelMemoryLimit();
        voidChainTaskExecutor.add(listener -> {
            if (this.isJobOpen(this.clusterService.state(), job.getId())) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Cannot update " + Job.ANALYSIS_LIMITS.getPreferredName() + " while the job is open"), (Object[])new Object[0]));
                return;
            }
            this.jobResultsProvider.modelSizeStats(job.getId(), modelSizeStats -> {
                if (modelSizeStats != null) {
                    ByteSizeValue modelSize = ByteSizeValue.ofBytes((long)modelSizeStats.getModelBytes());
                    if (newModelMemoryLimit < modelSize.getMb()) {
                        listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Invalid update value for analysis_limits: model_memory_limit cannot be decreased below current usage; current usage [{0}], update had [{1}]", (Object[])new Object[]{ByteSizeValue.ofMb((long)modelSize.getMb()), ByteSizeValue.ofMb((long)newModelMemoryLimit)}), (Object[])new Object[0]));
                        return;
                    }
                }
                listener.onResponse(null);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        });
    }

    private void auditJobUpdatedIfNotInternal(UpdateJobAction.Request request) {
        if (!request.isInternal()) {
            this.auditor.info(request.getJobId(), Messages.getMessage((String)"Job updated: {0}", (Object[])new Object[]{request.getJobUpdate().getUpdateFields()}));
        }
    }

    private boolean isJobOpen(ClusterState clusterState, String jobId) {
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom("persistent_tasks");
        JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetadata)persistentTasks);
        return jobState == JobState.OPENED;
    }

    private Set<String> openJobIds(ClusterState clusterState) {
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom("persistent_tasks");
        return MlTasks.openJobIds((PersistentTasksCustomMetadata)persistentTasks);
    }

    public void notifyFilterChanged(MlFilter filter, Set<String> addedItems, Set<String> removedItems, ActionListener<Boolean> updatedListener) {
        if (addedItems.isEmpty() && removedItems.isEmpty()) {
            updatedListener.onResponse((Object)Boolean.TRUE);
            return;
        }
        this.jobConfigProvider.findJobsWithCustomRules((ActionListener<List<Job>>)ActionListener.wrap(jobBuilders -> this.threadPool.executor("ml_utility").execute(() -> {
            for (Job job : jobBuilders) {
                Set jobFilters = job.getAnalysisConfig().extractReferencedFilters();
                ClusterState clusterState = this.clusterService.state();
                if (!jobFilters.contains(filter.getId())) continue;
                if (this.isJobOpen(clusterState, job.getId())) {
                    this.updateJobProcessNotifier.submitJobUpdate(UpdateParams.filterUpdate(job.getId(), filter), (ActionListener<Boolean>)ActionListener.wrap(isUpdated -> this.auditFilterChanges(job.getId(), filter.getId(), addedItems, removedItems), e -> {}));
                    continue;
                }
                this.auditFilterChanges(job.getId(), filter.getId(), addedItems, removedItems);
            }
            updatedListener.onResponse((Object)Boolean.TRUE);
        }), arg_0 -> updatedListener.onFailure(arg_0)));
    }

    private void auditFilterChanges(String jobId, String filterId, Set<String> addedItems, Set<String> removedItems) {
        StringBuilder auditMsg = new StringBuilder("Filter [");
        auditMsg.append(filterId);
        auditMsg.append("] has been modified; ");
        if (!addedItems.isEmpty()) {
            auditMsg.append("added items: ");
            JobManager.appendCommaSeparatedSet(addedItems, auditMsg);
            if (!removedItems.isEmpty()) {
                auditMsg.append(", ");
            }
        }
        if (!removedItems.isEmpty()) {
            auditMsg.append("removed items: ");
            JobManager.appendCommaSeparatedSet(removedItems, auditMsg);
        }
        this.auditor.info(jobId, auditMsg.toString());
    }

    private static void appendCommaSeparatedSet(Set<String> items, StringBuilder sb) {
        sb.append("[");
        Strings.collectionToDelimitedString(items, (String)", ", (String)"'", (String)"'", (StringBuilder)sb);
        sb.append("]");
    }

    public void updateProcessOnCalendarChanged(List<String> calendarJobIds, ActionListener<Boolean> updateListener) {
        ClusterState clusterState = this.clusterService.state();
        Set<String> openJobIds = this.openJobIds(clusterState);
        if (openJobIds.isEmpty()) {
            updateListener.onResponse((Object)Boolean.TRUE);
            return;
        }
        boolean appliesToAllJobs = calendarJobIds.stream().anyMatch("_all"::equals);
        if (appliesToAllJobs) {
            this.submitJobEventUpdate(openJobIds, updateListener);
            return;
        }
        this.jobConfigProvider.expandGroupIds(calendarJobIds, (ActionListener<SortedSet<String>>)ActionListener.wrap(expandedIds -> this.threadPool.executor("ml_utility").execute(() -> {
            expandedIds.addAll(calendarJobIds);
            openJobIds.retainAll((Collection<?>)expandedIds);
            this.submitJobEventUpdate(openJobIds, updateListener);
        }), arg_0 -> updateListener.onFailure(arg_0)));
    }

    private void submitJobEventUpdate(Collection<String> jobIds, ActionListener<Boolean> updateListener) {
        for (String jobId : jobIds) {
            this.updateJobProcessNotifier.submitJobUpdate(UpdateParams.scheduledEventsUpdate(jobId), (ActionListener<Boolean>)ActionListener.wrap(isUpdated -> this.auditor.info(jobId, Messages.getMessage((String)"Updated calendars in running process")), e -> logger.error("[" + jobId + "] failed submitting process update on calendar change", (Throwable)e)));
        }
        updateListener.onResponse((Object)Boolean.TRUE);
    }

    public void revertSnapshot(RevertModelSnapshotAction.Request request, ActionListener<RevertModelSnapshotAction.Response> actionListener, ModelSnapshot modelSnapshot) {
        ModelSizeStats modelSizeStats = modelSnapshot.getModelSizeStats();
        CheckedConsumer modelSizeStatsResponseHandler = response -> {
            if (modelSnapshot.getQuantiles() == null) {
                actionListener.onResponse((Object)new RevertModelSnapshotAction.Response(modelSnapshot));
                return;
            }
            this.jobResultsPersister.persistQuantiles(modelSnapshot.getQuantiles(), WriteRequest.RefreshPolicy.IMMEDIATE, (ActionListener<IndexResponse>)ActionListener.wrap(quantilesResponse -> {
                ModelSnapshot snapshotWithoutQuantiles = new ModelSnapshot.Builder(modelSnapshot).setQuantiles(null).build();
                actionListener.onResponse((Object)new RevertModelSnapshotAction.Response(snapshotWithoutQuantiles));
            }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
        };
        CheckedConsumer updateHandler = response -> {
            if (response.booleanValue()) {
                ModelSizeStats revertedModelSizeStats = new ModelSizeStats.Builder(modelSizeStats).setLogTime(new Date()).build();
                this.jobResultsPersister.persistModelSizeStats(revertedModelSizeStats, WriteRequest.RefreshPolicy.IMMEDIATE, (ActionListener<IndexResponse>)ActionListener.wrap((CheckedConsumer)modelSizeStatsResponseHandler, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
            }
        };
        JobUpdate update = new JobUpdate.Builder(request.getJobId()).setModelSnapshotId(modelSnapshot.getSnapshotId()).build();
        this.jobConfigProvider.updateJob(request.getJobId(), update, this.maxModelMemoryLimitSupplier.get(), (ActionListener<Job>)ActionListener.wrap(job -> {
            this.auditor.info(request.getJobId(), Messages.getMessage((String)"Job model snapshot reverted to ''{0}''", (Object[])new Object[]{modelSnapshot.getDescription()}));
            updateHandler.accept((Object)Boolean.TRUE);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    public void updateJobBlockReason(String jobId, Blocked blocked, ActionListener<PutJobAction.Response> listener) {
        this.jobConfigProvider.updateJobBlockReason(jobId, blocked, listener);
    }

    private /* synthetic */ void lambda$putJob$2(ClusterState state, PutJobAction.Request request, ActionListener putJobListener, Boolean indicesCreated) throws Exception {
        ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)state, (TimeValue)request.masterNodeTimeout(), (ActionListener)putJobListener);
    }
}

