/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.results;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.MlParserUtils;

public class PyTorchInferenceResult
implements ToXContentObject {
    private static final ParseField REQUEST_ID = new ParseField("request_id", new String[0]);
    private static final ParseField INFERENCE = new ParseField("inference", new String[0]);
    private static final ParseField ERROR = new ParseField("error", new String[0]);
    private static final ParseField TIME_MS = new ParseField("time_ms", new String[0]);
    public static final ConstructingObjectParser<PyTorchInferenceResult, Void> PARSER = new ConstructingObjectParser("pytorch_inference_result", a -> new PyTorchInferenceResult((String)a[0], (double[][][])a[1], (Long)a[2], (String)a[3]));
    private final String requestId;
    private final double[][][] inference;
    private final Long timeMs;
    private final String error;

    public static PyTorchInferenceResult fromXContent(XContentParser parser) throws IOException {
        return (PyTorchInferenceResult)PARSER.parse(parser, null);
    }

    public PyTorchInferenceResult(String requestId, @Nullable double[][][] inference, @Nullable Long timeMs, @Nullable String error) {
        this.requestId = Objects.requireNonNull(requestId);
        this.inference = inference;
        this.timeMs = timeMs;
        this.error = error;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public boolean isError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public double[][][] getInferenceResult() {
        return this.inference;
    }

    public Long getTimeMs() {
        return this.timeMs;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REQUEST_ID.getPreferredName(), this.requestId);
        if (this.inference != null) {
            builder.startArray(INFERENCE.getPreferredName());
            for (int i = 0; i < this.inference.length; ++i) {
                builder.startArray();
                for (int j = 0; j < this.inference[0].length; ++j) {
                    builder.startArray();
                    for (int k = 0; k < this.inference[0][0].length; ++k) {
                        builder.value(this.inference[i][j][k]);
                    }
                    builder.endArray();
                }
                builder.endArray();
            }
            builder.endArray();
        }
        if (this.timeMs != null) {
            builder.field(TIME_MS.getPreferredName(), this.timeMs);
        }
        if (this.error != null) {
            builder.field(ERROR.getPreferredName(), this.error);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.requestId, Arrays.deepHashCode((Object[])this.inference), this.error);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PyTorchInferenceResult that = (PyTorchInferenceResult)other;
        return Objects.equals(this.requestId, that.requestId) && Arrays.deepEquals((Object[])this.inference, (Object[])that.inference) && Objects.equals(this.error, that.error);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REQUEST_ID);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> MlParserUtils.parse3DArrayOfDoubles((String)INFERENCE.getPreferredName(), (XContentParser)p), INFERENCE, ObjectParser.ValueType.VALUE_ARRAY);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIME_MS);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ERROR);
    }
}

