/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.core.Nullable;

class TokenTrieNode {
    private static final String EMPTY_STRING = "";
    private final Map<String, TokenTrieNode> children;

    private TokenTrieNode(Map<String, TokenTrieNode> children) {
        this.children = Objects.requireNonNull(children);
    }

    boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Nullable
    TokenTrieNode getChild(String token) {
        return this.children.get(token);
    }

    private void insert(List<String> tokens) {
        int currentTokenIndex;
        if (tokens.isEmpty()) {
            return;
        }
        TokenTrieNode currentNode = this;
        for (currentTokenIndex = 0; currentTokenIndex < tokens.size() && currentNode.children.containsKey(tokens.get(currentTokenIndex)); ++currentTokenIndex) {
            currentNode = currentNode.getChild(tokens.get(currentTokenIndex));
        }
        while (currentTokenIndex < tokens.size()) {
            TokenTrieNode childNode = new TokenTrieNode(new HashMap<String, TokenTrieNode>());
            currentNode.children.put(tokens.get(currentTokenIndex), childNode);
            currentNode = childNode;
            ++currentTokenIndex;
        }
    }

    static TokenTrieNode build(Collection<String> tokens, Function<String, List<String>> tokenizeFunction) {
        TokenTrieNode root = new TokenTrieNode(new HashMap<String, TokenTrieNode>());
        for (String token : tokens) {
            List<String> subTokens = tokenizeFunction.apply(token);
            root.insert(subTokens);
        }
        return root;
    }
}

