/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DelimitedToken {
    private final int startPos;
    private final int endPos;
    private final String token;

    public static DelimitedToken mergeTokens(List<DelimitedToken> tokens) {
        if (tokens.size() == 1) {
            return tokens.get(0);
        }
        String merged = tokens.stream().map(DelimitedToken::getToken).collect(Collectors.joining());
        return new DelimitedToken(tokens.get(0).getStartPos(), tokens.get(tokens.size() - 1).getEndPos(), merged);
    }

    DelimitedToken(int startPos, int endPos, String token) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.token = token;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelimitedToken that = (DelimitedToken)o;
        return this.startPos == that.startPos && this.endPos == that.endPos && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.startPos, this.endPos, this.token);
    }

    public String toString() {
        return "{startPos=" + this.startPos + ", endPos=" + this.endPos + ", token=" + this.token + "}";
    }
}

