/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp;

import java.util.Locale;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.FillMaskConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NerConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PassThroughConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextEmbeddingConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ZeroShotClassificationConfig;
import org.elasticsearch.xpack.ml.inference.nlp.FillMaskProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.NerProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.NlpTask;
import org.elasticsearch.xpack.ml.inference.nlp.PassThroughProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.TextClassificationProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.TextEmbeddingProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.ZeroShotClassificationProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.NlpTokenizer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TaskType {
    NER{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new NerProcessor(tokenizer, (NerConfig)config);
        }
    }
    ,
    TEXT_CLASSIFICATION{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new TextClassificationProcessor(tokenizer, (TextClassificationConfig)config);
        }
    }
    ,
    FILL_MASK{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new FillMaskProcessor(tokenizer, (FillMaskConfig)config);
        }
    }
    ,
    PASS_THROUGH{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new PassThroughProcessor(tokenizer, (PassThroughConfig)config);
        }
    }
    ,
    TEXT_EMBEDDING{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new TextEmbeddingProcessor(tokenizer, (TextEmbeddingConfig)config);
        }
    }
    ,
    ZERO_SHOT_CLASSIFICATION{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new ZeroShotClassificationProcessor(tokenizer, (ZeroShotClassificationConfig)config);
        }
    };


    public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
        throw new UnsupportedOperationException("json request must be specialised for task type [" + this.name() + "]");
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static TaskType fromString(String name) {
        return TaskType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }
}

