/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.ml.inference.nlp.NlpTask;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.NlpTokenizer;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.TokenizationResult;

public class MPNetRequestBuilder
implements NlpTask.RequestBuilder {
    static final String REQUEST_ID = "request_id";
    static final String TOKENS = "tokens";
    static final String ARG1 = "arg_1";
    private final NlpTokenizer tokenizer;

    public MPNetRequestBuilder(NlpTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public NlpTask.Request buildRequest(List<String> inputs, String requestId, Tokenization.Truncate truncate) throws IOException {
        if (this.tokenizer.getPadTokenId().isEmpty()) {
            throw new IllegalStateException("The input tokenizer does not have a " + this.tokenizer.getPadToken() + " token in its vocabulary");
        }
        TokenizationResult tokenization = this.tokenizer.buildTokenizationResult(inputs.stream().map(s -> this.tokenizer.tokenize((String)s, truncate)).collect(Collectors.toList()));
        return this.buildRequest(tokenization, requestId);
    }

    @Override
    public NlpTask.Request buildRequest(TokenizationResult tokenization, String requestId) throws IOException {
        if (this.tokenizer.getPadTokenId().isEmpty()) {
            throw new IllegalStateException("The input tokenizer does not have a " + this.tokenizer.getPadToken() + " token in its vocabulary");
        }
        return new NlpTask.Request(tokenization, MPNetRequestBuilder.jsonRequest(tokenization, this.tokenizer.getPadTokenId().getAsInt(), requestId));
    }

    static BytesReference jsonRequest(TokenizationResult tokenization, int padToken, String requestId) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.field(REQUEST_ID, requestId);
        NlpTask.RequestBuilder.writePaddedTokens(TOKENS, tokenization, padToken, (tokens, i) -> tokens.getTokenIds()[i], builder);
        NlpTask.RequestBuilder.writePaddedTokens(ARG1, tokenization, padToken, (tokens, i) -> 1, builder);
        builder.endObject();
        return BytesReference.bytes((XContentBuilder)builder);
    }
}

