/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.steps;

import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

abstract class AbstractDataFrameAnalyticsStep
implements DataFrameAnalyticsStep {
    private static final Logger logger = LogManager.getLogger(AbstractDataFrameAnalyticsStep.class);
    protected final NodeClient client;
    protected final DataFrameAnalyticsTask task;
    protected final DataFrameAnalyticsAuditor auditor;
    protected final DataFrameAnalyticsConfig config;

    AbstractDataFrameAnalyticsStep(NodeClient client, DataFrameAnalyticsTask task, DataFrameAnalyticsAuditor auditor, DataFrameAnalyticsConfig config) {
        this.client = Objects.requireNonNull(client);
        this.task = Objects.requireNonNull(task);
        this.auditor = Objects.requireNonNull(auditor);
        this.config = Objects.requireNonNull(config);
    }

    protected boolean isTaskStopping() {
        return this.task.isStopping();
    }

    protected ParentTaskAssigningClient parentTaskClient() {
        return new ParentTaskAssigningClient((Client)this.client, this.task.getParentTaskId());
    }

    protected TaskId getParentTaskId() {
        return this.task.getParentTaskId();
    }

    @Override
    public final void execute(ActionListener<StepResponse> listener) {
        logger.debug(() -> new ParameterizedMessage("[{}] Executing step [{}]", (Object)this.config.getId(), (Object)this.name()));
        if (this.task.isStopping() && this.shouldSkipIfTaskIsStopping()) {
            logger.debug(() -> new ParameterizedMessage("[{}] task is stopping before starting [{}] step", (Object)this.config.getId(), (Object)this.name()));
            listener.onResponse((Object)new StepResponse(true));
            return;
        }
        this.doExecute((ActionListener<StepResponse>)ActionListener.wrap(stepResponse -> this.task.persistProgress(() -> listener.onResponse(stepResponse)), arg_0 -> listener.onFailure(arg_0)));
    }

    protected abstract void doExecute(ActionListener<StepResponse> var1);

    protected void refreshDestAsync(ActionListener<RefreshResponse> refreshListener) {
        ParentTaskAssigningClient parentTaskClient = this.parentTaskClient();
        ClientHelper.executeWithHeadersAsync((Map)this.config.getHeaders(), (String)"ml", (Client)parentTaskClient, (ActionType)RefreshAction.INSTANCE, (ActionRequest)new RefreshRequest(new String[]{this.config.getDest().getIndex()}), refreshListener);
    }

    protected boolean shouldSkipIfTaskIsStopping() {
        return true;
    }
}

