/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.extractor;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.FieldCardinalityConstraint;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;

public class ExtractedFieldsDetectorFactory {
    private static final Logger LOGGER = LogManager.getLogger(ExtractedFieldsDetectorFactory.class);
    private final Client client;

    public ExtractedFieldsDetectorFactory(Client client) {
        this.client = Objects.requireNonNull(client);
    }

    public void createFromSource(DataFrameAnalyticsConfig config, ActionListener<ExtractedFieldsDetector> listener) {
        this.create(config.getSource().getIndex(), config, listener);
    }

    public void createFromDest(DataFrameAnalyticsConfig config, ActionListener<ExtractedFieldsDetector> listener) {
        this.create(new String[]{config.getDest().getIndex()}, config, listener);
    }

    private void create(String[] index, DataFrameAnalyticsConfig config, ActionListener<ExtractedFieldsDetector> listener) {
        AtomicInteger docValueFieldsLimitHolder = new AtomicInteger();
        AtomicReference fieldCapsResponseHolder = new AtomicReference();
        ActionListener fieldCardinalitiesHandler = ActionListener.wrap(fieldCardinalities -> {
            ExtractedFieldsDetector detector = new ExtractedFieldsDetector(config, docValueFieldsLimitHolder.get(), (FieldCapabilitiesResponse)fieldCapsResponseHolder.get(), (Map<String, Long>)fieldCardinalities);
            listener.onResponse((Object)detector);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener fieldCapabilitiesHandler = ActionListener.wrap(fieldCapabilitiesResponse -> {
            LOGGER.debug(() -> new ParameterizedMessage("[{}] Field capabilities response: {}", (Object)config.getId(), fieldCapabilitiesResponse));
            fieldCapsResponseHolder.set(fieldCapabilitiesResponse);
            this.getCardinalitiesForFieldsWithConstraints(index, config, (FieldCapabilitiesResponse)fieldCapabilitiesResponse, (ActionListener<Map<String, Long>>)fieldCardinalitiesHandler);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener docValueFieldsLimitListener = ActionListener.wrap(docValueFieldsLimit -> {
            docValueFieldsLimitHolder.set((int)docValueFieldsLimit);
            this.getFieldCaps(index, config, (ActionListener<FieldCapabilitiesResponse>)fieldCapabilitiesHandler);
        }, arg_0 -> listener.onFailure(arg_0));
        this.getDocValueFieldsLimit(index, (ActionListener<Integer>)docValueFieldsLimitListener);
    }

    private void getCardinalitiesForFieldsWithConstraints(String[] index, DataFrameAnalyticsConfig config, FieldCapabilitiesResponse fieldCapabilitiesResponse, ActionListener<Map<String, Long>> listener) {
        List fieldCardinalityConstraints = config.getAnalysis().getFieldCardinalityConstraints();
        if (fieldCardinalityConstraints.isEmpty()) {
            listener.onResponse(Collections.emptyMap());
            return;
        }
        ActionListener searchListener = ActionListener.wrap(searchResponse -> this.buildFieldCardinalitiesMap(config, (SearchResponse)searchResponse, listener), arg_0 -> listener.onFailure(arg_0));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query(config.getSource().getParsedQuery()).runtimeMappings(config.getSource().getRuntimeMappings());
        for (FieldCardinalityConstraint constraint : fieldCardinalityConstraints) {
            Map fieldCapsPerType = fieldCapabilitiesResponse.getField(constraint.getField());
            if (fieldCapsPerType == null) {
                throw ExceptionsHelper.badRequestException((String)"no mappings could be found for field [{}]", (Object[])new Object[]{constraint.getField()});
            }
            for (FieldCapabilities fieldCaps : fieldCapsPerType.values()) {
                if (fieldCaps.isAggregatable()) continue;
                throw ExceptionsHelper.badRequestException((String)"field [{}] of type [{}] is non-aggregatable", (Object[])new Object[]{fieldCaps.getName(), fieldCaps.getType()});
            }
            searchSourceBuilder.aggregation((AggregationBuilder)((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)constraint.getField()).field(constraint.getField())).precisionThreshold(constraint.getUpperBound() + 1L));
        }
        SearchRequest searchRequest = new SearchRequest(index).source(searchSourceBuilder);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)searchListener);
    }

    private void buildFieldCardinalitiesMap(DataFrameAnalyticsConfig config, SearchResponse searchResponse, ActionListener<Map<String, Long>> listener) {
        Aggregations aggs = searchResponse.getAggregations();
        if (aggs == null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Unexpected null response when gathering field cardinalities")));
            return;
        }
        HashMap<String, Long> fieldCardinalities = new HashMap<String, Long>(config.getAnalysis().getFieldCardinalityConstraints().size());
        for (FieldCardinalityConstraint constraint : config.getAnalysis().getFieldCardinalityConstraints()) {
            Cardinality cardinality = (Cardinality)aggs.get(constraint.getField());
            if (cardinality == null) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Unexpected null response when gathering field cardinalities")));
                return;
            }
            fieldCardinalities.put(constraint.getField(), cardinality.getValue());
        }
        listener.onResponse(fieldCardinalities);
    }

    private void getFieldCaps(String[] index, DataFrameAnalyticsConfig config, ActionListener<FieldCapabilitiesResponse> listener) {
        FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest();
        fieldCapabilitiesRequest.indices(index);
        fieldCapabilitiesRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        fieldCapabilitiesRequest.fields(new String[]{"*"});
        fieldCapabilitiesRequest.runtimeFields(config.getSource().getRuntimeMappings());
        LOGGER.debug(() -> new ParameterizedMessage("[{}] Requesting field caps for index {}", (Object)config.getId(), (Object)Arrays.toString(index)));
        ClientHelper.executeWithHeaders((Map)config.getHeaders(), (String)"ml", (Client)this.client, () -> {
            this.client.execute((ActionType)FieldCapabilitiesAction.INSTANCE, (ActionRequest)fieldCapabilitiesRequest, listener);
            return null;
        });
    }

    private void getDocValueFieldsLimit(String[] index, ActionListener<Integer> docValueFieldsLimitListener) {
        ActionListener settingsListener = ActionListener.wrap(getSettingsResponse -> {
            Integer minDocValueFieldsLimit = Integer.MAX_VALUE;
            ImmutableOpenMap indexToSettings = getSettingsResponse.getIndexToSettings();
            for (ObjectObjectCursor indexSettings : indexToSettings) {
                Integer indexMaxDocValueFields = (Integer)IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.get((Settings)indexSettings.value);
                if (indexMaxDocValueFields >= minDocValueFieldsLimit) continue;
                minDocValueFieldsLimit = indexMaxDocValueFields;
            }
            docValueFieldsLimitListener.onResponse((Object)minDocValueFieldsLimit);
        }, e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                docValueFieldsLimitListener.onFailure((Exception)((Object)new ResourceNotFoundException("cannot retrieve data because index " + ((IndexNotFoundException)cause).getIndex() + " does not exist", new Object[0])));
            } else {
                docValueFieldsLimitListener.onFailure(e);
            }
        });
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest();
        getSettingsRequest.indices(index);
        getSettingsRequest.includeDefaults(true);
        getSettingsRequest.names(new String[]{IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey()});
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, (ActionListener)settingsListener);
    }
}

