/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.license.LicensedAllocatedPersistentTask;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.StoredProgress;
import org.elasticsearch.xpack.ml.dataframe.stats.StatsHolder;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.persistence.MlParserUtils;

public class DataFrameAnalyticsTask
extends LicensedAllocatedPersistentTask
implements StartDataFrameAnalyticsAction.TaskMatcher {
    private static final Logger LOGGER = LogManager.getLogger(DataFrameAnalyticsTask.class);
    private final Client client;
    private final DataFrameAnalyticsManager analyticsManager;
    private final DataFrameAnalyticsAuditor auditor;
    private final StartDataFrameAnalyticsAction.TaskParams taskParams;
    private volatile boolean isStopping;
    private volatile boolean isMarkAsCompletedCalled;
    private volatile StatsHolder statsHolder;
    private volatile DataFrameAnalyticsStep currentStep;

    public DataFrameAnalyticsTask(long id, String type, String action, TaskId parentTask, Map<String, String> headers, Client client, DataFrameAnalyticsManager analyticsManager, DataFrameAnalyticsAuditor auditor, StartDataFrameAnalyticsAction.TaskParams taskParams, XPackLicenseState licenseState) {
        super(id, type, action, "data_frame_analytics-" + taskParams.getId(), parentTask, headers, MachineLearning.ML_ANALYTICS_JOBS_FEATURE, "data_frame_analytics-" + taskParams.getId(), licenseState);
        this.client = new ParentTaskAssigningClient(Objects.requireNonNull(client), parentTask);
        this.analyticsManager = Objects.requireNonNull(analyticsManager);
        this.auditor = Objects.requireNonNull(auditor);
        this.taskParams = Objects.requireNonNull(taskParams);
    }

    public void setStep(DataFrameAnalyticsStep step) {
        this.currentStep = step;
    }

    public StartDataFrameAnalyticsAction.TaskParams getParams() {
        return this.taskParams;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public void setStatsHolder(StatsHolder statsHolder) {
        this.statsHolder = Objects.requireNonNull(statsHolder);
    }

    @Nullable
    public StatsHolder getStatsHolder() {
        return this.statsHolder;
    }

    protected void onCancelled() {
        this.stop(this.getReasonCancelled(), StopDataFrameAnalyticsAction.DEFAULT_TIMEOUT);
        this.markAsCompleted();
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMarkAsCompleted() {
        DataFrameAnalyticsTask dataFrameAnalyticsTask = this;
        synchronized (dataFrameAnalyticsTask) {
            if (this.isMarkAsCompletedCalled) {
                return;
            }
            this.isMarkAsCompletedCalled = true;
        }
        this.persistProgress(this.client, this.taskParams.getId(), () -> super.doMarkAsCompleted());
    }

    public void doMarkAsFailed(Exception e) {
        this.persistProgress(this.client, this.taskParams.getId(), () -> super.doMarkAsFailed(e));
    }

    public void stop(String reason, TimeValue timeout) {
        this.isStopping = true;
        LOGGER.debug(() -> new ParameterizedMessage("[{}] Stopping task due to reason [{}]", (Object)this.getParams().getId(), (Object)reason));
        DataFrameAnalyticsStep cachedCurrentStep = this.currentStep;
        ActionListener stepProgressListener = ActionListener.wrap(aVoid -> cachedCurrentStep.cancel(reason, timeout), e -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] Error updating progress for step [{}]", (Object)this.taskParams.getId(), (Object)cachedCurrentStep.name()), (Throwable)e);
            cachedCurrentStep.cancel(reason, timeout);
        });
        if (cachedCurrentStep != null) {
            cachedCurrentStep.updateProgress((ActionListener<Void>)stepProgressListener);
        }
    }

    public void setFailed(Exception error) {
        if (this.analyticsManager.isNodeShuttingDown()) {
            LOGGER.warn((Message)new ParameterizedMessage("[{}] *Not* setting task to failed because the node is being shutdown", (Object)this.taskParams.getId()), (Throwable)error);
            return;
        }
        this.persistProgress(this.client, this.taskParams.getId(), () -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] Setting task to failed", (Object)this.taskParams.getId()), (Throwable)error);
            String reason = ExceptionsHelper.unwrapCause((Throwable)error).getMessage();
            DataFrameAnalyticsTaskState newTaskState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.FAILED, this.getAllocationId(), reason);
            this.updatePersistentTaskState((PersistentTaskState)newTaskState, ActionListener.wrap(updatedTask -> {
                String message = Messages.getMessage((String)"Updated analytics task state to [{0}] with reason [{1}]", (Object[])new Object[]{DataFrameAnalyticsState.FAILED, reason});
                this.auditor.info(this.getParams().getId(), message);
                LOGGER.info("[{}] {}", (Object)this.getParams().getId(), (Object)message);
            }, e -> LOGGER.error((Message)new ParameterizedMessage("[{}] Could not update task state to [{}] with reason [{}]", new Object[]{this.getParams().getId(), DataFrameAnalyticsState.FAILED, reason}), (Throwable)e)));
        });
    }

    public void persistProgress(Runnable runnable) {
        this.persistProgress(this.client, this.taskParams.getId(), runnable);
    }

    void persistProgress(Client clientToUse, String jobId, Runnable runnable) {
        LOGGER.debug("[{}] Persisting progress", (Object)jobId);
        SetOnce storedProgress = new SetOnce();
        String progressDocId = StoredProgress.documentId(jobId);
        ActionListener indexProgressDocListener = ActionListener.wrap(indexResponse -> {
            LOGGER.debug("[{}] Successfully indexed progress document: {}", (Object)jobId, ((StoredProgress)storedProgress.get()).get());
            runnable.run();
        }, indexError -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while indexing", (Object)jobId), (Throwable)indexError);
            runnable.run();
        });
        ActionListener searchFormerProgressDocListener = ActionListener.wrap(searchResponse -> {
            String indexOrAlias = AnomalyDetectorsIndex.jobStateIndexWriteAlias();
            StoredProgress previous = null;
            if (searchResponse.getHits().getHits().length > 0) {
                indexOrAlias = searchResponse.getHits().getHits()[0].getIndex();
                try {
                    previous = (StoredProgress)MlParserUtils.parse(searchResponse.getHits().getHits()[0], StoredProgress.PARSER);
                }
                catch (Exception ex) {
                    LOGGER.warn((Message)new ParameterizedMessage("[{}] failed to parse previously stored progress", (Object)jobId), (Throwable)ex);
                }
            }
            List<PhaseProgress> progress = this.statsHolder.getProgressTracker().report();
            storedProgress.set((Object)new StoredProgress(progress));
            if (((StoredProgress)storedProgress.get()).equals(previous)) {
                LOGGER.debug(() -> new ParameterizedMessage("[{}] new progress is the same as previously persisted progress. Skipping storage of progress: {}", (Object)jobId, (Object)progress));
                runnable.run();
                return;
            }
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(indexOrAlias).id(progressDocId).setRequireAlias(AnomalyDetectorsIndex.jobStateIndexWriteAlias().equals(indexOrAlias)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            try (XContentBuilder jsonBuilder = JsonXContent.contentBuilder();){
                LOGGER.debug(() -> new ParameterizedMessage("[{}] Persisting progress is: {}", (Object)jobId, (Object)progress));
                ((StoredProgress)storedProgress.get()).toXContent(jsonBuilder, Payload.XContent.EMPTY_PARAMS);
                indexRequest.source(jsonBuilder);
            }
            ClientHelper.executeAsyncWithOrigin((Client)clientToUse, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)indexProgressDocListener);
        }, e -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while retrieving former progress document", (Object)jobId), (Throwable)e);
            runnable.run();
        });
        ActionListener stepProgressUpdateListener = ActionListener.wrap(aVoid -> {
            SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).source(new SearchSourceBuilder().size(1).query((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{progressDocId})));
            ClientHelper.executeAsyncWithOrigin((Client)clientToUse, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)searchFormerProgressDocListener);
        }, e -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while updating task progress", (Object)this.taskParams.getId()), (Throwable)e);
            runnable.run();
        });
        this.updateTaskProgress((ActionListener<Void>)stepProgressUpdateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskProgress(ActionListener<Void> updateProgressListener) {
        DataFrameAnalyticsTask dataFrameAnalyticsTask = this;
        synchronized (dataFrameAnalyticsTask) {
            if (this.currentStep != null) {
                this.currentStep.updateProgress(updateProgressListener);
            } else {
                updateProgressListener.onResponse(null);
            }
        }
    }

    public StartingState determineStartingState() {
        return DataFrameAnalyticsTask.determineStartingState(this.taskParams.getId(), this.statsHolder.getProgressTracker().report());
    }

    public static StartingState determineStartingState(String jobId, List<PhaseProgress> progressOnStart) {
        PhaseProgress lastIncompletePhase = null;
        for (PhaseProgress phaseProgress : progressOnStart) {
            if (phaseProgress.getProgressPercent() >= 100) continue;
            lastIncompletePhase = phaseProgress;
            break;
        }
        if (lastIncompletePhase == null) {
            return StartingState.FINISHED;
        }
        LOGGER.debug("[{}] Last incomplete progress [{}, {}]", (Object)jobId, (Object)lastIncompletePhase.getPhase(), (Object)lastIncompletePhase.getProgressPercent());
        if ("reindexing".equals(lastIncompletePhase.getPhase())) {
            return lastIncompletePhase.getProgressPercent() == 0 ? StartingState.FIRST_TIME : StartingState.RESUMING_REINDEXING;
        }
        if ("inference".equals(lastIncompletePhase.getPhase())) {
            return StartingState.RESUMING_INFERENCE;
        }
        return StartingState.RESUMING_ANALYZING;
    }

    public static enum StartingState {
        FIRST_TIME,
        RESUMING_REINDEXING,
        RESUMING_ANALYZING,
        RESUMING_INFERENCE,
        FINISHED;

    }
}

