/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public class NativeMemoryCapacity {
    static final NativeMemoryCapacity ZERO = new NativeMemoryCapacity(0L, 0L);
    private final long tierMlNativeMemoryRequirement;
    private final long nodeMlNativeMemoryRequirement;
    private final Long jvmSize;

    static NativeMemoryCapacity from(NativeMemoryCapacity capacity) {
        return new NativeMemoryCapacity(capacity.tierMlNativeMemoryRequirement, capacity.nodeMlNativeMemoryRequirement, capacity.jvmSize);
    }

    public NativeMemoryCapacity(long tierMlNativeMemoryRequirement, long nodeMlNativeMemoryRequirement, Long jvmSize) {
        this.tierMlNativeMemoryRequirement = tierMlNativeMemoryRequirement;
        this.nodeMlNativeMemoryRequirement = nodeMlNativeMemoryRequirement;
        this.jvmSize = jvmSize;
    }

    NativeMemoryCapacity(long tierMlNativeMemoryRequirement, long nodeMlNativeMemoryRequirement) {
        this.tierMlNativeMemoryRequirement = tierMlNativeMemoryRequirement;
        this.nodeMlNativeMemoryRequirement = nodeMlNativeMemoryRequirement;
        this.jvmSize = null;
    }

    NativeMemoryCapacity merge(NativeMemoryCapacity nativeMemoryCapacity) {
        if (this == nativeMemoryCapacity) {
            return this;
        }
        long tier = this.tierMlNativeMemoryRequirement + nativeMemoryCapacity.tierMlNativeMemoryRequirement;
        long node = Math.max(nativeMemoryCapacity.nodeMlNativeMemoryRequirement, this.nodeMlNativeMemoryRequirement);
        Long jvmSize = nativeMemoryCapacity.nodeMlNativeMemoryRequirement > this.nodeMlNativeMemoryRequirement ? null : this.jvmSize;
        return new NativeMemoryCapacity(tier, node, jvmSize);
    }

    public AutoscalingCapacity autoscalingCapacity(int maxMemoryPercent, boolean useAuto) {
        Long jvmSize = useAuto ? Optional.ofNullable(this.jvmSize).orElse(NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNativeMemorySize(this.nodeMlNativeMemoryRequirement)) : null;
        long requiredNodeSize = NativeMemoryCalculator.calculateApproxNecessaryNodeSize(this.nodeMlNativeMemoryRequirement, jvmSize, maxMemoryPercent, useAuto);
        double memoryPercentForMl = NativeMemoryCalculator.modelMemoryPercent(requiredNodeSize, jvmSize, maxMemoryPercent, useAuto);
        double inverseScale = memoryPercentForMl <= 0.0 ? 0.0 : 100.0 / memoryPercentForMl;
        long requiredTierSize = Math.round(Math.ceil((double)this.tierMlNativeMemoryRequirement * inverseScale));
        return new AutoscalingCapacity(new AutoscalingCapacity.AutoscalingResources(null, ByteSizeValue.ofBytes((long)Math.max(requiredTierSize, requiredNodeSize))), new AutoscalingCapacity.AutoscalingResources(null, ByteSizeValue.ofBytes((long)requiredNodeSize)));
    }

    public long getTierMlNativeMemoryRequirement() {
        return this.tierMlNativeMemoryRequirement;
    }

    public long getNodeMlNativeMemoryRequirement() {
        return this.nodeMlNativeMemoryRequirement;
    }

    public Long getJvmSize() {
        return this.jvmSize;
    }

    public String toString() {
        return "NativeMemoryCapacity{total ML native bytes=" + ByteSizeValue.ofBytes((long)this.tierMlNativeMemoryRequirement) + ", largest node ML native bytes=" + ByteSizeValue.ofBytes((long)this.nodeMlNativeMemoryRequirement) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeMemoryCapacity that = (NativeMemoryCapacity)o;
        return this.tierMlNativeMemoryRequirement == that.tierMlNativeMemoryRequirement && this.nodeMlNativeMemoryRequirement == that.nodeMlNativeMemoryRequirement && Objects.equals(this.jvmSize, that.jvmSize);
    }

    public int hashCode() {
        return Objects.hash(this.tierMlNativeMemoryRequirement, this.nodeMlNativeMemoryRequirement, this.jvmSize);
    }
}

