/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.TreeSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.UpdateFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportUpdateFilterAction
extends HandledTransportAction<UpdateFilterAction.Request, PutFilterAction.Response> {
    private final Client client;
    private final JobManager jobManager;

    @Inject
    public TransportUpdateFilterAction(TransportService transportService, ActionFilters actionFilters, Client client, JobManager jobManager, ClusterService clusterService) {
        super("cluster:admin/xpack/ml/filters/update", transportService, actionFilters, UpdateFilterAction.Request::new);
        this.client = client;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, UpdateFilterAction.Request request, ActionListener<PutFilterAction.Response> listener) {
        ActionListener filterListener = ActionListener.wrap(filterWithVersion -> this.updateFilter((FilterWithSeqNo)filterWithVersion, request, listener), arg_0 -> listener.onFailure(arg_0));
        this.getFilterWithVersion(request.getFilterId(), (ActionListener<FilterWithSeqNo>)filterListener);
    }

    private void updateFilter(FilterWithSeqNo filterWithVersion, UpdateFilterAction.Request request, ActionListener<PutFilterAction.Response> listener) {
        MlFilter filter = filterWithVersion.filter;
        if (request.isNoop()) {
            listener.onResponse((Object)new PutFilterAction.Response(filter));
            return;
        }
        String description = request.getDescription() == null ? filter.getDescription() : request.getDescription();
        TreeSet items = new TreeSet(filter.getItems());
        items.addAll(request.getAddItems());
        for (String toRemove : request.getRemoveItems()) {
            boolean wasPresent = items.remove(toRemove);
            if (wasPresent) continue;
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Cannot remove item [" + toRemove + "] as it is not present in filter [" + filter.getId() + "]"), (Object[])new Object[0]));
            return;
        }
        MlFilter updatedFilter = MlFilter.builder((String)filter.getId()).setDescription(description).setItems(items).build();
        this.indexUpdatedFilter(updatedFilter, filterWithVersion.seqNo, filterWithVersion.primaryTerm, request, listener);
    }

    private void indexUpdatedFilter(final MlFilter filter, long seqNo, long primaryTerm, final UpdateFilterAction.Request request, final ActionListener<PutFilterAction.Response> listener) {
        IndexRequest indexRequest = new IndexRequest(MlMetaIndex.indexName()).id(filter.documentId());
        indexRequest.setIfSeqNo(seqNo);
        indexRequest.setIfPrimaryTerm(primaryTerm);
        indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true"));
            indexRequest.source(filter.toXContent(builder, (ToXContent.Params)params));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialise filter with id [" + filter.getId() + "]", e);
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                TransportUpdateFilterAction.this.jobManager.notifyFilterChanged(filter, request.getAddItems(), request.getRemoveItems(), (ActionListener<Boolean>)ActionListener.wrap(response -> listener.onResponse((Object)new PutFilterAction.Response(filter)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }

            public void onFailure(Exception e) {
                ElasticsearchException reportedException = ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException ? ExceptionsHelper.conflictStatusException((String)("Error updating filter with id [" + filter.getId() + "] because it was modified while the update was in progress"), (Throwable)e, (Object[])new Object[0]) : ExceptionsHelper.serverError((String)("Error updating filter with id [" + filter.getId() + "]"), (Throwable)e);
                listener.onFailure((Exception)((Object)reportedException));
            }
        });
    }

    private void getFilterWithVersion(String filterId, ActionListener<FilterWithSeqNo> listener) {
        GetRequest getRequest = new GetRequest(MlMetaIndex.indexName(), MlFilter.documentId((String)filterId));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)listener.delegateFailure((l, getDocResponse) -> {
            block15: {
                try {
                    if (getDocResponse.isExists()) {
                        BytesReference docSource = getDocResponse.getSourceAsBytesRef();
                        try (StreamInput stream = docSource.streamInput();
                             XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                            MlFilter filter = ((MlFilter.Builder)MlFilter.LENIENT_PARSER.apply(parser, null)).build();
                            l.onResponse((Object)new FilterWithSeqNo(filter, (GetResponse)getDocResponse));
                            break block15;
                        }
                    }
                    l.onFailure((Exception)new ResourceNotFoundException(Messages.getMessage((String)"No filter with id [{0}] exists", (Object[])new Object[]{filterId}), new Object[0]));
                }
                catch (Exception e) {
                    l.onFailure(e);
                }
            }
        }));
    }

    private static class FilterWithSeqNo {
        private final MlFilter filter;
        private final long seqNo;
        private final long primaryTerm;

        private FilterWithSeqNo(MlFilter filter, GetResponse getDocResponse) {
            this.filter = filter;
            this.seqNo = getDocResponse.getSeqNo();
            this.primaryTerm = getDocResponse.getPrimaryTerm();
        }
    }
}

