/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskAction;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskResult;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.ResetJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class TransportResetJobAction
extends AcknowledgedTransportMasterNodeAction<ResetJobAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportResetJobAction.class);
    private final Client client;
    private final JobConfigProvider jobConfigProvider;
    private final JobResultsProvider jobResultsProvider;
    private final AnomalyDetectionAuditor auditor;

    @Inject
    public TransportResetJobAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobConfigProvider jobConfigProvider, JobResultsProvider jobResultsProvider, AnomalyDetectionAuditor auditor) {
        super("cluster:admin/xpack/ml/job/reset", transportService, clusterService, threadPool, actionFilters, ResetJobAction.Request::new, indexNameExpressionResolver, "same");
        this.client = Objects.requireNonNull(client);
        this.jobConfigProvider = Objects.requireNonNull(jobConfigProvider);
        this.jobResultsProvider = Objects.requireNonNull(jobResultsProvider);
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void masterOperation(Task task, ResetJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (MlMetadata.getMlMetadata((ClusterState)state).isUpgradeMode()) {
            listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)"cannot reset job while indices are being upgraded", (Object[])new Object[0]));
            return;
        }
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ActionListener jobListener = ActionListener.wrap(jobBuilder -> {
            Job job = jobBuilder.build();
            PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
            JobState jobState = MlTasks.getJobState((String)job.getId(), (PersistentTasksCustomMetadata)tasks);
            if (!request.isSkipJobStateValidation() && jobState != JobState.CLOSED) {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Can only reset a job when it is closed."), (Object[])new Object[0]));
                return;
            }
            if (job.getBlocked().getReason() != Blocked.Reason.NONE && job.getBlocked().getReason() != Blocked.Reason.RESET) {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("cannot reset job while it is blocked with [" + job.getBlocked().getReason() + "]"), (Object[])new Object[0]));
                return;
            }
            if (job.getBlocked().getReason() == Blocked.Reason.RESET) {
                this.waitExistingResetTaskToComplete(job.getBlocked().getTaskId(), request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> this.resetIfJobIsStillBlockedOnReset(task, request, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                ParentTaskAssigningClient taskClient = new ParentTaskAssigningClient(this.client, taskId);
                this.jobConfigProvider.updateJobBlockReason(job.getId(), new Blocked(Blocked.Reason.RESET, taskId), (ActionListener<PutJobAction.Response>)ActionListener.wrap(r -> this.resetJob(taskClient, (CancellableTask)task, request, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobConfigProvider.getJob(request.getJobId(), (ActionListener<Job.Builder>)jobListener);
    }

    private void waitExistingResetTaskToComplete(TaskId existingTaskId, ResetJobAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        logger.debug(() -> new ParameterizedMessage("[{}] Waiting on existing reset task: {}", (Object)request.getJobId(), (Object)existingTaskId));
        GetTaskRequest getTaskRequest = new GetTaskRequest();
        getTaskRequest.setTaskId(existingTaskId);
        getTaskRequest.setWaitForCompletion(true);
        getTaskRequest.setTimeout(request.timeout());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetTaskAction.INSTANCE, (ActionRequest)getTaskRequest, (ActionListener)ActionListener.wrap(getTaskResponse -> {
            TaskResult taskResult = getTaskResponse.getTask();
            if (taskResult.isCompleted()) {
                listener.onResponse((Object)AcknowledgedResponse.of((boolean)true));
            } else {
                BytesReference taskError = taskResult.getError();
                if (taskError != null) {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"reset failed to complete; error [{}]", (Object[])new Object[]{taskError.utf8ToString()})));
                } else {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"reset failed to complete")));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void resetIfJobIsStillBlockedOnReset(Task task, ResetJobAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        ActionListener jobListener = ActionListener.wrap(jobResponse -> {
            Job job = jobResponse.build();
            if (job.getBlocked().getReason() == Blocked.Reason.NONE) {
                logger.debug(() -> new ParameterizedMessage("[{}] Existing reset task finished successfully", (Object)request.getJobId()));
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else if (job.getBlocked().getReason() == Blocked.Reason.RESET) {
                logger.debug(() -> new ParameterizedMessage("[{}] Existing reset task was interrupted; retrying reset", (Object)request.getJobId()));
                ParentTaskAssigningClient taskClient = new ParentTaskAssigningClient(this.client, new TaskId(this.clusterService.localNode().getId(), task.getId()));
                this.resetJob(taskClient, (CancellableTask)task, request, listener);
            } else {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("cannot reset job while it is blocked with [" + job.getBlocked().getReason() + "]"), (Object[])new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobConfigProvider.getJob(request.getJobId(), (ActionListener<Job.Builder>)jobListener);
    }

    private void resetJob(ParentTaskAssigningClient taskClient, CancellableTask task, ResetJobAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)this.clusterService.state().getMetadata().custom("persistent_tasks");
        JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (!request.isSkipJobStateValidation() && jobState != JobState.CLOSED) {
            this.jobConfigProvider.updateJobBlockReason(jobId, null, (ActionListener<PutJobAction.Response>)ActionListener.wrap(clearResetResponse -> listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Can only reset a job when it is closed."), (Object[])new Object[0])), e -> listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Can only reset a job when it is closed."), (Object[])new Object[0]))));
            return;
        }
        logger.info("[{}] Resetting job", (Object)jobId);
        ActionListener resultsIndexCreatedListener = ActionListener.wrap(resultsIndexCreatedResponse -> {
            if (task.isCancelled()) {
                listener.onResponse((Object)AcknowledgedResponse.of((boolean)false));
                return;
            }
            this.finishSuccessfulReset(jobId, listener);
        }, arg_0 -> listener.onFailure(arg_0));
        CheckedConsumer jobDocsDeletionListener = response -> {
            if (task.isCancelled()) {
                listener.onResponse((Object)AcknowledgedResponse.of((boolean)false));
                return;
            }
            this.jobConfigProvider.getJob(jobId, (ActionListener<Job.Builder>)ActionListener.wrap(jobBuilder -> {
                if (task.isCancelled()) {
                    listener.onResponse((Object)AcknowledgedResponse.of((boolean)false));
                    return;
                }
                this.jobResultsProvider.createJobResultIndex(jobBuilder.build(), this.clusterService.state(), (ActionListener<Boolean>)resultsIndexCreatedListener);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        };
        JobDataDeleter jobDataDeleter = new JobDataDeleter((Client)taskClient, jobId);
        jobDataDeleter.deleteJobDocuments(this.jobConfigProvider, this.indexNameExpressionResolver, this.clusterService.state(), (CheckedConsumer<Boolean, Exception>)jobDocsDeletionListener, arg_0 -> listener.onFailure(arg_0));
    }

    private void finishSuccessfulReset(String jobId, ActionListener<AcknowledgedResponse> listener) {
        this.jobConfigProvider.updateJobAfterReset(jobId, (ActionListener<PutJobAction.Response>)ActionListener.wrap(blockReasonUpdatedResponse -> {
            logger.info("[{}] Reset has successfully completed", (Object)jobId);
            this.auditor.info(jobId, Messages.getMessage((String)"Job has been reset"));
            listener.onResponse((Object)AcknowledgedResponse.of((boolean)true));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(ResetJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

