/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;

public class TransportPutTrainedModelAction
extends TransportMasterNodeAction<PutTrainedModelAction.Request, PutTrainedModelAction.Response> {
    private static final ByteSizeValue MAX_NATIVE_DEFINITION_INDEX_SIZE = ByteSizeValue.ofGb((long)50L);
    private final TrainedModelProvider trainedModelProvider;
    private final XPackLicenseState licenseState;
    private final NamedXContentRegistry xContentRegistry;
    private final OriginSettingClient client;

    @Inject
    public TransportPutTrainedModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, TrainedModelProvider trainedModelProvider, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/inference/put", transportService, clusterService, threadPool, actionFilters, PutTrainedModelAction.Request::new, indexNameExpressionResolver, PutTrainedModelAction.Response::new, "same");
        this.licenseState = licenseState;
        this.trainedModelProvider = trainedModelProvider;
        this.xContentRegistry = xContentRegistry;
        this.client = new OriginSettingClient(client, "ml");
    }

    protected void masterOperation(Task task, PutTrainedModelAction.Request request, ClusterState state, ActionListener<PutTrainedModelAction.Response> listener) {
        boolean hasModelDefinition;
        TrainedModelConfig config = request.getTrainedModelConfig();
        try {
            if (!request.isDeferDefinitionDecompression()) {
                config.ensureParsedDefinition(this.xContentRegistry);
            }
        }
        catch (IOException ex) {
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Failed to parse definition for [{}]", (Throwable)ex, (Object[])new Object[]{config.getModelId()}));
            return;
        }
        boolean bl = hasModelDefinition = config.getModelDefinition() != null;
        if (hasModelDefinition) {
            try {
                config.getModelDefinition().getTrainedModel().validate();
            }
            catch (ElasticsearchException ex) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Definition for [{}] has validation failures.", (Throwable)ex, (Object[])new Object[]{config.getModelId()}));
                return;
            }
            TrainedModelType trainedModelType = TrainedModelType.typeFromTrainedModel((TrainedModel)config.getModelDefinition().getTrainedModel());
            if (trainedModelType == null) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Unknown trained model definition class [{}]", (Object[])new Object[]{config.getModelDefinition().getTrainedModel().getName()}));
                return;
            }
            if (config.getModelType() == null) {
                config = new TrainedModelConfig.Builder(config).setModelType(trainedModelType).build();
            } else if (trainedModelType != config.getModelType()) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"{} [{}] does not match the model definition type [{}]", (Object[])new Object[]{TrainedModelConfig.MODEL_TYPE.getPreferredName(), config.getModelType(), trainedModelType}));
                return;
            }
            if (!config.getInferenceConfig().isTargetTypeSupported(config.getModelDefinition().getTrainedModel().targetType())) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Model [{}] inference config type [{}] does not support definition target type [{}]", (Object[])new Object[]{config.getModelId(), config.getInferenceConfig().getName(), config.getModelDefinition().getTrainedModel().targetType()}));
                return;
            }
            Version minCompatibilityVersion = config.getModelDefinition().getTrainedModel().getMinimalCompatibilityVersion();
            if (state.nodes().getMinNodeVersion().before(minCompatibilityVersion)) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Definition for [{}] requires that all nodes are at least version [{}]", (Object[])new Object[]{config.getModelId(), minCompatibilityVersion.toString()}));
                return;
            }
        }
        TrainedModelConfig.Builder trainedModelConfig = new TrainedModelConfig.Builder(config).setVersion(Version.CURRENT).setCreateTime(Instant.now()).setCreatedBy("api_user").setLicenseLevel(License.OperationMode.PLATINUM.description());
        if (hasModelDefinition) {
            trainedModelConfig.setModelSize(config.getModelDefinition().ramBytesUsed()).setEstimatedOperations(config.getModelDefinition().getTrainedModel().estimatedNumOperations());
        } else {
            trainedModelConfig.setLocation(Optional.ofNullable(config.getModelType()).orElse(TrainedModelType.TREE_ENSEMBLE).getDefaultLocation(config.getModelId()));
        }
        if (ModelAliasMetadata.fromState(state).getModelId(trainedModelConfig.getModelId()) != null) {
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"requested model_id [{}] is the same as an existing model_alias. Model model_aliases and ids must be unique", (Object[])new Object[]{config.getModelId()}));
            return;
        }
        ActionListener checkStorageIndexSizeListener = ActionListener.wrap(r -> this.trainedModelProvider.storeTrainedModel(trainedModelConfig.build(), (ActionListener<Boolean>)ActionListener.wrap(bool -> {
            TrainedModelConfig configToReturn = trainedModelConfig.clearDefinition().build();
            listener.onResponse((Object)new PutTrainedModelAction.Response(configToReturn));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        ActionListener tagsModelIdCheckListener = ActionListener.wrap(r -> {
            if (TrainedModelType.PYTORCH.equals((Object)trainedModelConfig.getModelType())) {
                this.client.admin().indices().prepareStats(new String[]{InferenceIndexConstants.nativeDefinitionStore()}).clear().setStore(true).execute(ActionListener.wrap(stats -> {
                    IndexStats indexStats = (IndexStats)stats.getIndices().get(InferenceIndexConstants.nativeDefinitionStore());
                    if (indexStats == null) {
                        checkStorageIndexSizeListener.onResponse(null);
                        return;
                    }
                    if (indexStats.getTotal().getStore().getSizeInBytes() > MAX_NATIVE_DEFINITION_INDEX_SIZE.getBytes()) {
                        listener.onFailure((Exception)new ElasticsearchStatusException("Native model store has exceeded the maximum acceptable size of {}, please delete older unused pytorch models", RestStatus.CONFLICT, new Object[]{MAX_NATIVE_DEFINITION_INDEX_SIZE.toString()}));
                        return;
                    }
                    checkStorageIndexSizeListener.onResponse(null);
                }, e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        checkStorageIndexSizeListener.onResponse(null);
                        return;
                    }
                    listener.onFailure((Exception)new ElasticsearchStatusException("Unable to calculate stats for definition storage index [{}], please try again later", RestStatus.SERVICE_UNAVAILABLE, (Throwable)e, new Object[]{InferenceIndexConstants.nativeDefinitionStore()}));
                }));
                return;
            }
            checkStorageIndexSizeListener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener modelIdTagCheckListener = ActionListener.wrap(r -> this.checkTagsAgainstModelIds(request.getTrainedModelConfig().getTags(), (ActionListener<Void>)tagsModelIdCheckListener), arg_0 -> listener.onFailure(arg_0));
        this.checkModelIdAgainstTags(config.getModelId(), (ActionListener<Void>)modelIdTagCheckListener);
    }

    private void checkModelIdAgainstTags(String modelId, ActionListener<Void> listener) {
        ConstantScoreQueryBuilder builder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelConfig.TAGS.getPreferredName(), (String)modelId)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)builder).size(0).trackTotalHitsUpTo(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"}).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getHits().getTotalHits().value > 0L) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"The provided model_id {0} must not match existing tags.", (Object[])new Object[]{modelId}), (Object[])new Object[0]));
                return;
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((OriginSettingClient)this.client).search(arg_0, arg_1));
    }

    private void checkTagsAgainstModelIds(List<String> tags, ActionListener<Void> listener) {
        if (tags.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        ConstantScoreQueryBuilder builder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), tags)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)builder).size(0).trackTotalHitsUpTo(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"}).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getHits().getTotalHits().value > 0L) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"The provided tags {0} must not match existing model_ids.", (Object[])new Object[]{tags}), (Object[])new Object[0]));
                return;
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((OriginSettingClient)this.client).search(arg_0, arg_1));
    }

    protected ClusterBlockException checkBlock(PutTrainedModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void doExecute(Task task, PutTrainedModelAction.Request request, ActionListener<PutTrainedModelAction.Response> listener) {
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

