/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;

public class TransportGetTrainedModelsAction
extends HandledTransportAction<GetTrainedModelsAction.Request, GetTrainedModelsAction.Response> {
    private final TrainedModelProvider provider;
    private final ClusterService clusterService;

    @Inject
    public TransportGetTrainedModelsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, TrainedModelProvider trainedModelProvider) {
        super("cluster:monitor/xpack/ml/inference/get", transportService, actionFilters, GetTrainedModelsAction.Request::new);
        this.provider = trainedModelProvider;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, GetTrainedModelsAction.Request request, ActionListener<GetTrainedModelsAction.Response> listener) {
        GetTrainedModelsAction.Response.Builder responseBuilder = GetTrainedModelsAction.Response.builder();
        ActionListener idExpansionListener = ActionListener.wrap(totalAndIds -> {
            responseBuilder.setTotalCount(((Long)totalAndIds.v1()).longValue());
            if (((Map)totalAndIds.v2()).isEmpty()) {
                listener.onResponse((Object)responseBuilder.build());
                return;
            }
            if (request.getIncludes().isIncludeModelDefinition() && ((Map)totalAndIds.v2()).size() > 1) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Getting model definition is not supported when getting more than one model", (Object[])new Object[0]));
                return;
            }
            if (request.getIncludes().isIncludeModelDefinition()) {
                Map.Entry modelIdAndAliases = ((Map)totalAndIds.v2()).entrySet().iterator().next();
                this.provider.getTrainedModel((String)modelIdAndAliases.getKey(), (Set)modelIdAndAliases.getValue(), request.getIncludes(), (ActionListener<TrainedModelConfig>)ActionListener.wrap(config -> listener.onResponse((Object)responseBuilder.setModels(Collections.singletonList(config)).build()), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                this.provider.getTrainedModels((Map)totalAndIds.v2(), request.getIncludes(), request.isAllowNoResources(), (ActionListener<List<TrainedModelConfig>>)ActionListener.wrap(configs -> listener.onResponse((Object)responseBuilder.setModels(configs).build()), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.provider.expandIds(request.getResourceId(), request.isAllowNoResources(), request.getPageParams(), new HashSet<String>(request.getTags()), ModelAliasMetadata.fromState(this.clusterService.state()), (ActionListener<Tuple<Long, Map<String, Set<String>>>>)idExpansionListener);
    }
}

