/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetJobModelSnapshotsUpgradeStatsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;

public class TransportGetJobModelSnapshotsUpgradeStatsAction
extends TransportMasterNodeReadAction<GetJobModelSnapshotsUpgradeStatsAction.Request, GetJobModelSnapshotsUpgradeStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetJobModelSnapshotsUpgradeStatsAction.class);
    private final JobConfigProvider jobConfigProvider;

    @Inject
    public TransportGetJobModelSnapshotsUpgradeStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobConfigProvider jobConfigProvider) {
        super("cluster:monitor/xpack/ml/job/model_snapshots/upgrade/stats/get", transportService, clusterService, threadPool, actionFilters, GetJobModelSnapshotsUpgradeStatsAction.Request::new, indexNameExpressionResolver, GetJobModelSnapshotsUpgradeStatsAction.Response::new, "same");
        this.jobConfigProvider = jobConfigProvider;
    }

    protected void masterOperation(Task task, GetJobModelSnapshotsUpgradeStatsAction.Request request, ClusterState state, ActionListener<GetJobModelSnapshotsUpgradeStatsAction.Response> listener) {
        logger.debug(() -> new ParameterizedMessage("[{}] get stats for model snapshot [{}] upgrades", (Object)request.getJobId(), (Object)request.getSnapshotId()));
        PersistentTasksCustomMetadata tasksInProgress = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        Collection snapshotUpgrades = MlTasks.snapshotUpgradeTasks((PersistentTasksCustomMetadata)tasksInProgress);
        ActionListener expandIdsListener = ActionListener.wrap(jobs -> {
            ExpandedIdsMatcher requiredSnapshotIdMatches = new ExpandedIdsMatcher(request.getSnapshotId(), request.allowNoMatch());
            Set jobIds = jobs.stream().map(Job.Builder::getId).collect(Collectors.toSet());
            List statsList = snapshotUpgrades.stream().filter(t -> jobIds.contains(((SnapshotUpgradeTaskParams)t.getParams()).getJobId())).filter(t -> requiredSnapshotIdMatches.idMatches(((SnapshotUpgradeTaskParams)t.getParams()).getSnapshotId())).map(t -> {
                SnapshotUpgradeTaskParams params = (SnapshotUpgradeTaskParams)t.getParams();
                GetJobModelSnapshotsUpgradeStatsAction.Response.JobModelSnapshotUpgradeStats.Builder statsBuilder = GetJobModelSnapshotsUpgradeStatsAction.Response.JobModelSnapshotUpgradeStats.builder((String)params.getJobId(), (String)params.getSnapshotId());
                if (t.getExecutorNode() != null) {
                    statsBuilder.setNode(state.getNodes().get(t.getExecutorNode()));
                }
                return statsBuilder.setUpgradeState(MlTasks.getSnapshotUpgradeState((PersistentTasksCustomMetadata.PersistentTask)t)).setAssignmentExplanation(t.getAssignment().getExplanation()).build();
            }).sorted(Comparator.comparing(GetJobModelSnapshotsUpgradeStatsAction.Response.JobModelSnapshotUpgradeStats::getJobId).thenComparing(GetJobModelSnapshotsUpgradeStatsAction.Response.JobModelSnapshotUpgradeStats::getSnapshotId)).collect(Collectors.toList());
            requiredSnapshotIdMatches.filterMatchedIds((Collection)statsList.stream().map(GetJobModelSnapshotsUpgradeStatsAction.Response.JobModelSnapshotUpgradeStats::getSnapshotId).collect(Collectors.toList()));
            if (requiredSnapshotIdMatches.hasUnmatchedIds()) {
                listener.onFailure((Exception)new ResourceNotFoundException("no snapshot upgrade is running for snapshot_id [{}]", new Object[]{requiredSnapshotIdMatches.unmatchedIdsString()}));
            } else {
                listener.onResponse((Object)new GetJobModelSnapshotsUpgradeStatsAction.Response(new QueryPage(statsList, (long)statsList.size(), GetJobModelSnapshotsUpgradeStatsAction.RESULTS_FIELD)));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobConfigProvider.expandJobs(request.getJobId(), request.allowNoMatch(), true, (ActionListener<List<Job.Builder>>)expandIdsListener);
    }

    protected ClusterBlockException checkBlock(GetJobModelSnapshotsUpgradeStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

