/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationMetadata;
import org.elasticsearch.xpack.ml.inference.ingest.InferenceProcessor;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportDeleteTrainedModelAction
extends AcknowledgedTransportMasterNodeAction<DeleteTrainedModelAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTrainedModelAction.class);
    private final Client client;
    private final TrainedModelProvider trainedModelProvider;
    private final InferenceAuditor auditor;
    private final IngestService ingestService;

    @Inject
    public TransportDeleteTrainedModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Client client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TrainedModelProvider configProvider, InferenceAuditor auditor, IngestService ingestService) {
        super("cluster:admin/xpack/ml/inference/delete", transportService, clusterService, threadPool, actionFilters, DeleteTrainedModelAction.Request::new, indexNameExpressionResolver, "same");
        this.client = client;
        this.trainedModelProvider = configProvider;
        this.ingestService = ingestService;
        this.auditor = Objects.requireNonNull(auditor);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void masterOperation(Task task, DeleteTrainedModelAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        logger.debug(() -> new ParameterizedMessage("[{}] Request to delete trained model{}", (Object)request.getId(), (Object)(request.isForce() ? " (force)" : "")));
        String id = request.getId();
        IngestMetadata currentIngestMetadata = (IngestMetadata)state.metadata().custom("ingest");
        Set<String> referencedModels = TransportDeleteTrainedModelAction.getReferencedModelKeys(currentIngestMetadata, this.ingestService);
        if (!request.isForce() && referencedModels.contains(id)) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete model [{}] as it is still referenced by ingest processors; use force to delete the model", RestStatus.CONFLICT, new Object[]{id}));
            return;
        }
        List<String> modelAliases = TransportDeleteTrainedModelAction.getModelAliases(state, id);
        if (!request.isForce()) {
            Optional<String> referencedModelAlias = modelAliases.stream().filter(referencedModels::contains).findFirst();
            if (referencedModelAlias.isPresent()) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete model [{}] as it has a model_alias [{}] that is still referenced by ingest processors; use force to delete the model", RestStatus.CONFLICT, new Object[]{id, referencedModelAlias.get()}));
                return;
            }
        }
        if (!TrainedModelAllocationMetadata.fromState(state).isAllocated(request.getId())) {
            this.deleteAliasesAndModel(request, modelAliases, listener);
            return;
        }
        if (request.isForce()) {
            this.forceStopDeployment(request.getId(), (ActionListener<StopTrainedModelDeploymentAction.Response>)ActionListener.wrap(stopDeploymentResponse -> this.deleteAliasesAndModel(request, modelAliases, listener), arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete model [{}] as it is currently deployed; use force to delete the model", RestStatus.CONFLICT, new Object[]{id}));
    }

    static Set<String> getReferencedModelKeys(IngestMetadata ingestMetadata, IngestService ingestService) {
        HashSet<String> allReferencedModelKeys = new HashSet<String>();
        if (ingestMetadata == null) {
            return allReferencedModelKeys;
        }
        for (Map.Entry entry : ingestMetadata.getPipelines().entrySet()) {
            String pipelineId = (String)entry.getKey();
            Map config = ((PipelineConfiguration)entry.getValue()).getConfigAsMap();
            try {
                Pipeline pipeline = Pipeline.create((String)pipelineId, (Map)config, (Map)ingestService.getProcessorFactories(), (ScriptService)ingestService.getScriptService());
                pipeline.getProcessors().stream().filter(p -> p instanceof InferenceProcessor).map(p -> (InferenceProcessor)((Object)p)).map(InferenceProcessor::getModelId).forEach(allReferencedModelKeys::add);
            }
            catch (Exception ex) {
                logger.warn((Message)new ParameterizedMessage("failed to load pipeline [{}]", (Object)pipelineId), (Throwable)ex);
            }
        }
        return allReferencedModelKeys;
    }

    private static List<String> getModelAliases(ClusterState clusterState, String modelId) {
        ModelAliasMetadata currentMetadata = ModelAliasMetadata.fromState(clusterState);
        ArrayList<String> modelAliases = new ArrayList<String>();
        for (Map.Entry<String, ModelAliasMetadata.ModelAliasEntry> modelAliasEntry : currentMetadata.modelAliases().entrySet()) {
            if (!modelAliasEntry.getValue().getModelId().equals(modelId)) continue;
            modelAliases.add(modelAliasEntry.getKey());
        }
        return modelAliases;
    }

    private void forceStopDeployment(String modelId, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        StopTrainedModelDeploymentAction.Request request = new StopTrainedModelDeploymentAction.Request(modelId);
        request.setForce(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)StopTrainedModelDeploymentAction.INSTANCE, (ActionRequest)request, listener);
    }

    private void deleteAliasesAndModel(final DeleteTrainedModelAction.Request request, final List<String> modelAliases, ActionListener<AcknowledgedResponse> listener) {
        logger.debug(() -> new ParameterizedMessage("[{}] Deleting model", (Object)request.getId()));
        ActionListener nameDeletionListener = ActionListener.wrap(ack -> this.trainedModelProvider.deleteTrainedModel(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
            this.auditor.info(request.getId(), "trained model deleted");
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        if (modelAliases.isEmpty()) {
            nameDeletionListener.onResponse((Object)AcknowledgedResponse.of((boolean)true));
            return;
        }
        this.clusterService.submitStateUpdateTask("delete-trained-model-alias", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, nameDeletionListener){

            public ClusterState execute(ClusterState currentState) {
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                ModelAliasMetadata currentMetadata = ModelAliasMetadata.fromState(currentState);
                if (currentMetadata.modelAliases().isEmpty()) {
                    return currentState;
                }
                HashMap<String, ModelAliasMetadata.ModelAliasEntry> newMetadata = new HashMap<String, ModelAliasMetadata.ModelAliasEntry>(currentMetadata.modelAliases());
                logger.info("[{}] delete model model_aliases {}", (Object)request.getId(), (Object)modelAliases);
                modelAliases.forEach(newMetadata::remove);
                ModelAliasMetadata modelAliasMetadata = new ModelAliasMetadata(newMetadata);
                builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("trained_model_alias", (Metadata.Custom)modelAliasMetadata).build());
                return builder.build();
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    protected ClusterBlockException checkBlock(DeleteTrainedModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

