/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAllocationAction;
import org.elasticsearch.xpack.core.ml.inference.allocation.TrainedModelAllocation;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationClusterService;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationNodeService;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationService;
import org.elasticsearch.xpack.ml.inference.deployment.DeploymentManager;

public class TransportCreateTrainedModelAllocationAction
extends TransportMasterNodeAction<CreateTrainedModelAllocationAction.Request, CreateTrainedModelAllocationAction.Response> {
    private final TrainedModelAllocationClusterService trainedModelAllocationClusterService;

    @Inject
    public TransportCreateTrainedModelAllocationAction(TrainedModelAllocationClusterService trainedModelAllocationClusterService, TrainedModelAllocationService trainedModelAllocationService, DeploymentManager deploymentManager, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
        super("cluster:internal/xpack/ml/model_allocation/create", false, transportService, clusterService, threadPool, actionFilters, CreateTrainedModelAllocationAction.Request::new, indexNameExpressionResolver, CreateTrainedModelAllocationAction.Response::new, "same");
        this.trainedModelAllocationClusterService = trainedModelAllocationClusterService;
        clusterService.addListener((ClusterStateListener)new TrainedModelAllocationNodeService(trainedModelAllocationService, clusterService, deploymentManager, transportService.getTaskManager(), threadPool, licenseState));
    }

    protected void masterOperation(Task task, CreateTrainedModelAllocationAction.Request request, ClusterState state, ActionListener<CreateTrainedModelAllocationAction.Response> listener) throws Exception {
        this.trainedModelAllocationClusterService.createNewModelAllocation(request.getTaskParams(), (ActionListener<TrainedModelAllocation>)ActionListener.wrap(trainedModelAllocation -> listener.onResponse((Object)new CreateTrainedModelAllocationAction.Response(trainedModelAllocation)), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(CreateTrainedModelAllocationAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

