/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.MlMetadata;

class MlUpgradeModeActionFilter
extends ActionFilter.Simple {
    private static final Set<String> ACTIONS_DISALLOWED_IN_UPGRADE_MODE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"cluster:admin/xpack/ml/job/put", "cluster:admin/xpack/ml/job/update", "cluster:admin/xpack/ml/job/delete", "cluster:admin/xpack/ml/job/open", "cluster:admin/xpack/ml/job/flush", "cluster:admin/xpack/ml/job/close", "cluster:admin/xpack/ml/job/persist", "cluster:internal/xpack/ml/job/finalize_job_execution", "cluster:admin/xpack/ml/job/data/post", "cluster:admin/xpack/ml/job/model_snapshots/revert", "cluster:admin/xpack/ml/job/model_snapshots/update", "cluster:admin/xpack/ml/job/model_snapshots/delete", "cluster:admin/xpack/ml/job/model_snapshots/upgrade", "cluster:admin/xpack/ml/datafeeds/put", "cluster:admin/xpack/ml/datafeeds/update", "cluster:admin/xpack/ml/datafeeds/delete", "cluster:admin/xpack/ml/datafeed/start", "cluster:admin/xpack/ml/datafeed/stop", "cluster:admin/xpack/ml/filters/put", "cluster:admin/xpack/ml/filters/update", "cluster:admin/xpack/ml/filters/delete", "cluster:admin/xpack/ml/calendars/put", "cluster:admin/xpack/ml/calendars/jobs/update", "cluster:admin/xpack/ml/calendars/events/post", "cluster:admin/xpack/ml/calendars/delete", "cluster:admin/xpack/ml/calendars/events/delete", "cluster:internal/xpack/ml/job/update/process", "cluster:internal/xpack/ml/job/kill/process", "cluster:admin/xpack/ml/delete_expired_data", "cluster:admin/xpack/ml/job/forecast", "cluster:admin/xpack/ml/job/forecast/delete", "cluster:admin/xpack/ml/data_frame/analytics/put", "cluster:admin/xpack/ml/data_frame/analytics/delete", "cluster:admin/xpack/ml/data_frame/analytics/start", "cluster:admin/xpack/ml/data_frame/analytics/stop", "cluster:admin/xpack/ml/data_frame/analytics/explain", "cluster:admin/xpack/ml/inference/model_aliases/put", "cluster:admin/xpack/ml/inference/put", "cluster:admin/xpack/ml/trained_models/part/put", "cluster:admin/xpack/ml/trained_models/vocabulary/put", "cluster:admin/xpack/ml/trained_models/deployment/start", "cluster:admin/xpack/ml/inference/delete", "cluster:admin/xpack/ml/inference/model_aliases/delete"}));
    private static final Set<String> RESET_MODE_EXEMPTIONS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"cluster:admin/xpack/ml/job/delete", "cluster:admin/xpack/ml/job/close", "cluster:admin/xpack/ml/datafeeds/delete", "cluster:admin/xpack/ml/datafeed/stop", "cluster:internal/xpack/ml/job/kill/process", "cluster:admin/xpack/ml/data_frame/analytics/delete", "cluster:admin/xpack/ml/data_frame/analytics/stop", "cluster:admin/xpack/ml/inference/delete"}));
    private final AtomicReference<UpgradeResetFlags> upgradeResetFlags = new AtomicReference<UpgradeResetFlags>(new UpgradeResetFlags(false, false));

    MlUpgradeModeActionFilter(ClusterService clusterService) {
        Objects.requireNonNull(clusterService);
        clusterService.addListener(this::setUpgradeResetFlags);
    }

    protected boolean apply(String action, ActionRequest request, ActionListener<?> listener) {
        UpgradeResetFlags localUpgradeResetFlags = this.upgradeResetFlags.get();
        assert (localUpgradeResetFlags != null);
        if (localUpgradeResetFlags.isResetMode && RESET_MODE_EXEMPTIONS.contains(action)) {
            return true;
        }
        if (localUpgradeResetFlags.isUpgradeMode && ACTIONS_DISALLOWED_IN_UPGRADE_MODE.contains(action)) {
            throw new ElasticsearchStatusException("Cannot perform {} action while upgrade mode is enabled", RestStatus.TOO_MANY_REQUESTS, new Object[]{action});
        }
        return true;
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    void setUpgradeResetFlags(ClusterChangedEvent event) {
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)event.state());
        this.upgradeResetFlags.set(new UpgradeResetFlags(mlMetadata.isUpgradeMode(), mlMetadata.isResetMode()));
    }

    private static class UpgradeResetFlags {
        final boolean isUpgradeMode;
        final boolean isResetMode;

        UpgradeResetFlags(boolean isUpgradeMode, boolean isResetMode) {
            this.isUpgradeMode = isUpgradeMode;
            this.isResetMode = isResetMode;
        }
    }
}

